<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>فرم نصب انجام‌شده | سلام‌بابا</title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="bar"></div>
    <div class="content">
      <h1>فرم نصب انجام‌شده (بدون امضا)</h1>
    </div>
  </div>

  <div class="card">
  <?php
    $code = $_GET['code'] ?? '';
    $usedFile = __DIR__ . '/used_codes.json';
    if(!file_exists($usedFile)) file_put_contents($usedFile, json_encode([]));
    $used = json_decode(file_get_contents($usedFile), true);
    if(!is_array($used)) $used = [];
    if($code === ''){ echo '<div class="error">کد رهگیری در لینک وجود ندارد.</div>'; exit; }
    if(in_array($code, $used)){ echo '<div class="error">این لینک قبلاً استفاده شده است.</div>'; exit; }

    function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
    $seller   = $_GET['seller']   ?? '';
    $customer = $_GET['customer'] ?? '';
    $province = $_GET['province'] ?? '';
    $address  = $_GET['address']  ?? '';
    $mobile   = $_GET['mobile']   ?? '';
    $model    = $_GET['model']    ?? '';
    $warranty = $_GET['warranty'] ?? '';
  ?>

  <div class="card">
    <h3>مشخصات مشتری</h3>
    <p><b>کد:</b> <?php echo h($code); ?></p>
    <p><b>نام:</b> <?php echo h($customer); ?></p>
    <p><b>استان:</b> <?php echo h($province); ?></p>
    <p><b>آدرس:</b> <?php echo h($address); ?></p>
    <p><b>همراه:</b> <?php echo h($mobile); ?></p>
    <p><b>مدل:</b> <?php echo h($model); ?></p>
    <p><b>گارانتی:</b> <?php echo h($warranty); ?></p>
  </div>

  <form id="installForm" action="install_send.php" method="post" enctype="multipart/form-data">
    <input type="hidden" name="code" value="<?php echo h($code); ?>">
    <input type="hidden" name="seller" value="<?php echo h($seller); ?>">
    <input type="hidden" name="customer" value="<?php echo h($customer); ?>">
    <input type="hidden" name="province" value="<?php echo h($province); ?>">
    <input type="hidden" name="address" value="<?php echo h($address); ?>">
    <input type="hidden" name="mobile" value="<?php echo h($mobile); ?>">
    <input type="hidden" name="model" value="<?php echo h($model); ?>">
    <input type="hidden" name="warranty" value="<?php echo h($warranty); ?>">

    <label>نام سرویس‌کار</label>
    <input type="text" name="installer_name" required>

    <label>تاریخ نصب</label>
    <input type="text" name="install_date" required>

    <label>شماره سریال کالا</label>
    <input type="text" name="serial_number" required>

    <label>توضیحات نصب</label>
    <textarea name="notes" rows="3"></textarea>

    <label>عکس نصب‌شده</label>
    <input type="file" name="photo" accept="image/*" required>

    <input type="hidden" name="signature_customer" value="">
    <input type="hidden" name="signature_installer" value="">

    <button type="submit">ارسال اطلاعات نصب به تلگرام</button>
    <div id="resp"></div>
  </form>
  </div>
</div>

<script>

document.querySelector('form').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  const btn = e.target.querySelector('button[type="submit"]');
  const resp = document.getElementById('resp') || document.createElement('div');
  if(!resp.id){ resp.id='resp'; e.target.appendChild(resp); }
  const scrollY = window.scrollY;
  const originalText = btn.textContent;
  btn.disabled = true;
  btn.textContent = 'در حال ارسال...';
  resp.textContent = 'در حال ارسال...';
  try{
    const res = await fetch(e.target.action,{method:'POST',body:fd});
    const j = await res.json();
    if(j.success){
      resp.textContent = '✅ عملیات با موفقیت انجام شد' + (j.code ? ' | کد: '+j.code : '');
    } else {
      resp.textContent = '❌ ' + (j.error || 'خطا در ارسال');
    }
  }catch(err){
    resp.textContent = '❌ خطای شبکه: ' + err.message;
  }
  btn.disabled = false;
  btn.textContent = originalText;
  window.scrollTo({top: scrollY, behavior: 'instant'});
});
</script>

</body></html>
