<?php
error_reporting(0);
ini_set('display_errors', 0);
header('Content-Type: application/json; charset=utf-8');
ob_clean();

// اتصال به دیتابیس
$db = new mysqli('localhost','slmbredirects_guaranti','Reza1372!@','slmbredirects_guaranti');
if ($db->connect_error) {
  echo json_encode(['success'=>false,'error'=>'❌ خطا در اتصال به دیتابیس']);
  exit;
}
$db->set_charset('utf8mb4');

// محدودیت تعداد دفعات مجاز
$maxInstallsPerCode = 3; // تغییر بده اگر می‌خوای مثلاً 5 بار بشه

// دریافت کد رهگیری
$code = isset($_POST['code']) ? trim($_POST['code']) : (isset($_GET['code']) ? trim($_GET['code']) : '');
if ($code === '') {
  echo json_encode(['success'=>false,'error'=>'❌ کد رهگیری ارسال نشده است']);
  exit;
}

// بررسی تعداد دفعات ثبت برای این کد
$res = $db->query("SELECT COUNT(*) AS c FROM installations WHERE tracking_code='$code'");
$count = ($res && $r = $res->fetch_assoc()) ? intval($r['c']) : 0;
if ($count >= $maxInstallsPerCode) {
  echo json_encode(['success'=>false,'error'=>'⚠️ این کد قبلاً استفاده شده و به سقف مجاز ('.$maxInstallsPerCode.' بار) رسیده است.']);
  exit;
}

// فیلدهای اجباری
$required = ['installer_name','install_date','serial_number'];
foreach ($required as $f) {
  if (empty($_POST[$f])) {
    echo json_encode(['success'=>false,'error'=>"فیلد '$f' خالی است"]);
    exit;
  }
}

// داده‌ها
$installer = $db->real_escape_string($_POST['installer_name']);
$date      = $db->real_escape_string($_POST['install_date']);
$serial    = $db->real_escape_string($_POST['serial_number']);
$notes     = $db->real_escape_string($_POST['notes'] ?? '');
$sigCustomer = $_POST['signature_customer'] ?? '';
$sigInstaller = $_POST['signature_installer'] ?? '';

// آپلود عکس
$uploadDir = __DIR__ . '/uploads/';
if(!is_dir($uploadDir)) mkdir($uploadDir,0775,true);
$filename = uniqid('photo_') . '.' . pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
$targetPath = $uploadDir . $filename;
move_uploaded_file($_FILES['photo']['tmp_name'], $targetPath);

// آدرس نسبی برای ذخیره در دیتابیس:
$photoPath = 'uploads/' . $filename;
// درج در دیتابیس
$sql = "INSERT INTO installations 
(tracking_code, installer_name, install_date, serial_number, photo_path, signature_customer, signature_installer, notes, created_at)
VALUES ('$code','$installer','$date','$serial','$photoPath','$sigCustomer','$sigInstaller','$notes',NOW())";
if(!$db->query($sql)){
  echo json_encode(['success'=>false,'error'=>'❌ خطا در ذخیره اطلاعات در دیتابیس: '.$db->error]);
  exit;
}

// ارسال به تلگرام
$botToken = "490048283:AAGEC4Cj0c8SkIicNrMXl7QNDLC2rKK5LAs";
$chatID   = "-1003058637754";
$message  = "🛠️ <b>نصب انجام‌شده</b>\n\n"
           ."کد رهگیری: <b>$code</b>\n"
           ."👷‍♂️ سرویس‌کار: $installer\n📅 تاریخ نصب: $date\n🔢 سریال: $serial\n💬 توضیحات: $notes\n"
           ."📄 دفعات استفاده از این کد: ".($count+1)."/$maxInstallsPerCode";

if($photoPath!=''){
  $photoUrl = "https://salambaba.co/guaranti/$photoPath";
  $payload = [
      'chat_id' => $chatID,
      'caption' => $message,
      'photo' => $photoUrl,
      'parse_mode' => 'HTML'
  ];
  $url = "https://api.telegram.org/bot$botToken/sendPhoto";
} else {
  $payload = [
      'chat_id' => $chatID,
      'text' => $message,
      'parse_mode' => 'HTML'
  ];
  $url = "https://api.telegram.org/bot$botToken/sendMessage";
}

$ch = curl_init($url);
curl_setopt_array($ch, [
  CURLOPT_POST => true,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_TIMEOUT => 10,
  CURLOPT_POSTFIELDS => $payload,
]);
curl_exec($ch);
curl_close($ch);

// پاسخ نهایی
echo json_encode(['success'=>true,'code'=>$code]);
exit;
?>
