<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/db_connect.php';

$user = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';
$full_name = '';

if ($user && isset($mysqli) && $mysqli instanceof mysqli) {
    $stmt = $mysqli->prepare("SELECT full_name FROM users WHERE username=? LIMIT 1");
    if ($stmt) {
        $stmt->bind_param("s", $user);
        $stmt->execute();
        $stmt->bind_result($full_name);
        $stmt->fetch();
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<link rel="stylesheet" href="assets/style.css">
<title>مدیریت سفارشات</title>
<link rel="stylesheet" href="/orders/assets/header.css">
</head>
<body>

<header class="brand">
  <div class="header-right">
    <button class="menu-toggle" id="menuToggle">☰</button>
    <div class="logo">سلامـ بابا</div>
  </div>

  <div class="header-left">
<a href="https://salambaba.co/orders/sb-admin/profile.php" class="user-info">👤 <?php echo htmlspecialchars($full_name ?: $user); ?></a>

  <div class="nav-menu" id="navMenu">
          <?php if ($role === 'admin'): ?>
          <a href="https://salambaba.co/orders/index.php">🏠 خانه</a>
              <?php endif; ?>
    <!-- 🔴 لینک‌های مخصوص admin + seller -->
    <?php if ($role === 'admin' || $role === 'seller'): ?>
        <a href="https://salambaba.co/orders/new.php">🛒 فاکتور جدید</a>
        <a href="https://salambaba.co/orders/orders.php">🛍️ فاکتورها</a>
                <a href="https://salambaba.co/orders/payment/withdraw.php">🛒 برداشت</a>
    <?php endif; ?>
        <?php if ($role === 'seller'): ?>
    <a href="https://salambaba.co/orders/finance/seller.php">💰 مانده حساب</a>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
      <a href="https://salambaba.co/orders/finance/admin.php">📊 مانده حساب</a>
    <?php endif; ?>
    <?php if ($role === 'admin'): ?>
      <a href="https://salambaba.co/orders/reports.php">📊 گزارش ماهانه</a>
    <?php endif; ?>
        <?php if ($role === 'admin'): ?>
        <a href="https://salambaba.co/orders/payment/withdraw_list.php">🛒 گزارش برداشت</a>
    <?php endif; ?>
            <?php if ($role === 'admin'): ?>
        <a href="https://salambaba.co/orders/sb-admin/telegram_channels.php">🛢️ کانالهای تلگرام</a>
    <?php endif; ?>
    <?php if ($role === 'admin'): ?>
    <a href="https://salambaba.co/orders/buyer/">🧾 مسئول خرید</a>
<?php endif; ?>
<?php if (in_array($_SESSION['role'] ?? '', ['admin','head_carrier','logistic'], true)): ?> <a href="/orders/head/index.php">🚚 پنل سر باربر</a> <?php endif; ?>
    <?php if ($role === 'buyer_manager'): ?>
    <a href="/orders/buyer/index.php">🏠 خانه</a>
        <a href="https://salambaba.co/orders/buyer/index.php?q=&status=assigned_to_buyer">🧾 سفارشات ارجاع داده شده</a>
        <a href="/orders/buyer/buyers.php?status=assigned_to_buyer">🛒 سفارشات در انتظار خرید</a>
    <?php endif; ?>
<?php if ($role === 'logistic'): ?>
    <a href="/orders/management/logistic.php">🚚 سفارشات آماده ارسال</a>
<?php endif; ?>
        <a href="https://salambaba.co/orders/product/">🛒 محصولات</a>

    <a class="danger" href="https://salambaba.co/orders/logout.php">خروج</a>
        <?php if ($role === 'admin'): ?>

  <a class="danger" href="https://salambaba.co/orders/sb-admin/users/user.php">کارمندان</a>
    <?php endif; ?>

  </div>
</header>

<div class="nav-overlay" id="navOverlay"></div>

<script>
// همبرگری و پس‌زمینه تار
const toggle = document.getElementById('menuToggle');
const menu = document.getElementById('navMenu');
const overlay = document.getElementById('navOverlay');

toggle.addEventListener('click', () => {
  menu.classList.toggle('active');
  overlay.classList.toggle('active');
});

// کلیک بیرون از منو = بستن
overlay.addEventListener('click', () => {
  menu.classList.remove('active');
  overlay.classList.remove('active');
});
</script>

</body>
</html>
