<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

header('Content-Type: application/json; charset=utf-8');

$id    = (int)($_POST['id'] ?? 0);
$field = $_POST['field'] ?? '';
$value = trim($_POST['value'] ?? '');

if ($id <= 0) {
    echo json_encode(['status'=>'error','msg'=>'ID نامعتبر']);
    exit;
}

$allowed = ['title','brand','model','price','category'];
if (!in_array($field, $allowed, true)) {
    echo json_encode(['status'=>'error','msg'=>'فیلد نامعتبر']);
    exit;
}

if ($field === 'price') {
    $value = (int)$value;
}

$stmt = $mysqli->prepare("UPDATE product SET {$field}=? WHERE id=?");
if ($field === 'price') {
    $stmt->bind_param("ii", $value, $id);
} else {
    $stmt->bind_param("si", $value, $id);
}
$stmt->execute();

echo json_encode(['status'=>'success']);
exit;
