<?php
require __DIR__.'/../../includes/auth.php';
require __DIR__.'/../../includes/config.php';
require __DIR__.'/../../includes/db_connect.php';
require __DIR__.'/../../includes/jdf.php';

if(($_SESSION['role'] ?? '') !== 'admin'){
    http_response_code(403);
    exit('دسترسي مجاز نيست');
}

$id = intval($_GET['id'] ?? 0);
if($id <= 0){
    exit("کاربر يافت نشد");
}

$stmt = $mysqli->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$u = $stmt->get_result()->fetch_assoc();

if(!$u){
    exit("کاربر يافت نشد");
}

function toJ($d){
    if(!$d || !preg_match('/^\d+/', $d)) return '-';
    list($y,$m,$d2) = explode('-', substr($d,0,10));
    return gregorian_to_jalali($y,$m,$d2,'/');
}

$uploadBase = "/orders/uploads/logistic/";

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>نمايش کاربر</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="user.css">


</head>

<body>

<?php require __DIR__.'/../../includes/header.php'; ?>

<div class="saas-container">

    <a class="back-btn" href="user.php">بازگشت</a>

    <h1 class="saas-title">مشاهده اطلاعات کاربر</h1>

    <!-- اطلاعات اصلی -->
    <div class="saas-card">
        <div class="saas-card-title">مشخصات فردي</div>
        <div class="saas-card-content">

            <p><strong>نام:</strong> <?= htmlspecialchars($u['full_name'] ?? '') ?></p>
            <p><strong>نام کاربري:</strong> <?= htmlspecialchars($u['username'] ?? '') ?></p>
            <p><strong>موبايل:</strong> <?= htmlspecialchars($u['mobile'] ?? '') ?></p>
            <p><strong>کد ملي:</strong> <?= htmlspecialchars($u['national_id'] ?? '') ?></p>
            <p><strong>تاريخ تولد:</strong> <?= toJ($u['birthdate']) ?></p>
            <p><strong>آدرس:</strong> <?= nl2br(htmlspecialchars($u['address'] ?? '')) ?></p>

            <p><strong>نقش:</strong> 
                <span class="badge" style="background:#e0f2fe;color:#0369a1;">
                    <?= htmlspecialchars($u['role'] ?? '') ?>
                </span>
            </p>

            <p><strong>وضعيت:</strong>
                <?php if($u['is_approved']==0): ?>
                    <span class="badge badge-wait">منتظر تاييد</span>
                <?php elseif($u['is_approved']==1): ?>
                    <span class="badge badge-ok">تاييد شده</span>
                <?php else: ?>
                    <span class="badge badge-no">رد شده</span>
                <?php endif; ?>
            </p>

            <p><strong>تاريخ درخواست:</strong> <?= $u['requested_at'] ?></p>
            <p><strong>تاييد شده توسط:</strong> <?= htmlspecialchars($u['approved_by'] ?? '-') ?></p>
            <p><strong>تاريخ تاييد:</strong> <?= $u['approved_at'] ?></p>

        </div>
    </div>

    <!-- اطلاعات وسيله -->
    <div class="saas-card">
        <div class="saas-card-title">اطلاعات وسيله نقليه</div>
        <div class="saas-card-content">
            <p><strong>وسيله:</strong> <?= htmlspecialchars($u['vehicle'] ?? '') ?></p>
            <p><strong>پلاک:</strong> <?= htmlspecialchars($u['plate'] ?? '') ?></p>
        </div>
    </div>

    <!-- عکس‌ها -->
    <div class="saas-card">
        <div class="saas-card-title">عکس‌ها و مدارک</div>

        <div class="photo-box">

            <?php if(!empty($u['photo_face'])): ?>
            <div class="photo-card">
                <span>عکس چهره</span>
                <img src="<?= $uploadBase.$u['photo_face'] ?>" class="view-photo">
            </div>
            <?php endif; ?>

            <?php if(!empty($u['photo_nid'])): ?>
            <div class="photo-card">
                <span>کارت ملي</span>
                <img src="<?= $uploadBase.$u['photo_nid'] ?>" class="view-photo">
            </div>
            <?php endif; ?>

            <?php if(!empty($u['photo_car'])): ?>
            <div class="photo-card">
                <span>مدرک خودرو</span>
                <img src="<?= $uploadBase.$u['photo_car'] ?>" class="view-photo">
            </div>
            <?php endif; ?>

            <?php if(empty($u['photo_face']) && empty($u['photo_nid']) && empty($u['photo_car'])): ?>
                <p>هيچ عکسي ثبت نشده است.</p>
            <?php endif; ?>

        </div>
    </div>

</div>

</body>
</html>
