<?php
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

$q = trim($_GET['q'] ?? '');
$q = "%{$q}%";

$stmt = $mysqli->prepare("SELECT id, model FROM products WHERE model LIKE ? LIMIT 20");
$stmt->bind_param("s", $q);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($r = $res->fetch_assoc()) {
    $data[] = [
        'id'    => $r['id'],
        'text'  => $r['model']
    ];
}

header('Content-Type: application/json');
echo json_encode(['results' => $data]);
exit;
