<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require_once __DIR__.'/../includes/jdf.php';

$role = $_SESSION['role'] ?? '';
if ($role !== 'admin') {
    header('Location: seller.php');
    exit;
}

function nf($n){ return number_format((int)$n, 0, '.', ','); }

if (!function_exists('toJalaliEn')) {
    function toJalaliEn($date){
        if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
        list($gy,$gm,$gd) = explode('-', substr($date,0,10));
        if(!function_exists('gregorian_to_jalali')) return $date;
        return gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    }
}

// ------------------ فیلترها ------------------
$filterSeller = trim($_GET['seller'] ?? '');
$filterMonth  = $_GET['month'] ?? date('Y-m');

list($fy, $fm) = explode('-', $filterMonth);
$monthStart = "$fy-$fm-01 00:00:00";
$monthEnd   = date('Y-m-t 23:59:59', strtotime($monthStart));

// آمار کلی همه فروشنده‌ها
$summaryRes = $mysqli->query("
    SELECT 
      (SELECT COALESCE(SUM(total_deposit),0) FROM orders) AS all_deposit,
      (SELECT COALESCE(SUM(w.amount),0) 
         FROM withdrawals w
         JOIN orders o ON o.id = w.order_id) AS all_withdraw
");
$summary = $summaryRes->fetch_assoc();
$allDeposit  = (int)$summary['all_deposit'];
$allWithdraw = (int)$summary['all_withdraw'];
$allBalance  = $allDeposit - $allWithdraw;

// لیست فروشنده‌ها + آمار
$sql = "
  SELECT 
    u.username,
    u.full_name,
    u.balance,
    (SELECT COALESCE(SUM(total_deposit),0) 
       FROM orders 
       WHERE username = u.username
         AND created_at BETWEEN '$monthStart' AND '$monthEnd') AS month_deposit,
    (SELECT COALESCE(SUM(w.amount),0)
       FROM withdrawals w
       JOIN orders o ON o.id = w.order_id
      WHERE o.username = u.username
        AND o.created_at BETWEEN '$monthStart' AND '$monthEnd') AS month_withdraw
  FROM users u
  WHERE u.role = 'seller'
";

if ($filterSeller !== '') {
    $safe = $mysqli->real_escape_string($filterSeller);
    $sql .= " AND u.username LIKE '%$safe%'";
}

$sql .= " ORDER BY u.username ASC";
$sellersRes = $mysqli->query($sql);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>📊 داشبورد مالی مدیر | سلام‌بابا</title>
<link rel="stylesheet" href="../assets/style.css">
<style>
body {
  font-family: 'IRANSansWeb','IRANYekan',sans-serif;
  background:#f3f4f6;
  margin:0;
  color:#0f172a;
}
.container {
  max-width:1200px;
  margin:0 auto;
  padding:20px;
}
.card {
  background:#fff;
  border-radius:16px;
  box-shadow:0 2px 10px rgba(15,23,42,0.08);
  padding:20px 24px;
  margin-bottom:20px;
}
.card h3 {
  margin:0 0 12px;
  font-size:18px;
  display:flex;
  align-items:center;
  gap:6px;
}
.stats {
  display:flex;
  flex-wrap:wrap;
  gap:12px;
  margin-top:10px;
}
.stat {
  flex:1 1 200px;
  background:linear-gradient(135deg,#eff6ff,#ffffff);
  border-radius:14px;
  padding:14px 16px;
  border:1px solid #e5e7eb;
}
.stat span {
  display:block;
  font-size:13px;
  color:#6b7280;
}
.stat b {
  display:block;
  margin-top:4px;
  font-size:18px;
}
.stat.deposit b { color:#0ea5e9; }
.stat.withdraw b { color:#f97316; }
.stat.balance b { color:#22c55e; }

.filter-row {
  display:flex;
  flex-wrap:wrap;
  gap:10px;
  align-items:center;
  margin-top:10px;
}
.filter-row label {
  font-size:13px;
  color:#374151;
}
.filter-row input[type="month"],
.filter-row input[type="text"] {
  padding:6px 10px;
  border-radius:8px;
  border:1px solid #d1d5db;
  font-size:13px;
}
.filter-row button {
  background:#2563eb;
  color:#fff;
  border:none;
  border-radius:8px;
  padding:7px 14px;
  cursor:pointer;
  font-size:13px;
}
.filter-row button:hover { background:#1d4ed8; }

.table-wrapper {
  margin-top:12px;
  background:#fff;
  border-radius:12px;
  border:1px solid #e5e7eb;
  overflow-x:auto;
}
table {
  width:100%;
  border-collapse:collapse;
  min-width:800px;
  font-size:13px;
}
th,td {
  padding:8px 10px;
  text-align:center;
  border-bottom:1px solid #f1f5f9;
  white-space:nowrap;
}
th {
  background:#f9fafb;
  font-weight:600;
  color:#111827;
  position:sticky;
  top:0;
  z-index:1;
}
tr:nth-child(even) td { background:#f9fafb; }
tr:hover td { background:#eff6ff; }

.badge {
  display:inline-block;
  padding:2px 8px;
  border-radius:999px;
  font-size:11px;
}
.badge.pos { background:#dcfce7; color:#166534; }
.badge.neg { background:#fee2e2; color:#b91c1c; }

.btn {
  background:#2563eb;
  color:#fff;
  padding:4px 10px;
  border-radius:8px;
  font-size:12px;
  text-decoration:none;
  display:inline-block;
}
.btn:hover { background:#1d4ed8; }
.btn.ghost {
  background:#f3f4f6;
  color:#111827;
}
.btn.ghost:hover { background:#e5e7eb; }

@media (max-width:768px){
  .container { padding:10px; }
  table { font-size:12px; }
  th,td { padding:6px 8px; }
}
</style>
</head>
<body>
<div class="container">
<?php require __DIR__.'/../includes/header.php'; ?>

<section class="card">
  <h3>📊 داشبورد مالی مدیر</h3>
  <div class="stats">
    <div class="stat deposit">
      <span>جمع کل بیعانه‌ها (تمام سیستم)</span>
      <b><?=nf($allDeposit)?> تومان</b>
    </div>
    <div class="stat withdraw">
      <span>جمع کل برداشت‌ها (تمام سیستم)</span>
      <b><?=nf($allWithdraw)?> تومان</b>
    </div>
    <div class="stat balance">
      <span>مانده تجمعی (نزد سلام‌بابا)</span>
      <b><?=nf($allBalance)?> تومان</b>
    </div>
  </div>

  <form method="get" class="filter-row">
    <label>ماه:</label>
    <input type="month" name="month" value="<?=$filterMonth?>">
    <label>فروشنده:</label>
    <input type="text" name="seller" placeholder="username فروشنده..." value="<?=htmlspecialchars($filterSeller)?>">
    <button type="submit">اعمال فیلتر</button>
    <a class="btn ghost" href="../">⬅ بازگشت</a>
  </form>
</section>

<section class="card">
  <h3>👤 لیست فروشنده‌ها و وضعیت ماه انتخابی</h3>
  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>فروشنده</th>
          <th>نام کامل</th>
          <th>بیعانه این ماه</th>
          <th>برداشت این ماه</th>
          <th>مانده فعلی (از جدول users)</th>
          <th>وضعیت</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
      <?php if($sellersRes->num_rows === 0): ?>
        <tr><td colspan="7">هیچ فروشنده‌ای پیدا نشد.</td></tr>
      <?php else: ?>
        <?php while($row = $sellersRes->fetch_assoc()): 
            $monthDep  = (int)$row['month_deposit'];
            $monthWdr  = (int)$row['month_withdraw'];
            $balance   = (int)$row['balance'];
            $badgeCls  = $balance >= 0 ? 'pos' : 'neg';
            $badgeTxt  = $balance >= 0 ? 'مثبت' : 'بدهکار';
        ?>
          <tr>
            <td><?=htmlspecialchars($row['username'])?></td>
            <td><?=htmlspecialchars($row['full_name'])?></td>
            <td><?=nf($monthDep)?></td>
            <td><?=nf($monthWdr)?></td>
            <td><?=nf($balance)?></td>
            <td><span class="badge <?=$badgeCls?>"><?=$badgeTxt?></span></td>
            <td>
              <a class="btn" href="seller.php?username=<?=urlencode($row['username'])?>">📄 مشاهده حساب</a>
              <a class="btn ghost" href="edit_seller.php?username=<?=urlencode($row['username'])?>">✏️ ویرایش فروشنده</a>
            </td>
          </tr>
        <?php endwhile; ?>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
</div>
</body>
</html>
