<?php
// orders/delivery/delivery.php
// فرم تحویل سفارش برای راننده (بدون نیاز به لاگین) با لینک رمزدار

require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';

// اگر به هر دلیل در config تعریف نشده بود، این خط فقط یک مقدار موقت میگذارد
if (!defined('DELIVERY_LINK_SECRET')) {
    define('DELIVERY_LINK_SECRET', 'CHANGE_ME_DELIVERY_SECRET_123456');
}

// ساخت توکن امن بر اساس order_uid
function make_delivery_token($order_uid) {
    return hash_hmac('sha256', $order_uid, DELIVERY_LINK_SECRET);
}

function e($s) {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

// مپ وضعیت ها (برای نمایش فقط)
$status_map = [
    'new'               => '🕓 ثبت شده (در انتظار بررسی)',
    'assigned_to_buyer' => '📌 ارجاع به مسئول خرید',
    'purchased'         => '🛒 خریداری شده',
    'handover_to_head'  => '📦 تحویل به سر باربر',
    'out_for_delivery'  => '🚚 در حال ارسال',
    'delivered'         => '✅ تحویل داده شد',
    'failed'            => '❌ تحویل ناموفق',
];

$code  = trim($_GET['code'] ?? '');
$token = trim($_GET['token'] ?? '');

$order        = null;
$order_items  = [];
$errors       = [];
$success      = '';

// ------------- واکشی سفارش و اعتبارسنجی لینک -------------
if ($code === '' || $token === '') {
    $errors[] = 'دسترسی مجاز نیست (پارامترهای لینک ناقص است).';
} else {
    // سفارش بر اساس tracking_code
    $st = $mysqli->prepare("SELECT * FROM orders WHERE tracking_code=? LIMIT 1");
    $st->bind_param('s', $code);
    $st->execute();
    $res   = $st->get_result();
    $order = $res->fetch_assoc();
    $st->close();

    if (!$order) {
        $errors[] = 'سفارش با این کد پیگیری یافت نشد.';
    } else {
        // چک توکن
        $expected = make_delivery_token($order['order_uid']);
        if (!hash_equals($expected, $token)) {
            $errors[] = 'لینک تحویل معتبر نیست.';
            $order    = null;
        } else {
            // اقلام سفارش
            $st2 = $mysqli->prepare("SELECT * FROM order_items WHERE order_id=?");
            $st2->bind_param('i', $order['id']);
            $st2->execute();
            $res2 = $st2->get_result();
            while ($row = $res2->fetch_assoc()) {
                $order_items[] = $row;
            }
            $st2->close();
        }
    }
}

// ------------- هندل ارسال فرم تحویل -------------
if ($order && $_SERVER['REQUEST_METHOD'] === 'POST') {

    $delivery_status = $_POST['delivery_status'] ?? '';
    $driver_name     = trim($_POST['driver_name'] ?? '');
    $serial_number   = trim($_POST['serial_number'] ?? '');
    $customer_name   = trim($_POST['customer_name'] ?? '');
    $customer_phone  = trim($_POST['customer_phone'] ?? '');
    $address_snap    = trim($_POST['address_snapshot'] ?? '');
    $note            = trim($_POST['note'] ?? '');

    if ($delivery_status !== 'delivered' && $delivery_status !== 'failed') {
        $errors[] = 'وضعیت تحویل را انتخاب کنید.';
    }

    // مسیرهای ذخیره فایل - هم‌خوان با پنل سر باربر
    $upload_base   = __DIR__ . '/../uploads/delivery';
    $photo_dir     = $upload_base . '/photos';
    $media_dir     = $upload_base . '/media';

    foreach ([$upload_base, $photo_dir, $media_dir] as $dir) {
        if (!is_dir($dir)) {
            @mkdir($dir, 0775, true);
        }
    }

    $photo1  = null;
    $photo2  = null;
    $photo3  = null;
    $video1  = null;
    $hasFile = false;

    // عکس‌ها
    $photo_fields = ['photo1', 'photo2', 'photo3'];
    foreach ($photo_fields as $field) {
        if (!empty($_FILES[$field]['name'])) {
            $file = $_FILES[$field];

            if ($file['error'] === UPLOAD_ERR_OK) {
                $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
                $allowed_img = ['jpg', 'jpeg', 'png', 'webp'];
                if (!in_array($ext, $allowed_img, true)) {
                    $errors[] = "فرمت فایل {$field} مجاز نیست.";
                } else {
                    $newName = 'o' . $order['id'] . '_' . time() . '_' . $field . '.' . $ext;
                    $target  = $photo_dir . '/' . $newName;
                    if (move_uploaded_file($file['tmp_name'], $target)) {
                        $hasFile = true;
                        $relPath = 'uploads/delivery/photos/' . $newName;
                        if ($field === 'photo1') $photo1 = $relPath;
                        if ($field === 'photo2') $photo2 = $relPath;
                        if ($field === 'photo3') $photo3 = $relPath;
                    } else {
                        $errors[] = "خطا در آپلود فایل {$field}.";
                    }
                }
            } elseif ($file['error'] !== UPLOAD_ERR_NO_FILE) {
                $errors[] = "خطا در آپلود فایل {$field}.";
            }
        }
    }

    // ویدیو / صوت
    if (!empty($_FILES['media1']['name'])) {
        $file = $_FILES['media1'];
        if ($file['error'] === UPLOAD_ERR_OK) {
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $allowed_media = ['mp4','mov','mkv','3gp','mp3','ogg','m4a','wav'];
            if (!in_array($ext, $allowed_media, true)) {
                $errors[] = "فرمت فایل ویدیو يا صوت مجاز نیست.";
            } else {
                $newName = 'o' . $order['id'] . '_' . time() . '_media.' . $ext;
                $target  = $media_dir . '/' . $newName;
                if (move_uploaded_file($file['tmp_name'], $target)) {
                    $hasFile = true;
                    $video1  = 'uploads/delivery/media/' . $newName;
                } else {
                    $errors[] = "خطا در آپلود فایل ویدیو يا صوت.";
                }
            }
        } elseif ($file['error'] !== UPLOAD_ERR_NO_FILE) {
            $errors[] = "خطا در آپلود فایل ویدیو يا صوت.";
        }
    }

    // تحویل موفق بدون مدرک قبول نیست
    if ($delivery_status === 'delivered' && !$hasFile) {
        $errors[] = 'برای تحویل موفق حداقل یک عکس یا فایل ویدیو/صوت ارسال کنید.';
    }

    if (empty($errors)) {

        // چک وجود جدول
        $chk = $mysqli->query("SHOW TABLES LIKE 'order_delivery_proofs'");
        if (!$chk || $chk->num_rows === 0) {
            $errors[] = 'جدول مدارک تحویل در دیتابیس موجود نیست.';
        } else {

            $st3 = $mysqli->prepare("
                INSERT INTO order_delivery_proofs
                (order_id, item_id, serial_number, customer_name, customer_phone, address_snapshot, note,
                 photo1, photo2, photo3, video1, created_by)
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
            ");

            $item_id = null; // سطح سفارش

            $st3->bind_param(
                'iissssssssss',
                $order['id'],
                $item_id,
                $serial_number,
                $customer_name,
                $customer_phone,
                $address_snap,
                $note,
                $photo1,
                $photo2,
                $photo3,
                $video1,
                $driver_name
            );

            if ($st3->execute()) {

                $shipping_status = ($delivery_status === 'delivered') ? 'delivered' : 'failed';
                $append_note     = ($delivery_status === 'delivered')
                    ? "\nتحویل راننده: تحویل موفق ثبت شد."
                    : "\nتحویل راننده: تحویل ناموفق ثبت شد.";

                $st4 = $mysqli->prepare("
                    UPDATE orders
                    SET shipping_status = ?,
                        status_note = CONCAT(COALESCE(status_note,''), ?)
                    WHERE id = ?
                ");
                $st4->bind_param('ssi', $shipping_status, $append_note, $order['id']);
                $st4->execute();
                $st4->close();

                $success = 'اطلاعات تحویل با موفقیت ثبت شد. ممنون از همکاری شما.';
            } else {
                $errors[] = 'خطا در ثبت اطلاعات در سیستم.';
            }

            $st3->close();
        }
    }
}
?><!doctype html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>فرم تحویل سفارش | سلام بابا</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="/orders/delivery/delivery.css">
</head>
<body>

<div class="container">
    <h1>فرم ثبت تحویل سفارش</h1>

    <?php if (!empty($errors)): ?>
        <div class="msg-error">
            <?php foreach ($errors as $er): ?>
                <div><?php echo e($er); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <?php if ($success): ?>
        <div class="msg-success">
            <?php echo e($success); ?>
        </div>
    <?php endif; ?>

    <?php if ($order): ?>
        <div class="order-box">
            <div><strong>کد پیگیری:</strong> <?php echo e($order['tracking_code']); ?></div>
            <div><strong>نام مشتری:</strong> <?php echo e($order['customer_name']); ?></div>
            <div><strong>موبایل:</strong> <?php echo e($order['mobile1']); ?></div>
            <div><strong>آدرس:</strong> <?php echo e($order['address']); ?></div>
            <div><strong>وضعیت فعلی:</strong>
                <?php
                $st = $order['shipping_status'] ?? '';
                echo e($status_map[$st] ?? $st);
                ?>
            </div>

            <?php if ($order_items): ?>
                <table class="items-table">
                    <thead>
                    <tr>
                        <th>محصول</th>
                        <th>تعداد</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($order_items as $it): ?>
                        <tr>
                            <td><?php echo e($it['model']); ?></td>
                            <td><?php echo (int)$it['qty']; ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>

        <form method="post" enctype="multipart/form-data">

            <label for="delivery_status">وضعیت تحویل</label>
            <select name="delivery_status" id="delivery_status">
                <option value="">انتخاب کنید...</option>
                <option value="delivered" <?php echo (($_POST['delivery_status'] ?? '') === 'delivered') ? 'selected' : ''; ?>>تحویل موفق به مشتری</option>
                <option value="failed" <?php echo (($_POST['delivery_status'] ?? '') === 'failed') ? 'selected' : ''; ?>>تحویل ناموفق / عدم تحویل</option>
            </select>

            <div class="field-inline">
                <div>
                    <label for="driver_name">نام راننده</label>
                    <input type="text" name="driver_name" id="driver_name"
                           value="<?php echo e($_POST['driver_name'] ?? ''); ?>">
                </div>
                <div>
                    <label for="serial_number">سریال دستگاه (در صورت امکان)</label>
                    <input type="text" name="serial_number" id="serial_number"
                           value="<?php echo e($_POST['serial_number'] ?? ''); ?>">
                </div>
            </div>

            <div class="field-inline">
                <div>
                    <label for="customer_name">نام مشتری (در محل تحویل)</label>
                    <input type="text" name="customer_name" id="customer_name"
                           value="<?php echo e($_POST['customer_name'] ?? $order['customer_name']); ?>">
                </div>
                <div>
                    <label for="customer_phone">شماره تماس مشتری</label>
                    <input type="text" name="customer_phone" id="customer_phone"
                           value="<?php echo e($_POST['customer_phone'] ?? $order['mobile1']); ?>">
                </div>
            </div>

            <label for="address_snapshot">توضیح کوتاه آدرس یا موقعیت</label>
            <textarea name="address_snapshot" id="address_snapshot"><?php
                echo e($_POST['address_snapshot'] ?? '');
            ?></textarea>

            <label for="note">توضیحات راننده</label>
            <textarea name="note" id="note"><?php
                echo e($_POST['note'] ?? '');
            ?></textarea>

            <hr>

            <label>عکس محصول تحویل شده (تا 3 فایل)</label>
            <div class="hint">فرمت های مجاز: jpg, jpeg, png, webp</div>
            <input type="file" name="photo1">
            <input type="file" name="photo2">
            <input type="file" name="photo3">

            <label>فایل ویدیو يا صوت از مشتری (اختیاری)</label>
            <div class="hint">فرمت های مجاز: mp4, mov, mkv, 3gp, mp3, ogg, m4a, wav</div>
            <input type="file" name="media1">

            <button type="submit">ثبت اطلاعات تحویل</button>

            <div class="footer-note">
                اگر مشکلی در ثبت اطلاعات داشتید با پشتیبانی سلام بابا تماس بگیرید.
            </div>
        </form>

    <?php else: ?>
        <p class="no-order">اطلاعات سفارش قابل نمایش نیست.</p>
    <?php endif; ?>

</div>

</body>
</html>
