<?php
// orders/delivery/upload.php
// نسخه کمکی / داخلی برای ثبت مدرک تحویل توسط کاربر لاگین‌کرده (سر باربر / ادمین)

require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$role = $_SESSION['role'] ?? '';
$user = $_SESSION['username'] ?? '';

if (!in_array($role, ['admin','head_carrier','logistic'], true)) {
    http_response_code(403);
    exit('ACCESS DENIED');
}

function e($s) {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('METHOD NOT ALLOWED');
}

$order_uid = trim($_POST['order_uid'] ?? '');
$serial    = trim($_POST['serial'] ?? '');
$note      = trim($_POST['note'] ?? '');

if ($order_uid === '') {
    exit('bad request');
}

// سفارش
$st = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
$st->bind_param('s', $order_uid);
$st->execute();
$order = $st->get_result()->fetch_assoc();
$st->close();

if (!$order) {
    exit('order not found');
}

// دسترسی سر باربر
if ($role !== 'admin' && ($order['head_carrier_username'] ?? '') !== $user) {
    http_response_code(403);
    exit('ACCESS DENIED ORDER');
}

$order_id = (int)$order['id'];

// مسیرها
$upload_base   = __DIR__ . '/../uploads/delivery';
$photo_dir     = $upload_base . '/photos';
$media_dir     = $upload_base . '/media';

foreach ([$upload_base, $photo_dir, $media_dir] as $dir) {
    if (!is_dir($dir)) {
        @mkdir($dir, 0775, true);
    }
}

$photo1 = $photo2 = $photo3 = $video1 = null;

// عکس
$fields = ['p1','p2','p3'];
foreach ($fields as $idx => $field) {
    if (!empty($_FILES[$field]['name']) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
        $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp'];
        if (!in_array($ext, $allowed, true)) {
            continue;
        }
        $newName = 'o' . $order_id . '_' . time() . '_' . $field . '.' . $ext;
        $target  = $photo_dir . '/' . $newName;
        if (move_uploaded_file($_FILES[$field]['tmp_name'], $target)) {
            $rel = 'uploads/delivery/photos/' . $newName;
            if ($idx === 0) $photo1 = $rel;
            if ($idx === 1) $photo2 = $rel;
            if ($idx === 2) $photo3 = $rel;
        }
    }
}

// ویدیو / صوت (اختیاری)
if (!empty($_FILES['media1']['name']) && $_FILES['media1']['error'] === UPLOAD_ERR_OK) {
    $ext = strtolower(pathinfo($_FILES['media1']['name'], PATHINFO_EXTENSION));
    $allowed = ['mp4','mov','mkv','3gp','mp3','ogg','m4a','wav'];
    if (in_array($ext, $allowed, true)) {
        $newName = 'o' . $order_id . '_' . time() . '_media.' . $ext;
        $target  = $media_dir . '/' . $newName;
        if (move_uploaded_file($_FILES['media1']['tmp_name'], $target)) {
            $video1 = 'uploads/delivery/media/' . $newName;
        }
    }
}

// ثبت در دیتابیس
$chk = $mysqli->query("SHOW TABLES LIKE 'order_delivery_proofs'");
if (!$chk || $chk->num_rows === 0) {
    exit('table order_delivery_proofs not found');
}

$customer_name  = $order['customer_name'] ?? '';
$customer_phone = $order['mobile1'] ?? '';
$address_snap   = $order['address'] ?? '';

$st2 = $mysqli->prepare("
    INSERT INTO order_delivery_proofs
    (order_id, item_id, serial_number, customer_name, customer_phone, address_snapshot, note,
     photo1, photo2, photo3, video1, created_by)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
");
$item_id = null;
$st2->bind_param(
    'iissssssssss',
    $order_id,
    $item_id,
    $serial,
    $customer_name,
    $customer_phone,
    $address_snap,
    $note,
    $photo1,
    $photo2,
    $photo3,
    $video1,
    $user
);
$st2->execute();
$st2->close();

// ریدایرکت به صفحه قبل (اگر بود) یا به پنل سر باربر
$back = $_POST['back'] ?? '';
if ($back && filter_var($back, FILTER_VALIDATE_URL)) {
    header("Location: " . $back);
} else {
    header("Location: /orders/head/index.php?id=" . urlencode($order_uid));
}
exit;
