<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

// ==============================
// دریافت UID امن از URL
// ==============================
$uid = trim($_GET['id'] ?? '');
if ($uid === '') {
    http_response_code(400);
    exit('شناسه معتبر نیست');
}

// ==============================
// واکشی سفارش از جدول orders
// ==============================
$stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
if (!$stmt) {
    http_response_code(500);
    exit('Database error');
}
$stmt->bind_param("s", $uid);
$stmt->execute();
$o = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$o) {
    http_response_code(404);
    exit('فاکتور یافت نشد');
}

$order_id = (int)$o['id'];

// ==============================
// واکشی اقلام از order_items
// ==============================
$items = [];
$stmt = $mysqli->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$res = $stmt->get_result();
while ($row = $res->fetch_assoc()) {
    $items[] = $row;
}
$stmt->close();

// ==============================
// توابع کمکی
// ==============================
function h($v){
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}

function toJalaliEn($date){
    if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '';
    list($gy,$gm,$gd) = explode('-', $date);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    // تبدیل اعداد فارسی به انگلیسی
    return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

$purchase_date_g = h($o['purchase_date'] ?? '');
$purchase_date_j = h(toJalaliEn($o['purchase_date'] ?? ''));

$session_seller = $_SESSION['full_name'] ?? ($_SESSION['username'] ?? '');
$province_val   = $o['province'] ?? '';

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>ویرایش فاکتور #<?=h($o['order_uid'])?> — سلام‌بابا</title>

  <!-- استایل اصلی پروژه (همان style.css) -->
  <link rel="stylesheet" href="assets/style.css">

  <!-- تقویم شمسی -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

  <style>
    .items-table {
      width: 100%;
      border-collapse: collapse;
      font-size: 13px;
    }
    .items-table th,
    .items-table td {
      border: 1px solid #e5e7eb;
      padding: 6px 8px;
      vertical-align: middle;
    }
    .items-table th {
      background: #f3f4f6;
      font-weight: 600;
      text-align: center;
    }
    .items-table input,
    .items-table select,
    .items-table textarea {
      width: 100%;
      box-sizing: border-box;
      font-size: 13px;
    }
    .items-table td.idx {
      text-align: center;
      background: #f9fafb;
      width: 40px;
    }
    .negative {
      color:#dc2626 !important;
      font-weight:600;
    }
    .negative-row {
      background:#fee2e2 !important;
      transition:0.2s;
    }
    .actions-row {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      gap: 10px;
      flex-wrap: wrap;
      align-items: center;
    }
    .sum-bar {
      display:flex;
      flex-wrap:wrap;
      gap:10px;
      margin-top:10px;
    }
    .sum-box {
      flex:1 1 120px;
      min-width:120px;
      background:#f9fafb;
      border-radius:10px;
      padding:8px 12px;
      border:1px solid #e5e7eb;
    }
    .sum-box span.label {
      display:block;
      font-size:11px;
      color:#6b7280;
      margin-bottom:3px;
    }
    .sum-box span.val {
      font-weight:600;
      font-size:13px;
    }
    #msgBox {
      margin-top:10px;
      font-size:13px;
    }
    #msgBox.success { color:#16a34a; }
    #msgBox.error   { color:#b91c1c; white-space:pre-wrap; }
    @media (max-width: 768px){
      .items-table th,
      .items-table td{ font-size:11px; padding:4px; }
      .items-table input,
      .items-table select,
      .items-table textarea{ font-size:11px; }
    }
  </style>
</head>

<body>
<div class="container">

  <header class="brand">
    <?php require __DIR__.'/includes/header.php'; ?>
  </header>

  <form id="editForm" action="xhr_update_order.php" method="post">
    <input type="hidden" name="id" value="<?=$order_id?>">
    <input type="hidden" name="order_uid" value="<?=h($o['order_uid'])?>">
    <input type="hidden" name="purchase_date" id="purchase_date" value="<?=$purchase_date_g?>">

    <!-- =================== مشخصات مشتری =================== -->
    <section class="card">
      <h3>ویرایش فاکتور #<?=h($o['order_uid'])?></h3>

      <div class="grid-2">
        <label class="field">
          <span>نام مشتری</span>
          <input name="customer_name" value="<?=h($o['customer_name'] ?? '')?>" required>
        </label>

        <label class="field">
          <span>نام فروشنده</span>
          <input type="hidden" name="seller_name" value="<?=h($o['seller_name'] ?? $session_seller)?>">
          <input type="text" value="<?=h($o['seller_name'] ?? $session_seller)?>" class="sellerInput" readonly tabindex="-1">
        </label>
      </div>

      <div class="grid-2">
        <label class="field">
          <span>شماره همراه ۱</span>
          <input name="mobile1" inputmode="numeric" maxlength="11" value="<?=h($o['mobile1'] ?? '')?>">
        </label>

        <label class="field">
          <span>شماره همراه ۲</span>
          <input name="mobile2" inputmode="numeric" maxlength="11" value="<?=h($o['mobile2'] ?? '')?>">
        </label>
      </div>

      <div class="grid-2">
        <label class="field">
          <span>تلفن ثابت</span>
          <input name="phone" inputmode="numeric" maxlength="11" value="<?=h($o['phone'] ?? '')?>">
        </label>

        <label class="field">
          <span>تاریخ خرید (شمسی)</span>
          <input id="purchase_date_sh" name="purchase_date_sh" value="<?=$purchase_date_j?>" placeholder="YYYY/MM/DD">
        </label>
      </div>

      <div class="grid-2">
        <label class="field">
          <span>استان</span>
          <select name="province">
            <option value="">انتخاب کنید</option>
            <?php
              $provinces = [
                "تهران","البرز","قزوین","گیلان","آذربایجان شرقی","آذربایجان غربی",
                "اردبیل","اصفهان","ایلام","بوشهر","چهارمحال و بختیاری","خراسان جنوبی",
                "خراسان رضوی","خراسان شمالی","خوزستان","زنجان","سمنان","سیستان و بلوچستان",
                "فارس","قم","کردستان","کرمان","کرمانشاه","کهگیلویه و بویراحمد",
                "گلستان","لرستان","مازندران","مرکزی","هرمزگان","همدان","یزد"
              ];
              foreach($provinces as $p):
            ?>
              <option value="<?=h($p)?>" <?=$province_val == $p ? 'selected' : ''?>><?=h($p)?></option>
            <?php endforeach; ?>
          </select>
        </label>

        <label class="field">
          <span>لوکیشن مشتری (گوگل‌مپ)</span>
          <input type="url" name="location_url" value="<?=h($o['location_url'] ?? '')?>" placeholder="https://maps.app.goo.gl/..." style="direction:ltr">
        </label>
      </div>

      <label class="field">
        <span>آدرس</span>
        <textarea name="address" rows="2"><?=h($o['address'] ?? '')?></textarea>
      </label>

      <label class="field">
        <span>توضیحات اضافی</span>
        <textarea name="notes" rows="2"><?=h($o['notes'] ?? '')?></textarea>
      </label>
    </section>

    <!-- =================== اقلام فاکتور =================== -->
    <section class="card">
      <div class="brand" style="justify-content:space-between;">
        <h3>اقلام فاکتور</h3>
        <button type="button" class="btn ghost" id="addItemBtn">+ افزودن قلم</button>
      </div>

      <div class="table-responsive">
        <table class="items-table" id="itemsTable">
          <thead>
            <tr>
              <th>#</th>
              <th>مدل / عنوان</th>
              <th>تعداد</th>
              <th>قیمت کل فروش</th>
              <th>بیعانه</th>
              <th>دریافتی (COD)</th>
              <th>مانده</th>
              <th>نوع گارانتی</th>
              <th>توضیحات قلم</th>
              <th>حذف</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($items): ?>
              <?php foreach($items as $idx => $it): ?>
                <tr>
                  <td class="idx"><?=($idx+1)?></td>

                  <!-- مدل: متن آزاد + نگهداری model_id/brand/category/unit_price -->
                  <td>
                    <input type="hidden" name="items[<?=$idx?>][id]" value="<?= (int)$it['id'] ?>">
                    <input type="hidden" name="items[<?=$idx?>][model_id]" value="<?= (int)($it['model_id'] ?? 0) ?>">
                    <input type="hidden" name="items[<?=$idx?>][brand]" value="<?=h($it['brand'] ?? '')?>">
                    <input type="hidden" name="items[<?=$idx?>][category]" value="<?=h($it['category'] ?? '')?>">
                    <input type="hidden" name="items[<?=$idx?>][unit_price]" value="<?= (int)($it['unit_price'] ?? 0) ?>">

                    <input name="items[<?=$idx?>][model]" value="<?=h($it['model'] ?? '')?>">
                  </td>

                  <!-- تعداد -->
                  <td>
                    <input name="items[<?=$idx?>][qty]" type="number" min="1" value="<?= (int)($it['qty'] ?? 1) ?>">
                  </td>

                  <!-- قیمت کل فروش -->
                  <td>
                    <input name="items[<?=$idx?>][price]" type="number" min="0" value="<?= (int)($it['price'] ?? 0) ?>">
                  </td>

                  <!-- بیعانه -->
                  <td>
                    <input name="items[<?=$idx?>][deposit]" type="number" min="0" value="<?= (int)($it['deposit'] ?? 0) ?>">
                  </td>

                  <!-- دریافتی COD -->
                  <td>
                    <input name="items[<?=$idx?>][cod]" type="number" min="0" value="<?= (int)($it['cod'] ?? 0) ?>">
                  </td>

                  <!-- مانده -->
                  <td>
                    <input name="items[<?=$idx?>][remaining]" type="number" value="<?= (int)($it['remaining'] ?? 0) ?>" readonly>
                  </td>

                  <!-- نوع گارانتی -->
                  <td>
                    <?php $wt = $it['warranty_type'] ?? 'none'; ?>
                    <select name="items[<?=$idx?>][warranty_type]">
                      <option value="none" <?=$wt === 'none' ? 'selected' : ''?>>بدون گارانتی (۰٪)</option>
                      <option value="tv_silver" <?=$wt === 'tv_silver' ? 'selected' : ''?>>گارانتی نقره‌ای تلویزیون (۲٪)</option>
                      <option value="tv_gold" <?=$wt === 'tv_gold' ? 'selected' : ''?>>گارانتی طلایی تلویزیون (۵٪)</option>
                      <option value="home_appliance" <?=$wt === 'home_appliance' ? 'selected' : ''?>>گارانتی لوازم خانگی (۳٪)</option>
                      <option value="small_appliance" <?=$wt === 'small_appliance' ? 'selected' : ''?>>گارانتی لوازم ریز (۲٪)</option>
                    </select>
                  </td>

                  <!-- توضیحات قلم -->
                  <td>
                    <textarea name="items[<?=$idx?>][notes]" rows="1"><?=h($it['notes'] ?? '')?></textarea>
                  </td>

                  <!-- حذف -->
                  <td style="text-align:center;">
                    <button type="button" class="btn danger btn-sm removeRowBtn">✖</button>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <!-- اگر به هر دلیل سفارش بدون قلم بود، یک ردیف خالی بساز -->
              <tr>
                <td class="idx">1</td>
                <td>
                  <input type="hidden" name="items[0][id]" value="">
                  <input type="hidden" name="items[0][model_id]" value="0">
                  <input type="hidden" name="items[0][brand]" value="">
                  <input type="hidden" name="items[0][category]" value="">
                  <input type="hidden" name="items[0][unit_price]" value="0">
                  <input name="items[0][model]" value="">
                </td>
                <td><input name="items[0][qty]" type="number" min="1" value="1"></td>
                <td><input name="items[0][price]" type="number" min="0" value="0"></td>
                <td><input name="items[0][deposit]" type="number" min="0" value="0"></td>
                <td><input name="items[0][cod]" type="number" min="0" value="0"></td>
                <td><input name="items[0][remaining]" type="number" value="0" readonly></td>
                <td>
                  <select name="items[0][warranty_type]">
                    <option value="none" selected>بدون گارانتی (۰٪)</option>
                    <option value="tv_silver">گارانتی نقره‌ای تلویزیون (۲٪)</option>
                    <option value="tv_gold">گارانتی طلایی تلویزیون (۵٪)</option>
                    <option value="home_appliance">گارانتی لوازم خانگی (۳٪)</option>
                    <option value="small_appliance">گارانتی لوازم ریز (۲٪)</option>
                  </select>
                </td>
                <td><textarea name="items[0][notes]" rows="1"></textarea></td>
                <td style="text-align:center;"><button type="button" class="btn danger btn-sm removeRowBtn">✖</button></td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="actions-row">
        <div class="sum-bar">
          <div class="sum-box">
            <span class="label">جمع کل فروش</span>
            <span class="val" id="sumTotal">0</span>
          </div>
          <div class="sum-box">
            <span class="label">جمع بیعانه</span>
            <span class="val" id="sumDeposit">0</span>
          </div>
          <div class="sum-box">
            <span class="label">جمع دریافتی (COD)</span>
            <span class="val" id="sumCod">0</span>
          </div>
          <div class="sum-box">
            <span class="label">جمع مانده</span>
            <span class="val" id="sumRemaining">0</span>
          </div>
        </div>
      </div>

      <!-- برای سازگاری با اسکریپت سمت سرور -->
      <input type="hidden" name="total_amount" id="total_amount" value="<?= (int)($o['total_amount'] ?? 0) ?>">
      <input type="hidden" name="total_deposit" id="total_deposit" value="<?= (int)($o['total_deposit'] ?? 0) ?>">
      <input type="hidden" name="total_cod" id="total_cod" value="<?= (int)($o['total_cod'] ?? 0) ?>">
      <input type="hidden" name="total_remaining" id="total_remaining" value="<?= (int)($o['total_remaining'] ?? 0) ?>">
    </section>

    <!-- =================== ارسال / دکمه‌ها =================== -->
    <section class="card">
      <div style="display:flex;flex-wrap:wrap;gap:10px;align-items:center;justify-content:space-between;">
        <button type="submit" class="btn primary">💾 ذخیره تغییرات</button>
        <a href="orders.php" class="btn ghost">بازگشت به لیست سفارش‌ها</a>
      </div>
      <p class="note" style="margin-top:8px;">اگر در هر قلم مانده منفی شود، ذخیره انجام نخواهد شد.</p>
      <div id="msgBox"></div>
    </section>
  </form>
</div>

<script>
  // تبدیل به int امن
  function toInt(v){
    return parseInt(String(v||'').replace(/,/g,''), 10) || 0;
  }

  // محاسبه مانده و جمع‌ها
  function recalcAll(){
    let sumTotal = 0, sumDep = 0, sumCod = 0, sumRem = 0;

    document.querySelectorAll('#itemsTable tbody tr').forEach(function(tr){
      const priceEl   = tr.querySelector('input[name*="[price]"]');
      const depEl     = tr.querySelector('input[name*="[deposit]"]');
      const codEl     = tr.querySelector('input[name*="[cod]"]');
      const remEl     = tr.querySelector('input[name*="[remaining]"]');

      const price = toInt(priceEl ? priceEl.value : 0);
      const dep   = toInt(depEl ? depEl.value : 0);
      const cod   = toInt(codEl ? codEl.value : 0);
      const rem   = price - dep - cod;

      if (remEl){
        remEl.value = rem;
      }

      tr.classList.remove('negative-row');
      if (remEl){
        remEl.classList.remove('negative');
        if (rem < 0){
          remEl.classList.add('negative');
          tr.classList.add('negative-row');
        }
      }

      sumTotal += price;
      sumDep   += dep;
      sumCod   += cod;
      sumRem   += rem;
    });

    document.getElementById('sumTotal').textContent     = sumTotal.toLocaleString('en-US');
    document.getElementById('sumDeposit').textContent   = sumDep.toLocaleString('en-US');
    document.getElementById('sumCod').textContent       = sumCod.toLocaleString('en-US');
    document.getElementById('sumRemaining').textContent = sumRem.toLocaleString('en-US');

    // برای اسکریپت سمت سرور
    document.getElementById('total_amount').value    = sumTotal;
    document.getElementById('total_deposit').value   = sumDep;
    document.getElementById('total_cod').value       = sumCod;
    document.getElementById('total_remaining').value = sumRem;
  }

  // تغییر روی قیمت‌ها / بیعانه / cod → محاسبه مجدد
  document.addEventListener('input', function(e){
    if (e.target.matches('input[name*="[price]"],input[name*="[deposit]"],input[name*="[cod]"]')){
      recalcAll();
    }
  });

  // حذف ردیف
  document.addEventListener('click', function(e){
    if (e.target.classList.contains('removeRowBtn')){
      const tr = e.target.closest('tr');
      if (tr) {
        tr.remove();
        // ردیف‌ها را دوباره شماره‌گذاری کن
        document.querySelectorAll('#itemsTable tbody tr').forEach(function(row, i){
          const idxCell = row.querySelector('td.idx');
          if (idxCell) idxCell.textContent = (i+1);
        });
        recalcAll();
      }
    }
  });

  // افزودن قلم جدید (مدل متن آزاد)
  document.getElementById('addItemBtn').addEventListener('click', function(){
    const tbody = document.querySelector('#itemsTable tbody');
    const index = tbody.querySelectorAll('tr').length;
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td class="idx">${index+1}</td>
      <td>
        <input type="hidden" name="items[${index}][id]" value="">
        <input type="hidden" name="items[${index}][model_id]" value="0">
        <input type="hidden" name="items[${index}][brand]" value="">
        <input type="hidden" name="items[${index}][category]" value="">
        <input type="hidden" name="items[${index}][unit_price]" value="0">
        <input name="items[${index}][model]" value="">
      </td>
      <td><input name="items[${index}][qty]" type="number" min="1" value="1"></td>
      <td><input name="items[${index}][price]" type="number" min="0" value="0"></td>
      <td><input name="items[${index}][deposit]" type="number" min="0" value="0"></td>
      <td><input name="items[${index}][cod]" type="number" min="0" value="0"></td>
      <td><input name="items[${index}][remaining]" type="number" value="0" readonly></td>
      <td>
        <select name="items[${index}][warranty_type]">
          <option value="none" selected>بدون گارانتی (۰٪)</option>
          <option value="tv_silver">گارانتی نقره‌ای تلویزیون (۲٪)</option>
          <option value="tv_gold">گارانتی طلایی تلویزیون (۵٪)</option>
          <option value="home_appliance">گارانتی لوازم خانگی (۳٪)</option>
          <option value="small_appliance">گارانتی لوازم ریز (۲٪)</option>
        </select>
      </td>
      <td><textarea name="items[${index}][notes]" rows="1"></textarea></td>
      <td style="text-align:center;"><button type="button" class="btn danger btn-sm removeRowBtn">✖</button></td>
    `;
    tbody.appendChild(tr);
    recalcAll();
  });

  // جلوگیری از ذخیره با مانده منفی + ارسال AJAX به xhr_update_order.php
  document.getElementById('editForm').addEventListener('submit', function(e){
    e.preventDefault();

    recalcAll();

    const hasNegative = document.querySelector('.negative-row') !== null;
    const msgBox = document.getElementById('msgBox');

    if (hasNegative){
      msgBox.className = 'error';
      msgBox.textContent = '⚠️ مانده منفی در یکی از اقلام وجود دارد. لطفاً مبالغ را اصلاح کنید.';
      return;
    }

    msgBox.className = '';
    msgBox.textContent = '⏳ در حال ذخیره...';

    const form = e.target;
    const fd = new FormData(form);

    fetch('xhr_update_order.php', {
      method: 'POST',
      body: fd
    }).then(r => r.text())
      .then(t => {
        let j;
        try { j = JSON.parse(t); } catch(e){
          msgBox.className = 'error';
          msgBox.textContent = 'خطای پاسخ سرور:\n' + t;
          return;
        }
        if (j.ok){
          msgBox.className = 'success';
          msgBox.textContent = '✔ تغییرات با موفقیت ذخیره شد.';
          setTimeout(function(){
            window.location.href = 'orders.php';
          }, 800);
        } else {
          msgBox.className = 'error';
          msgBox.textContent = '❌ ' + (j.error || 'خطا در ذخیره‌سازی');
        }
      })
      .catch(err => {
        msgBox.className = 'error';
        msgBox.textContent = '❌ خطای ارتباط با سرور: ' + err;
      });
  });

  // تنظیم تقویم شمسی و همگام‌سازی با purchase_date (میلادی)
  $(function(){
    $('#purchase_date_sh').persianDatepicker({
      format: "YYYY/MM/DD",
      autoClose: true,
      initialValue: !!$('#purchase_date_sh').val(),
      observer: true,
      onSelect: function(unix){
        const g = new persianDate(unix).toCalendar('gregorian');
        const y = g.year();
        const m = String(g.month()).padStart(2,'0');
        const d = String(g.date()).padStart(2,'0');
        $('#purchase_date').val(y + '-' + m + '-' + d);
      }
    });
  });

  // محاسبه اولیه بعد از لود
  document.addEventListener('DOMContentLoaded', recalcAll);
</script>

</body>
</html>
