<?php
// ======================
// Start Safe Session
// ======================
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path'     => '/',
        'secure'   => false,
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require __DIR__.'/includes/db_connect.php'; 

// آدرس برگشت پس از لاگین
$redirect = $_GET['redirect'] ?? '/orders/index.php';

// اگر کاربر قبلاً وارد شده
if (!empty($_SESSION['username']) && !empty($_SESSION['role'])) {
    header("Location: $redirect");
    exit;
}

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $u = trim($_POST['username'] ?? '');
    $p = $_POST['password'] ?? '';
    $redirect = trim($_POST['redirect'] ?? 'order/index.php');

    // گرفتن اطلاعات کاربر
    $st = $mysqli->prepare("SELECT id, username, password_hash, full_name, role FROM users WHERE username=? LIMIT 1");
    $st->bind_param("s", $u);
    $st->execute();
    $row = $st->get_result()->fetch_assoc();

    if ($row && password_verify($p, $row['password_hash'])) {

   // بعد از لاگین موفق:
$_SESSION['user_id']   = $row['id'];
$_SESSION['username']  = $row['username'];
$_SESSION['full_name'] = $row['full_name'];
$_SESSION['role']      = $row['role'];

// ریدایرکت هوشمند براساس نقش:
if ($row['role'] === 'head_carrier') {
    header("Location: /orders/head/");
    exit;
}

if ($row['role'] === 'buyer_manager') {
    header("Location: /orders/buyer/");
    exit;
}

if ($row['role'] === 'seller') {
    header("Location: /orders/orders.php");
    exit;
}

if ($row['role'] === 'admin') {
    header("Location: /orders/index.php");
    exit;
}

// default fallback
header("Location: /orders/index.php");
exit;


        // اگر redirect معتبر بود
        if ($redirect && str_starts_with($redirect, '/')) {
            header("Location: $redirect");
            exit;
        }
        exit;

    } else {
        $msg = "نام کاربری یا رمز عبور اشتباه است.";
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>ورود — سلام‌بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="/orders/assets/login.css">
</head>
<body>

  <div class="login-box">

    <div class="logo-stripes">
      <span class="b"></span><span class="g"></span><span class="y"></span><span class="r"></span>
    </div>

    <div class="welcome">
      <h1>بەخێربێن بۆ سەلامـ بابا.</h1>
    </div>

    <?php if($msg): ?>
      <div class="note"><?=$msg?></div>
    <?php endif; ?>

    <form method="post">

      <input type="hidden" name="redirect" value="<?=htmlspecialchars($redirect)?>">

      <label class="field">
        <span>ناوی بەکارهێنەر:</span>
        <input name="username" required autofocus>
      </label>

      <label class="field">
        <span>وشەی نهێنی:</span>
        <input type="password" name="password" required>
      </label>

      <button class="btn">چوونەژوورەوە</button>

    </form>
<div class="register-link" style="text-align:center;margin-top:18px;">
  <a href="https://salambaba.co/orders/sb-register.php" style="color:#2563eb;font-weight:bold;">
    ئەکاونتێکی نوێ دروست بکە
  </a>
  </div>

</body>
</html>
