<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

$user = $_SESSION['username'] ?? '';
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

// =========================
// تغییر وضعیت از همین فایل (Ajax)
// =========================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'change_status') {
    header('Content-Type: application/json; charset=utf-8');

    $id     = (int)($_POST['id'] ?? 0);
    $status = $_POST['status'] ?? '';

    $allowed = [
        'new',
        'assigned_to_buyer',
        'purchased',
        'handover_to_head',
        'out_for_delivery',
        'delivered',
        'failed'
    ];

    if (!$id || !in_array($status, $allowed, true)) {
        echo json_encode(['ok' => false, 'msg' => 'درخواست نامعتبر']);
        exit;
    }

    $st = $mysqli->prepare("UPDATE orders SET shipping_status=? WHERE id=?");
    if (!$st) {
        echo json_encode(['ok' => false, 'msg' => 'خطای پایگاه داده']);
        exit;
    }
    $st->bind_param('si', $status, $id);
    $st->execute();
    $st->close();

    echo json_encode(['ok' => true, 'msg' => 'وضعیت با موفقیت بروزرسانی شد']);
    exit;
}

function nf($n){return number_format((int)$n,0,'.',',');}
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

// مپ وضعیت‌ها (قفل‌شده)
$shipping_status_labels = [
    'new' => '🟦 ثبت شده',
    'assigned_to_buyer' => '🟩 ارجاع به خریدار',
    'purchased' => '🟨 خرید انجام شد',
    'handover_to_head' => '🟧 تحویل به سرپرست ارسال',
    'out_for_delivery' => '🟫 در حال تحویل',
    'delivered' => '🟩 تحویل موفق',
    'failed' => '🟥 تحویل ناموفق'
];

// شرط نمایش سفارش‌ها
$where = $is_admin ? '1' : "username='".$mysqli->real_escape_string($user)."'";
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

// کش کردن سفارش‌ها برای استفاده چندباره
$orders = [];
if ($q) {
    while ($row = $q->fetch_assoc()) {
        $orders[] = $row;
    }
}

// لیست فروشنده‌ها برای فیلتر (فقط برای ادمین استفاده می‌کنیم)
$sellers = $mysqli->query("SELECT DISTINCT seller_name FROM orders WHERE seller_name IS NOT NULL AND seller_name<>'' ORDER BY seller_name ASC");

// لیست استان‌ها برای فیلتر
$provinces = $mysqli->query("SELECT DISTINCT province FROM orders WHERE province IS NOT NULL AND province<>'' ORDER BY province ASC");

// استخراج سال‌های شمسی از تاریخ خرید
$years_used = [];
foreach ($orders as $row_y) {
    $j = toJalaliEn($row_y['purchase_date'] ?? '');
    if ($j !== '-' && strpos($j,'/') !== false) {
        $parts = explode('/',$j);
        if (!empty($parts[0])) $years_used[$parts[0]] = true;
    }
}
$years_used = array_keys($years_used);
rsort($years_used);

// استیتمنت اقلام خریداری شده
$itemStmt = $mysqli->prepare("SELECT model, qty FROM order_items WHERE order_id=? ORDER BY id ASC");
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>لیست فاکتورها | سلام‌بابا</title>
<link rel="stylesheet" href="assets/order.css">
<style>
  #ordersTable {
    overflow-x:auto;
  }

  /* --- MODAL ULTRA PRO --- */
  .sb-modal {
    position: fixed;
    inset: 0;
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 999;
    font-family: inherit;
  }
  .sb-modal.show {
    display: flex;
    animation: sb-fadeIn 0.2s ease-out forwards;
  }
  .sb-backdrop {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.45);
    backdrop-filter: blur(3px);
  }
  .sb-dialog {
    position: relative;
    width: 90%;
    max-width: 420px;
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 15px 40px rgba(0,0,0,0.20);
    overflow: hidden;
    animation: sb-popupIn 0.25s cubic-bezier(.18,.89,.32,1.28);
  }
  .sb-header {
    padding: 12px 14px;
    background: #f7f7f7;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
  }
  .sb-title {
    font-size: 1rem;
    font-weight: bold;
  }
  .sb-close {
    background: transparent;
    border: none;
    font-size: 22px;
    cursor: pointer;
    color: #444;
  }
  .sb-body {
    padding: 10px 16px 14px;
    max-height: 60vh;
    overflow-y: auto;
  }
  .sb-body p {
    margin: 5px 0;
    font-size: 0.9rem;
  }
  .sb-body strong {
    color: #333;
  }
  .sb-footer {
    padding: 10px 12px;
    background: #fafafa;
    border-top: 1px solid #eee;
    display:flex;
    flex-wrap:wrap;
    justify-content:space-between;
    align-items:center;
    gap:8px;
  }

  .sb-btn {
    padding: 6px 10px;
    border-radius: 8px;
    border: none;
    cursor: pointer;
    font-size: 0.85rem;
  }
  .sb-close-btn {
    background: #444;
    color: #fff;
  }

  /* نوار چهاررنگ Salam Baba */
  .sb-stripes {
    display:flex;
    width:100%;
    height:4px;
    border-radius:8px;
    overflow:hidden;
    margin-bottom:10px;
  }
  .sb-stripe {flex:1;}
  .sb-stripe-b {background:#0072CE;}  /* آبی */
  .sb-stripe-g {background:#00A651;}  /* سبز */
  .sb-stripe-y {background:#FFC20E;}  /* زرد */
  .sb-stripe-r {background:#ED1C24;}  /* قرمز */


  .sb-actions {
    display:flex;
    flex-wrap:wrap;
    gap:6px;
  }
  .sb-whatsapp {
    background:#25D366;
    color:#fff;
  }
  .sb-call {
    background:#007bff;
    color:#fff;
  }
  .sb-sms {
    background:#ff9800;
    color:#fff;
  }

  @keyframes sb-popupIn {
    from { transform: scale(0.85); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
  }
  @keyframes sb-fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }

  @media (max-width:480px){
    .sb-footer {
      flex-direction:column;
      align-items:stretch;
    }
    .sb-actions {
      justify-content:space-between;
    }
  }
</style>
<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>
<section class="card">
  <h3>📦 فاکتورهای ثبت‌شده</h3>

  <!-- ✅ فیلترها -->
  <form id="filterForm" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:16px;">
    <input type="text" name="search" placeholder="🔍 جستجو (نام، موبایل، آدرس، مدل کالا)" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;flex:1;min-width:200px;">

    <?php if ($is_admin): ?>
    <select name="seller" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">همه فروشنده‌ها</option>
      <?php if($sellers): while($s = $sellers->fetch_assoc()): ?>
        <option value="<?=htmlspecialchars($s['seller_name'])?>"><?=htmlspecialchars($s['seller_name'])?></option>
      <?php endwhile; endif; ?>
    </select>
    <?php endif; ?>

    <select name="province" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">همه استان‌ها</option>
      <?php if($provinces): while($p = $provinces->fetch_assoc()): ?>
        <option value="<?=htmlspecialchars($p['province'])?>"><?=htmlspecialchars($p['province'])?></option>
      <?php endwhile; endif; ?>
    </select>

    <select name="shipping_status" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">همه وضعیت‌ها</option>
      <?php foreach($shipping_status_labels as $key => $label): ?>
        <option value="<?=$key?>"><?=$label?></option>
      <?php endforeach; ?>
    </select>

    <input type="text" name="model" placeholder="مدل کالا" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;min-width:130px;">

    <select name="month" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">ماه (شمسی)</option>
      <?php for($m=1;$m<=12;$m++): ?>
        <option value="<?=$m?>"><?=$m?></option>
      <?php endfor; ?>
    </select>

    <select name="year" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">سال (شمسی)</option>
      <?php foreach($years_used as $jy): ?>
        <option value="<?=$jy?>"><?=$jy?></option>
      <?php endforeach; ?>
    </select>

    <button class="btn primary" type="submit">اعمال فیلتر</button>
  </form>

  <!-- ✅ جدول -->
  <div id="ordersTable">
    <table class="table">
      <thead>
        <tr>
          <th>#</th>
                    <th>تاریخ</th>
          <th>مشتری</th>
          <th>موبایل</th>
          <th>استان</th>
          <th>آدرس</th>
          <th>اقلام خریداری شده</th>
          <th>فروشنده</th>

          <th>جمع فروش</th>
          <th>بیعانه</th>
          <th>مانده</th>
          <th>وضعیت</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
        <?php if(empty($orders)): ?>
          <tr><td colspan="13" style="text-align:center;color:#777;">هیچ فاکتوری ثبت نشده</td></tr>
        <?php else: $i=1; foreach($orders as $r):
            $mobile1   = $r['mobile1'] ?? '';
            $mobile    = $mobile1 ?: ($r['mobile2'] ?? ($r['phone'] ?? ''));
            $province  = $r['province'] ?? '';
            $address   = $r['address'] ?? '';
            $customer  = $r['customer_name'] ?? '';
            $sellerName= $r['seller_name'] ?? '';
            $jalaliDate= toJalaliEn($r['purchase_date'] ?? '');
            $jy = '';
            $jm = '';
            if ($jalaliDate !== '-' && strpos($jalaliDate,'/') !== false) {
                $parts = explode('/',$jalaliDate);
                $jy = $parts[0] ?? '';
                $jm = $parts[1] ?? '';
            }

            // اقلام خریداری شده
            $itemsText = '';
            if ($itemStmt) {
                $orderId = (int)$r['id'];
                $itemStmt->bind_param('i', $orderId);
                $itemStmt->execute();
                $resItems = $itemStmt->get_result();
                $partsItems = [];
                while($it = $resItems->fetch_assoc()){
                    $m = trim($it['model'] ?? '');
                    if ($m === '') continue;
                    $qty = (int)$it['qty'];
                    if ($qty > 1) {
                        $m .= " × ".$qty;
                    }
                    $partsItems[] = $m;
                }
                $itemsText = implode(' ، ', $partsItems);
            }

            $shipping = trim($r['shipping_status'] ?? '');
            if ($shipping === '') {
                $shipping = 'new';
            }

            $uid = htmlspecialchars($r['order_uid'] ?: $r['id']);
            $viewUrl   = "https://salambaba.co/orders/view.php?id=".$uid;
            $editUrl   = "https://salambaba.co/orders/edit.php?id=".$uid;
            $invoiceUrl= "https://salambaba.co/orders/invoice.php?id=".$uid;
        ?>
          <tr class="data-row"
              data-name="<?=htmlspecialchars($customer)?>"
              data-mobile="<?=htmlspecialchars($mobile)?>"
              data-mobile1="<?=htmlspecialchars($mobile1)?>"
              data-province="<?=htmlspecialchars($province)?>"
              data-address="<?=htmlspecialchars($address)?>"
              data-items="<?=htmlspecialchars($itemsText)?>"
              data-seller="<?=htmlspecialchars($sellerName)?>"
              data-status="<?=$shipping?>"
              data-jy="<?=$jy?>"
              data-jm="<?=$jm?>">
            <td data-label="#"> <?=$i++?> </td>
                        <td data-label="تاریخ"><?=$jalaliDate?></td>
            <td data-label="مشتری" data-col="customer"><?=htmlspecialchars($customer)?></td>
            <td data-label="موبایل" data-col="mobile"><?=htmlspecialchars($mobile)?></td>
            <td data-label="استان" data-col="province"><?=htmlspecialchars($province)?></td>
            <td data-label="آدرس" data-col="address" style="max-width:220px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"><?=htmlspecialchars($address)?></td>
            <td data-label="اقلام" data-col="items" style="max-width:220px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"><?=htmlspecialchars($itemsText)?></td>
            <td data-label="فروشنده"><?=htmlspecialchars($sellerName)?></td>

            <td data-label="جمع فروش"><?=nf($r['total_amount'] ?? 0)?></td>
            <td data-label="بیعانه"><?=nf($r['total_deposit'] ?? 0)?></td>
            <td data-label="مانده"><?=nf($r['total_remaining'] ?? 0)?></td>
            <td data-label="وضعیت">
              <select class="status-select" data-id="<?= (int)$r['id'] ?>" style="padding:4px 6px;border-radius:6px;border:1px solid #ccc;">
                <?php foreach($shipping_status_labels as $key => $label): ?>
                  <option value="<?=$key?>" <?=$key===$shipping?'selected':''?>><?=$label?></option>
                <?php endforeach; ?>
              </select>
            </td>
            <td data-label="عملیات">
              <div class="action-menu">
                <button class="action-btn" aria-label="منوی عملیات">⋯</button>
                <div class="action-list">
                  <a href="<?=$viewUrl?>" class="btn small ghost">👁 مشاهده</a>
                  <a href="<?=$editUrl?>" class="btn small ghost">✏️ ویرایش</a>
                  <a href="<?=$invoiceUrl?>" class="btn small ghost">🧾 PDF</a>
                  <button type="button" class="btn small ghost show-detail">ℹ️ جزئیات</button>
                  <?php if($is_admin): ?>
                    <button class="btn small danger" onclick="deleteOrder(<?= (int)$r['id'] ?>)">🗑 حذف</button>
                  <?php endif; ?>
                </div>
              </div>
            </td>
          </tr>
        <?php endforeach; ?>
          <tr id="noResultsRow" style="display:none;">
            <td colspan="13" style="text-align:center;color:#777;">هیچ نتیجه‌ای مطابق فیلترها یافت نشد</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>

<!-- مودال Ultra PRO -->
<div id="detailModal" class="sb-modal">
  <div class="sb-backdrop"></div>
  <div class="sb-dialog">

    <div class="sb-header">
      <span class="sb-title">جزئیات سفارش</span>
      <button type="button" class="sb-close">×</button>
    </div>

    <div class="sb-body">
      <div class="sb-stripes">
        <span class="sb-stripe sb-stripe-b"></span>
        <span class="sb-stripe sb-stripe-g"></span>
        <span class="sb-stripe sb-stripe-y"></span>
        <span class="sb-stripe sb-stripe-r"></span>
      </div>
      <div class="sb-content"></div>
    </div>

    <div class="sb-footer">
      <div class="sb-actions">
        <a href="#" target="_blank" class="sb-btn sb-whatsapp">واتساپ</a>
        <a href="#" class="sb-btn sb-call">تماس</a>
        <a href="#" class="sb-btn sb-sms">پیامک</a>
      </div>
      <button type="button" class="sb-btn sb-close-btn">بستن</button>
    </div>

  </div>
</div>

<script>
async function deleteOrder(id){
  if(!confirm('آیا از حذف این فاکتور مطمئن هستید؟')) return;
  const fd = new FormData();
  fd.append('id', id);
  const r = await fetch('xhr_delete_order.php',{method:'POST',body:fd});
  const j = await r.json();
  alert(j.msg);
  if(j.ok) location.reload();
}
</script>

<script>
// منوی عملیات
document.addEventListener("click", (e) => {
    const isBtn = e.target.closest(".action-btn");

    document.querySelectorAll(".action-list").forEach(list => list.classList.remove("show"));

    if (isBtn) {
        e.stopPropagation();
        const menu = isBtn.closest(".action-menu").querySelector(".action-list");
        menu.classList.toggle("show");
    }
});
</script>

<script>
// تغییر وضعیت از سلکت
document.addEventListener('change', function(e){
    const sel = e.target.closest('.status-select');
    if (!sel) return;
    const id = sel.dataset.id;
    const status = sel.value;
    if (!id || !status) return;

    const fd = new FormData();
    fd.append('action','change_status');
    fd.append('id',id);
    fd.append('status',status);

    fetch('orders.php', {
        method:'POST',
        body:fd
    })
    .then(r => r.json())
    .then(j => {
        if (!j.ok) {
            alert(j.msg || 'خطا در بروزرسانی وضعیت');
        }
    })
    .catch(() => {
        alert('خطا در ارتباط با سرور');
    });
});

// فیلتر و جستجو سمت کلاینت
const form = document.getElementById('filterForm');
const tbody = document.querySelector('#ordersTable tbody');
const rows = Array.from(tbody.querySelectorAll('tr.data-row'));
const noResultsRow = document.getElementById('noResultsRow');

form.addEventListener('submit', function(e){
  e.preventDefault();
  doFilter();
});

function doFilter(){
  const fd = new FormData(form);
  const search  = (fd.get('search') || '').trim().toLowerCase();
  const seller  = (fd.get('seller') || '').trim();
  const province = (fd.get('province') || '').trim();
  const status  = (fd.get('shipping_status') || '').trim();
  const model   = (fd.get('model') || '').trim().toLowerCase();
  const month   = (fd.get('month') || '').trim();
  const year    = (fd.get('year') || '').trim();

  let visibleCount = 0;

  rows.forEach(function(row){
    let ok = true;

    const rowSeller    = row.dataset.seller || '';
    const rowProvince  = row.dataset.province || '';
    const rowStatus    = row.dataset.status || '';
    const rowItems     = (row.dataset.items || '').toLowerCase();
    const jy           = row.dataset.jy || '';
    const jm           = row.dataset.jm || '';

    const textAll = (
      (row.dataset.name || '') + ' ' +
      (row.dataset.mobile || '') + ' ' +
      (row.dataset.address || '') + ' ' +
      (row.dataset.items || '') + ' ' +
      rowSeller
    ).toLowerCase();

    if (search && !textAll.includes(search)) ok = false;
    if (seller && rowSeller !== seller) ok = false;
    if (province && rowProvince !== province) ok = false;
    if (status && rowStatus !== status) ok = false;
    if (model && !rowItems.includes(model)) ok = false;

    if (year && jy && jy !== year) ok = false;
    if (month && jm && jm !== String(month).padStart(2,'0')) ok = false;

    row.style.display = ok ? '' : 'none';
    if (ok) visibleCount++;
  });

  if (noResultsRow) {
    noResultsRow.style.display = visibleCount ? 'none' : '';
  }
}

// مودال جزئیات Ultra PRO
const sbModal   = document.getElementById('detailModal');
const sbContent = sbModal.querySelector('.sb-content');
const sbQrImg   = sbModal.querySelector('.sb-qr');
const waBtn     = sbModal.querySelector('.sb-whatsapp');
const callBtn   = sbModal.querySelector('.sb-call');
const smsBtn    = sbModal.querySelector('.sb-sms');

document.addEventListener('click', function(e){

    // بستن مودال
    if (e.target.classList.contains('sb-backdrop') ||
        e.target.classList.contains('sb-close') ||
        e.target.classList.contains('sb-close-btn')) {
        sbModal.classList.remove('show');
        return;
    }

    const btn = e.target.closest('.show-detail');
    if (!btn) return;

    const tr = btn.closest('tr');
    if (!tr) return;

    const customer = tr.querySelector('td[data-col="customer"]')?.textContent || '';
    const mobile   = tr.querySelector('td[data-col="mobile"]')?.textContent || '';
    const province = tr.querySelector('td[data-col="province"]')?.textContent || '';
    const address  = tr.querySelector('td[data-col="address"]')?.textContent || '';
    const items    = tr.querySelector('td[data-col="items"]')?.textContent || '';
    const statusSel = tr.querySelector('.status-select');
    const statusText = statusSel?.options[statusSel.selectedIndex]?.textContent || '';

    // لینک سفارش از لینک مشاهده
    const viewLink = tr.querySelector('a[href^="https://salambaba.co/orders/view.php"]');
    let orderUrl = '';
    if (viewLink) {
        const href = viewLink.getAttribute('href');
        try {
            orderUrl = new URL(href, window.location.origin).href;
        } catch(err) {
            orderUrl = href;
        }
    }

    const mobile1 = (tr.dataset.mobile1 || '').trim();

    sbContent.innerHTML = `
      <p><strong>نام مشتری:</strong> ${customer}</p>
      <p><strong>موبایل:</strong> ${mobile || mobile1}</p>
      <p><strong>استان:</strong> ${province}</p>
      <p><strong>آدرس کامل:</strong> ${address}</p>
      <p><strong>اقلام خریداری شده:</strong> ${items}</p>
      <p><strong>وضعیت فعلی:</strong> ${statusText}</p>
    `;


    // دکمه‌های واتساپ / تماس / پیامک با mobile1
    let cleanMobile = mobile1;
    if (cleanMobile) {
        cleanMobile = cleanMobile.replace(/\s|-/g, '');
        let waNumber = cleanMobile;
        if (waNumber.startsWith('0')) {
            waNumber = waNumber.replace(/^0+/, '');
            waNumber = '98' + waNumber;
        }
        if (waBtn) waBtn.href  = 'https://wa.me/' + waNumber;
        if (callBtn) callBtn.href = 'tel:' + cleanMobile;
        if (smsBtn) smsBtn.href  = 'sms:' + cleanMobile;
    } else {
        if (waBtn) waBtn.href  = '#';
        if (callBtn) callBtn.href = '#';
        if (smsBtn) smsBtn.href  = '#';
    }

    sbModal.classList.add('show');
});
</script>

</body>
</html>
