<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/telegram.php';  // ← برای ارسال تلگرام

header('Content-Type: application/json; charset=utf-8');

$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

$username = trim($_POST['username'] ?? '');
$amount   = intval($_POST['amount'] ?? 0);
$method   = trim($_POST['method'] ?? '');
$note     = trim($_POST['note'] ?? '');

// امنیت: فروشنده فقط برای خودش
if ($role === 'seller') {
    $username = $login_user;
}

// ورودی غلط
if (!$username || $amount <= 0) {
    echo json_encode(["status" => "invalid_input"]);
    exit;
}

// چک موجودی
$q = $mysqli->prepare("SELECT balance FROM seller_balance WHERE username=?");
$q->bind_param("s", $username);
$q->execute();
$balResult = $q->get_result()->fetch_assoc();

if (!$balResult) {
    echo json_encode(["status" => "seller_not_found"]);
    exit;
}

$current_balance = intval($balResult['balance']);

if ($current_balance < $amount) {
    echo json_encode(["status" => "balance_not_enough"]);
    exit;
}

// ثبت برداشت
$stmt = $mysqli->prepare("
    INSERT INTO withdrawals (username, amount, method, note) 
    VALUES (?,?,?,?)
");
$stmt->bind_param("siss", $username, $amount, $method, $note);
$stmt->execute();

// کم کردن موجودی
$u = $mysqli->prepare("UPDATE seller_balance SET balance = balance - ? WHERE username=?");
$u->bind_param("is", $amount, $username);
$u->execute();

// ارسال رسید تلگرام
$telegramMessage = 
"🧾 *رسید برداشت از حساب*\n\n".
"👤 فروشنده: *$username*\n".
"💰 مبلغ: *".number_format($amount)." تومان*\n".
"📌 روش: *$method*\n".
"📝 توضیحات: ".($note ?: "-")."\n".
"⏱ تاریخ: ".date("Y-m-d H:i:s")."\n";

sendTG($telegramMessage); // ← تابع تلگرام شما

echo json_encode([
    "status"   => "OK",
    "username" => $username,
    "amount"   => $amount,
    "method"   => $method,
    "note"     => $note,
    "date"     => date("Y-m-d H:i:s")
]);
exit;
