<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role = $_SESSION['role'] ?? '';
$admin_user = $_SESSION['username'] ?? '';

if($role !== 'admin'){
    http_response_code(403);
    exit('اجازه دسترسي نداريد');
}

/* ================================
   پردازش تاييد / رد
================================ */
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    $uid    = intval($_POST['id'] ?? 0);
    $action = $_POST['action'] ?? '';

    // تست:
    // echo "ID: $uid - ACTION: $action"; exit;

    if($uid > 0){

        if($action === 'approve'){
            $sql = "UPDATE users SET is_approved=1, approved_at=NOW(), approved_by=? WHERE id=? LIMIT 1";
        }
        elseif($action === 'reject'){
            $sql = "UPDATE users SET is_approved=2, approved_at=NULL, approved_by=? WHERE id=? LIMIT 1";
        }
        else{
            // اقدام معتبر نیست
            header("Location: user_requests.php");
            exit;
        }

        $stmt = $mysqli->prepare($sql);
        if(!$stmt){
            echo "SQL ERROR: ".$mysqli->error;
            exit;
        }

        $stmt->bind_param("si", $admin_user, $uid);
        $stmt->execute();

        // اگر واقعا تغییر کرده باشد:
        if($stmt->affected_rows > 0){
            header("Location: user_requests.php?done");
            exit;
        } else {
            echo "NO CHANGE (احتمالا مقدار is_approved نوعش درست نیست)";
            exit;
        }
    }

    header("Location: user_requests.php");
    exit;
}

/* ================================
   دريافت کاربران در انتظار تاييد
================================ */
$q = $mysqli->query("SELECT * FROM users WHERE is_approved=0 ORDER BY requested_at DESC");

$rows = [];
while($q && $r = $q->fetch_assoc()){
    $rows[] = $r;
}

function toJalaliEn($date){
    if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
    list($gy,$gm,$gd)=explode('-',$date);
    return gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>درخواست هاي ثبت نام</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{
    font-family: IRANSansWeb, Tahoma;
    background:#f3f4f6;
    margin:0;
    padding:16px;
}
.container{
    max-width:1150px;
    margin:0 auto;
    background:white;
    padding:16px;
    border-radius:14px;
    box-shadow:0 4px 15px rgba(0,0,0,.08);
}
h1{
    margin:0 0 16px 0;
    font-size:20px;
}
.table-wrap{overflow-x:auto;}
table{width:100%;border-collapse:collapse;font-size:13px;}
th,td{padding:8px;border-bottom:1px solid #e2e8f0;white-space:nowrap;}
th{background:#f8fafc;font-weight:700;}
.btn{border:none;padding:6px 10px;border-radius:8px;font-size:12px;cursor:pointer;}
.btn-approve{background:#22c55e;color:white;}
.btn-reject{background:#ef4444;color:white;}
a.file{color:#0ea5e9;text-decoration:none;font-size:12px;}
</style>
</head>

<body>

<div class="container">
    <h1>درخواست هاي ثبت نام در انتظار تاييد</h1>

    <div class="table-wrap">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>نام</th>
                    <th>کاربري</th>
                    <th>موبايل</th>
                    <th>نقش</th>
                    <th>کد ملي</th>
                    <th>تولد</th>
                    <th>فایل</th>
                    <th>درخواست</th>
                    <th>عمليات</th>
                </tr>
            </thead>
            <tbody>

            <?php if(empty($rows)): ?>
                <tr><td colspan="10">هيچ درخواستي موجود نيست.</td></tr>
            <?php else: ?>
                <?php
                $baseURL = '/orders/uploads/logistic/';
                foreach($rows as $r):
                ?>
                    <tr>
                        <td><?= $r['id'] ?></td>
                        <td><?= $r['full_name'] ?></td>
                        <td><?= $r['username'] ?></td>
                        <td><?= $r['mobile'] ?></td>
                        <td><?= $r['role'] ?></td>
                        <td><?= $r['national_id'] ?></td>
                        <td><?= $r['birthdate'] ? toJalaliEn($r['birthdate']) : '-' ?></td>
                        <td>
                            <?php
                            if($r['photo_face']) echo '<a class="file" href="'.$baseURL.$r['photo_face'].'" target="_blank">چهره</a> ';
                            if($r['photo_nid']) echo '<a class="file" href="'.$baseURL.$r['photo_nid'].'" target="_blank">کارت ملي</a> ';
                            if($r['photo_car']) echo '<a class="file" href="'.$baseURL.$r['photo_car'].'" target="_blank">کارت ماشين</a>';
                            ?>
                        </td>
                        <td><?= $r['requested_at'] ?></td>

                        <td>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                                <input type="hidden" name="action" value="approve">
                                <button class="btn btn-approve">تاييد</button>
                            </form>

                            <form method="post" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                                <input type="hidden" name="action" value="reject">
                                <button class="btn btn-reject">رد</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

</div>

</body>
</html>
