<?php
require __DIR__.'/../../includes/auth.php';
require __DIR__.'/../../includes/config.php';
require __DIR__.'/../../includes/db_connect.php';
require __DIR__.'/../../includes/jdf.php';

if(($_SESSION['role'] ?? '') !== 'admin'){
    http_response_code(403);
    exit('دسترسي مجاز نيست');
}

$search = trim($_GET['search'] ?? '');
$role_filter = trim($_GET['role'] ?? '');
$approve_filter = trim($_GET['approved'] ?? '');

$where = "1";
$params = [];
$types = "";

if($search !== ""){
    $where .= " AND (full_name LIKE ? OR username LIKE ? OR mobile LIKE ?)";
    $s = "%".$search."%";
    $params[] = $s; 
    $params[] = $s; 
    $params[] = $s;
    $types .= "sss";
}

if($role_filter !== ""){
    $where .= " AND role=?";
    $params[] = $role_filter;
    $types .= "s";
}

if($approve_filter !== ""){
    $where .= " AND is_approved=?";
    $params[] = (int)$approve_filter;
    $types .= "i";
}

$sql = "SELECT * FROM users WHERE $where ORDER BY id DESC";
$stmt = $mysqli->prepare($sql);

if(count($params) > 0){
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$res = $stmt->get_result();

function toJ($d){
    if(!$d || !preg_match('/^\d+/', $d)) return '-';
    list($y,$m,$d2) = explode('-', substr($d,0,10));
    return gregorian_to_jalali($y,$m,$d2,'/');
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>مديريت کاربران</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- 💥 لود کردن CSS اصلی صفحه -->
<link rel="stylesheet" href="user.css">

</head>

<body>

<?php require __DIR__.'/../../includes/header.php'; ?>

<div class="saas-container">

    <h1 class="saas-title">مديريت کاربران</h1>

    <!-- Filters -->
    <form class="saas-filters" method="get">
        <input type="text" name="search" placeholder="جستجو..." value="<?= htmlspecialchars($search ?? '') ?>">

        <select name="role">
            <option value="">نقش</option>
            <option value="seller" <?= $role_filter=='seller'?'selected':'' ?>>فروشنده</option>
            <option value="buyer" <?= $role_filter=='buyer'?'selected':'' ?>>مسئول خريد</option>
            <option value="logistic" <?= $role_filter=='logistic'?'selected':'' ?>>لجستيک</option>
            <option value="head_carrier" <?= $role_filter=='head_carrier'?'selected':'' ?>>سرکارگر</option>
            <option value="support" <?= $role_filter=='support'?'selected':'' ?>>پشتيباني</option>
            <option value="admin" <?= $role_filter=='admin'?'selected':'' ?>>مدير</option>
        </select>

        <select name="approved">
            <option value="">وضعيت</option>
            <option value="0" <?= $approve_filter==='0'?'selected':'' ?>>منتظر تاييد</option>
            <option value="1" <?= $approve_filter==='1'?'selected':'' ?>>تاييد شده</option>
            <option value="2" <?= $approve_filter==='2'?'selected':'' ?>>رد شده</option>
        </select>

        <button class="saas-btn">فيلتر</button>
    </form>

    <div class="table-wrap">
    <table class="saas-table">
        <thead>
            <tr>
                <th>#</th>
                <th>نام</th>
                <th>کاربري</th>
                <th>موبايل</th>
                <th>نقش</th>
                <th>وضعيت</th>
                <th>تولد</th>
                <th>درخواست</th>
                <th>اعمال</th>
            </tr>
        </thead>
        <tbody>

        <?php if($res->num_rows==0): ?>
            <tr><td colspan="9">هيچ داده اي يافت نشد.</td></tr>
        <?php else: ?>
            <?php while($u = $res->fetch_assoc()): ?>
                <tr>
                    <td><?= $u['id'] ?></td>
                    <td><?= htmlspecialchars($u['full_name'] ?? '') ?></td>
                    <td><?= htmlspecialchars($u['username'] ?? '') ?></td>
                    <td><?= htmlspecialchars($u['mobile'] ?? '') ?></td>
                    <td><?= htmlspecialchars($u['role'] ?? '') ?></td>

                    <td>
                        <?php if($u['is_approved']==0): ?>
                            <span class="badge badge-wait">منتظر تاييد</span>
                        <?php elseif($u['is_approved']==1): ?>
                            <span class="badge badge-ok">تاييد شده</span>
                        <?php else: ?>
                            <span class="badge badge-no">رد شده</span>
                        <?php endif; ?>
                    </td>

                    <td><?= toJ($u['birthdate']) ?></td>
                    <td><?= $u['requested_at'] ?></td>

                    <td>
                        <a class="action-btn btn-view" href="user_view.php?id=<?= $u['id'] ?>">مشاهده</a>
                        <a class="action-btn btn-edit" href="user_edit.php?id=<?= $u['id'] ?>">ويرايش</a>
                        <a class="action-btn btn-del" href="user_delete.php?id=<?= $u['id'] ?>" onclick="return confirm('حذف شود؟')">حذف</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php endif; ?>

        </tbody>
    </table>
    </div>

</div>

</body>
</html>
