<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

header('Content-Type: application/json; charset=utf-8');

// ==========================
// دریافت ورودی
// ==========================
$uid    = trim($_POST['order_uid'] ?? '');
$oid    = isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0;
$status = trim($_POST['status'] ?? ''); // این همان shipping_status جدید است
$note   = trim($_POST['note'] ?? '');

// اگر order_uid داریم → تبدیل به id
if ($uid !== '') {
    $stmt = $mysqli->prepare('SELECT id FROM orders WHERE order_uid=? LIMIT 1');
    if ($stmt) {
        $stmt->bind_param('s', $uid);
        $stmt->execute();
        $row = $stmt->get_result()->fetch_assoc();
        $stmt->close();
        if ($row) {
            $oid = (int)$row['id'];
        }
    }
}

// ==========================
// ولیدیشن
// ==========================
$allowed = [
    'new',
    'assigned_to_buyer',
    'purchased',
    'handover_to_head',
    'out_for_delivery',
    'delivered',
    'failed'
];

if ($oid <= 0 || !in_array($status, $allowed, true)) {
    echo json_encode([
        'ok'    => false,
        'error' => 'اطلاعات ناقص یا نامعتبر'
    ]);
    exit;
}

// ==========================
// آپدیت وضعیت در جدول orders
// ==========================

if ($status === 'delivered') {
    // اگر تحویل موفق شد → هم shipping_status، هم status_note و اگر delivered_at خالی بود، الان ست شود
    $sql = 'UPDATE orders 
            SET shipping_status = ?, 
                status_note = ?, 
                delivered_at = IF(delivered_at IS NULL, NOW(), delivered_at)
            WHERE id = ?';
} else {
    // بقیه وضعیت‌ها → فقط shipping_status و status_note
    $sql = 'UPDATE orders 
            SET shipping_status = ?, 
                status_note = ?
            WHERE id = ?';
}

$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    echo json_encode([
        'ok'    => false,
        'error' => 'خطا در آماده سازی کویری دیتابیس'
    ]);
    exit;
}

$stmt->bind_param('ssi', $status, $note, $oid);
$ok = $stmt->execute();
$stmt->close();

// ==========================
// پاسخ
// ==========================
echo json_encode([
    'ok'              => $ok,
    'shipping_status' => $status,
    'note'            => $note,
    'updated_at'      => date('Y-m-d H:i:s')
]);
