<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';

$username = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? 'seller';

if ($role === 'admin') {
  die('<p style="text-align:center;color:red;margin-top:30px">فقط فروشنده می‌تواند درخواست تسویه ثبت کند.</p>');
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $amount = (int)($_POST['amount'] ?? 0);
  $note   = trim($_POST['note'] ?? '');
  
  if ($amount <= 0) {
    $msg = '<p style="color:red">مبلغ نامعتبر است.</p>';
  } else {
    $stmt = $mysqli->prepare("INSERT INTO settlements (username, amount, note) VALUES (?, ?, ?)");
    $stmt->bind_param('sis', $username, $amount, $note);
    if ($stmt->execute()) {
      $msg = '<p style="color:green">درخواست تسویه با موفقیت ثبت شد ✅</p>';
    } else {
      $msg = '<p style="color:red">خطا در ثبت درخواست. لطفاً دوباره تلاش کنید.</p>';
    }
    $stmt->close();
  }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>درخواست تسویه | سلام‌بابا</title>
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<style>
body {
  font-family: 'IRANYekan', sans-serif;
  background: #f7f8fa;
  color: #333;
  text-align: center;
  padding: 50px 20px;
}
form {
  max-width: 400px;
  margin: 0 auto;
  background: #fff;
  border-radius: 16px;
  padding: 30px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.1);
}
input, textarea {
  width: 100%;
  padding: 10px;
  margin: 8px 0;
  border: 1px solid #ccc;
  border-radius: 10px;
  font-family: inherit;
}
button {
  background: #f59e0b;
  border: none;
  padding: 10px 20px;
  border-radius: 8px;
  color: white;
  font-weight: bold;
  cursor: pointer;
  transition: 0.2s;
}
button:hover { background: #d97706; }
</style>
</head>
<body>

<h2>💸 درخواست تسویه حساب</h2>
<p>مبلغ مورد نظر خود را برای تسویه وارد کنید.</p>
<?= $msg ?>

<form method="POST">
  <label>مبلغ (تومان)</label>
  <input type="number" name="amount" min="1" required>

  <label>توضیحات (اختیاری)</label>
  <textarea name="note" rows="3" placeholder="توضیحی در مورد تسویه..."></textarea>

  <button type="submit">ثبت درخواست</button>
</form>

<p style="margin-top:25px;">
  <a href="../index.php" style="color:#007bff;text-decoration:none;">⬅ بازگشت به داشبورد</a>
</p>

</body>
</html>
