<?php
// ================================================
//  jdf.php — نسخه‌ی سبک و سازگار با PHP 7.4
//  پشتیبانی از jdate, gregorian_to_jalali, jalali_to_gregorian
// ================================================

if (!function_exists('gregorian_to_jalali')) {
    function gregorian_to_jalali($gy, $gm, $gd, $mod = '')
    {
        $g_d_m = array(0,31,59,90,120,151,181,212,243,273,304,334);
        if($gy > 1600){
            $jy = 979;
            $gy -= 1600;
        }else{
            $jy = 0;
            $gy -= 621;
        }
        $gy2 = ($gm > 2)? ($gy + 1) : $gy;
        $days = (365 * $gy) + floor(($gy2 + 3) / 4) - floor(($gy2 + 99) / 100) + floor(($gy2 + 399) / 400) - 80 + $gd + $g_d_m[$gm-1];
        $jy += 33 * floor($days / 12053);
        $days %= 12053;
        $jy += 4 * floor($days / 1461);
        $days %= 1461;
        if($days > 365){
            $jy += floor(($days - 1) / 365);
            $days = ($days - 1) % 365;
        }
        $jm = ($days < 186) ? 1 + floor($days / 31) : 7 + floor(($days - 186) / 30);
        $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
        if ($mod == '') return array($jy, $jm, $jd);
        return $jy.$mod.$jm.$mod.$jd;
    }
}

if (!function_exists('jalali_to_gregorian')) {
    function jalali_to_gregorian($jy, $jm, $jd, $mod = '')
    {
        if($jy > 979){
            $gy = 1600;
            $jy -= 979;
        }else{
            $gy = 621;
        }
        $days = (365 * $jy) + (int)(($jy / 33)) * 8 + (int)((($jy % 33) + 3) / 4) + 78 + $jd + (($jm < 7) ? ($jm - 1) * 31 : (($jm - 7) * 30 + 186));
        $gy += 400 * floor($days / 146097);
        $days %= 146097;
        if($days > 36524){
            $gy += 100 * floor(--$days / 36524);
            $days %= 36524;
            if($days >= 365) $days++;
        }
        $gy += 4 * floor($days / 1461);
        $days %= 1461;
        if($days > 365){
            $gy += floor(($days - 1) / 365);
            $days = ($days - 1) % 365;
        }
        $gd = $days + 1;
        $sal_a = array(0,31, ( ($gy%4==0 && $gy%100!=0) || ($gy%400==0) )?29:28,31,30,31,30,31,31,30,31,30,31);
        for($gm = 0; $gm < 13; $gm++){
            $v = $sal_a[$gm];
            if($gd <= $v) break;
            $gd -= $v;
        }
        if ($mod == '') return array($gy, $gm, $gd);
        return $gy.$mod.$gm.$mod.$gd;
    }
}

if (!function_exists('jdate')) {
    function jdate($format = 'Y/m/d', $timestamp = null)
    {
        if ($timestamp === null) $timestamp = time();
        list($gy,$gm,$gd) = explode('-', date('Y-m-d', $timestamp));
        list($jy,$jm,$jd) = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd);
        $replace = array(
            'Y' => $jy,
            'm' => str_pad($jm,2,'0',STR_PAD_LEFT),
            'd' => str_pad($jd,2,'0',STR_PAD_LEFT),
        );
        return strtr($format, $replace);
    }
}
?>
