<?php
function queue_notification($channel_code, $message, $photo=null, $document=null, $buttons=null){
    global $mysqli;

    $stmt = $mysqli->prepare("
        INSERT INTO notifications_queue
        (channel_code, message, photo_url, document_path, buttons)
        VALUES (?,?,?,?,?)
    ");
    $btn = $buttons ? json_encode($buttons, JSON_UNESCAPED_UNICODE) : null;
    $stmt->bind_param("sssss", $channel_code, $message, $photo, $document, $btn);
    $stmt->execute();
}

function process_queue(){
    global $mysqli;

    $res = $mysqli->query("
        SELECT * FROM notifications_queue 
        WHERE status='pending' 
        ORDER BY id ASC
        LIMIT 1
    ");

    if(!$res || $res->num_rows == 0) return;

    $job = $res->fetch_assoc();
    $id = $job['id'];

    $mysqli->query("UPDATE notifications_queue SET status='sending' WHERE id=$id");

    $channel_code = $job['channel_code'];

    $q = $mysqli->prepare("SELECT bot_token, chat_id FROM telegram_channels WHERE code=? LIMIT 1");
    $q->bind_param("s", $channel_code);
    $q->execute();
    $q->bind_result($token, $chat_id);
    $q->fetch();
    $q->close();

    if(!$token || !$chat_id){
        $mysqli->query("UPDATE notifications_queue SET status='failed' WHERE id=$id");
        return;
    }

    $message = $job['message'];
    $photo   = $job['photo_url'];
    $doc     = $job['document_path'];
    $buttons = json_decode($job['buttons'], true);

    $base = "https://api.telegram.org/bot{$token}/";

    if($doc){
        $endpoint = $base . "sendDocument";
        $fields = [
          "chat_id" => $chat_id,
          "caption" => $message,
          "document" => new CURLFile(realpath($doc))
        ];
    } elseif($photo){
        $endpoint = $base . "sendPhoto";
        $fields = [
          "chat_id" => $chat_id,
          "caption" => $message,
          "photo" => $photo
        ];
    } else {
        $endpoint = $base . "sendMessage";
        $fields = [
          "chat_id" => $chat_id,
          "text" => $message,
          "parse_mode" => "HTML"
        ];
    }

    if($buttons){
        $fields['reply_markup'] = json_encode([
            "inline_keyboard" => $buttons
        ], JSON_UNESCAPED_UNICODE);
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

    $response = curl_exec($ch);
    curl_close($ch);

    $mysqli->query("
        INSERT INTO notifications_log (channel_code, status, response)
        VALUES ('{$channel_code}', 'sent', '{$mysqli->real_escape_string($response)}')
    ");

    $mysqli->query("UPDATE notifications_queue SET status='sent' WHERE id=$id");
}
