<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';

$user_id = (int)($_SESSION['user_id'] ?? 0);
if ($user_id <= 0) {
    header("Location: ../login.php");
    exit;
}

$msg = "";
$err = "";

// دريافت اطلاعات کامل کاربر
$stmt = $mysqli->prepare("
    SELECT username, full_name, mobile, national_id, birthdate, address, vehicle, plate, photo_face 
    FROM users 
    WHERE id=? 
    LIMIT 1
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$user){
    exit("کاربر يافت نشد");
}

// مسير آپلود
$uploadDir  = __DIR__."/../uploads/logistic/";
$uploadBase = "/orders/uploads/logistic/";

if(!is_dir($uploadDir)){
    mkdir($uploadDir, 0777, true);
}

/* ==========================================
   پردازش فرم
========================================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $new_fullname = trim($_POST['full_name'] ?? '');
    $new_username = trim($_POST['username'] ?? '');
    $new_mobile   = trim($_POST['mobile'] ?? '');
    $new_nid      = trim($_POST['national_id'] ?? '');
    $new_birthraw = trim($_POST['birthdate'] ?? '');
    $new_address  = trim($_POST['address'] ?? '');
    $new_vehicle  = trim($_POST['vehicle'] ?? '');
    $new_plate    = trim($_POST['plate'] ?? '');

    $birthdate = ($new_birthraw === "") ? NULL : $new_birthraw;

    $pass1 = trim($_POST['password'] ?? '');
    $pass2 = trim($_POST['password2'] ?? '');

    // اعتبارسنجي
    if ($new_username === "") {
        $err = "نام کاربري نمي‌تواند خالي باشد.";
    } elseif ($new_fullname === "") {
        $err = "نام کامل نمي‌تواند خالي باشد.";
    } elseif ($pass1 !== "" && $pass1 !== $pass2) {
        $err = "رمز جديد با تکرار يکسان نيست.";
    } else {

        // چک تکراري نبودن نام کاربري
        $stmt = $mysqli->prepare("SELECT id FROM users WHERE username=? AND id<>?");
        $stmt->bind_param("si", $new_username, $user_id);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $err = "اين نام کاربري قبلاً استفاده شده است.";
        } else {
            // آپديت اطلاعات اصلي
            $stmt_upd = $mysqli->prepare("
                UPDATE users SET
                    username=?,
                    full_name=?,
                    mobile=?,
                    national_id=?,
                    birthdate=?,
                    address=?,
                    vehicle=?,
                    plate=?
                WHERE id=?
                LIMIT 1
            ");

            $stmt_upd->bind_param(
                "ssssssssi",
                $new_username,
                $new_fullname,
                $new_mobile,
                $new_nid,
                $birthdate,
                $new_address,
                $new_vehicle,
                $new_plate,
                $user_id
            );

            if (!$stmt_upd->execute()) {
                $err = "خطا در ذخيره اطلاعات: ".$stmt_upd->error;
            } else {

                // اگر رمز جديد وارد شده
                if ($pass1 !== "") {
                    $hash = password_hash($pass1, PASSWORD_BCRYPT);
                    $stmt_p = $mysqli->prepare("UPDATE users SET password_hash=? WHERE id=? LIMIT 1");
                    $stmt_p->bind_param("si", $hash, $user_id);
                    $stmt_p->execute();
                    $stmt_p->close();
                }

                // آپلود عکس جديد (اختياري)
                if(isset($_FILES['photo_face']) && $_FILES['photo_face']['error'] === 0){
                    $ext = strtolower(pathinfo($_FILES['photo_face']['name'], PATHINFO_EXTENSION));
                    $newname = uniqid().".".$ext;
                    move_uploaded_file($_FILES['photo_face']['tmp_name'], $uploadDir.$newname);

                    $stmt_p = $mysqli->prepare("UPDATE users SET photo_face=? WHERE id=? LIMIT 1");
                    $stmt_p->bind_param("si", $newname, $user_id);
                    $stmt_p->execute();
                    $stmt_p->close();

                    $user['photo_face'] = $newname;
                }

                // آپديت آرايه براي نمايش فرم
                $user['username']    = $new_username;
                $user['full_name']   = $new_fullname;
                $user['mobile']      = $new_mobile;
                $user['national_id'] = $new_nid;
                $user['birthdate']   = $birthdate;
                $user['address']     = $new_address;
                $user['vehicle']     = $new_vehicle;
                $user['plate']       = $new_plate;

                $_SESSION['username'] = $new_username;
                $msg = "تغييرات با موفقيت ذخيره شد.";
            }

            $stmt_upd->close();
        }

        $stmt->close();
    }
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>پروفايل کاربري — سلام بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- استفاده از همان UI کاربران -->
<link rel="stylesheet" href="users/user.css">

<style>
body{
    background:#f3f4f6;
    font-family:IRANSansWeb, Tahoma, sans-serif;
    padding:20px;
}
.profile-box{
    max-width:650px;
    margin:30px auto;
    background:#ffffff;
    padding:24px;
    border-radius:16px;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
}
.profile-title{
    font-size:20px;
    font-weight:900;
    margin-bottom:18px;
    color:#0f172a;
}
.current-photo{
    width:120px;
    border-radius:12px;
    margin-top:8px;
    box-shadow:0 4px 12px rgba(0,0,0,.15);
}
.ok-msg{
    background:#d1fae5;
    color:#065f46;
    padding:10px;
    border-radius:10px;
    margin-bottom:10px;
    font-size:14px;
}
.err-msg{
    background:#fee2e2;
    color:#b91c1c;
    padding:10px;
    border-radius:10px;
    margin-bottom:10px;
    font-size:14px;
}
</style>
</head>

<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="profile-box">

    <div class="profile-title">پروفايل کاربري</div>

    <?php if($msg): ?>
        <div class="ok-msg"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>

    <?php if($err): ?>
        <div class="err-msg"><?= htmlspecialchars($err) ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">

        <div class="saas-form-group">
            <label>نام کامل</label>
            <input type="text" name="full_name" value="<?= htmlspecialchars($user['full_name'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>نام کاربري</label>
            <input type="text" name="username" value="<?= htmlspecialchars($user['username'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>موبايل</label>
            <input type="text" name="mobile" value="<?= htmlspecialchars($user['mobile'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>کد ملي</label>
            <input type="text" name="national_id" value="<?= htmlspecialchars($user['national_id'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>تاريخ تولد</label>
            <input type="text" name="birthdate" value="<?= htmlspecialchars($user['birthdate'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>آدرس</label>
            <textarea name="address" rows="3"><?= htmlspecialchars($user['address'] ?? '') ?></textarea>
        </div>

        <div class="saas-form-group">
            <label>نوع وسيله نقليه</label>
            <select name="vehicle">
                <option value="motorcycle" <?= ($user['vehicle'] ?? '')=='motorcycle'?'selected':'' ?>>موتورسیکلت</option>
                <option value="car" <?= ($user['vehicle'] ?? '')=='car'?'selected':'' ?>>خودرو</option>
                <option value="van" <?= ($user['vehicle'] ?? '')=='van'?'selected':'' ?>>وانت</option>
            </select>
        </div>

        <div class="saas-form-group">
            <label>پلاک</label>
            <input type="text" name="plate" value="<?= htmlspecialchars($user['plate'] ?? '') ?>">
        </div>

        <div class="saas-form-group">
            <label>عکس پروفايل</label>
            <?php if(!empty($user['photo_face'])): ?>
                <img src="<?= $uploadBase.$user['photo_face'] ?>" class="current-photo">
            <?php endif; ?>
            <input type="file" name="photo_face">
        </div>

        <div class="saas-form-group">
            <label>رمز جديد (اختياري)</label>
            <input type="password" name="password">
        </div>

        <div class="saas-form-group">
            <label>تکرار رمز جديد</label>
            <input type="password" name="password2">
        </div>

        <button class="saas-btn" style="margin-top:10px;">ذخيره تغييرات</button>

    </form>

</div>

</body>
</html>
