<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('ACCESS DENIED');
}

$action    = trim($_POST['action']    ?? '');
$order_uid = trim($_POST['order_uid'] ?? '');

if ($order_uid === '' || $action === '') {
    exit('bad request');
}

// سفارش را پیدا کن
$stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $order_uid);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) {
    exit('order not found');
}

// محدودیت دسترسی خریدار
if ($role !== 'admin') {
    if (($order['buyer_username'] ?? '') !== $username) {
        http_response_code(403);
        exit('ACCESS DENIED ORDER');
    }
}

$order_id    = (int)$order['id'];
$seller_user = $order['username'] ?? '';
$customer    = $order['customer_name'] ?? '';

// ===========================
//  تابع برای تبدیل تاریخ جلالی
// ===========================
function jalaliToGregorianDate($jd){
    if ($jd === '') return null;
    if (!preg_match('/^(\d{4})[\/\-](\d{1,2})[\/\-](\d{1,2})$/',$jd,$m)) return null;
    $jy = (int)$m[1];
    $jm = (int)$m[2];
    $jd = (int)$m[3];
    if (!function_exists('jalali_to_gregorian')) return null;
    return jalali_to_gregorian($jy,$jm,$jd,'-');
}

// ===========================
//  اکشن: ثبت خرید
// ===========================
if ($action === 'buy') {

    $buy_date = trim($_POST['buy_date'] ?? '');
    $buy_note = trim($_POST['buy_note'] ?? '');

    $gdate = jalaliToGregorianDate($buy_date);

    $parts = [];
    if ($buy_date !== '') $parts[] = 'تاریخ خرید: '.$buy_date;
    if ($buy_note !== '') $parts[] = 'توضیحات خرید: '.$buy_note;
    $extra_note = $parts ? "\n".implode(' | ', $parts) : "\nخرید انجام شد";

    if ($gdate !== null) {
        $stmt = $mysqli->prepare("
            UPDATE orders
            SET shipping_status='purchased',
                purchase_date=?,
                status_note = CONCAT(COALESCE(status_note,''), ?)
            WHERE order_uid=? LIMIT 1
        ");
        $stmt->bind_param('sss', $gdate, $extra_note, $order_uid);
    } else {
        $stmt = $mysqli->prepare("
            UPDATE orders
            SET shipping_status='purchased',
                status_note = CONCAT(COALESCE(status_note,''), ?)
            WHERE order_uid=? LIMIT 1
        ");
        $stmt->bind_param('ss', $extra_note, $order_uid);
    }
    $stmt->execute();
    $stmt->close();

    // نوتیفیکیشن برای فروشنده
    if ($seller_user !== '') {
        $seller_esc   = $mysqli->real_escape_string($seller_user);
        $customer_esc = $mysqli->real_escape_string($customer);
        $mysqli->query("
            INSERT INTO notifications (username, type, order_id, title, message, created_at)
            VALUES (
              '{$seller_esc}',
              'status',
              {$order_id},
              'کالا خرید شد',
              'خرید سفارش مشتری {$customer_esc} انجام شد.',
              NOW()
            )
        ");
    }

    header("Location: buyer_view.php?id=".urlencode($order_uid));
    exit;
}

// ===========================
//  اکشن: تحویل به سر باربر
// ===========================
if ($action === 'handover') {

    $head_username = trim($_POST['head_username'] ?? '');
    $handover_date = trim($_POST['handover_date'] ?? '');
    $handover_note = trim($_POST['handover_note'] ?? '');

    if ($head_username === '') {
        exit('bad data');
    }

    $gdate = jalaliToGregorianDate($handover_date);

    $parts = [];
    if ($handover_date !== '') $parts[] = 'تاریخ تحویل به سرباربر: '.$handover_date;
    if ($handover_note !== '') $parts[] = 'توضیحات تحویل: '.$handover_note;
    $extra_note = $parts ? "\n".implode(' | ', $parts) : "\nکالا به سرباربر تحویل شد";

    $head_esc = $mysqli->real_escape_string($head_username);

    if ($gdate !== null) {
        $stmt = $mysqli->prepare("
            UPDATE orders
            SET shipping_status='handover_to_head',
                head_carrier_username=?,
                status_note = CONCAT(COALESCE(status_note,''), ?)
            WHERE order_uid=? LIMIT 1
        ");
        $stmt->bind_param('sss', $head_username, $extra_note, $order_uid);
    } else {
        $stmt = $mysqli->prepare("
            UPDATE orders
            SET shipping_status='handover_to_head',
                head_carrier_username=?,
                status_note = CONCAT(COALESCE(status_note,''), ?)
            WHERE order_uid=? LIMIT 1
        ");
        $stmt->bind_param('sss', $head_username, $extra_note, $order_uid);
    }
    $stmt->execute();
    $stmt->close();

    // نوتیفیکیشن برای سر باربر
    $customer_esc = $mysqli->real_escape_string($customer);
    $mysqli->query("
        INSERT INTO notifications (username, type, order_id, title, message, created_at)
        VALUES (
          '{$head_esc}',
          'order_assigned_head',
          {$order_id},
          'سفارش جدید برای ارسال',
          'سفارش مشتری {$customer_esc} برای ارسال آماده است.',
          NOW()
        )
    ");

    header("Location: buyer_view.php?id=".urlencode($order_uid));
    exit;
}

// اگر اکشن ناشناخته بود
exit('unknown action');
