<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

function nf($n){ return number_format((float)$n, 0, '.', ','); }
function safe($x){ return htmlspecialchars($x ?? '', ENT_QUOTES, 'UTF-8'); }
function toJalaliEn($d){
    if(!$d || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd)=explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j,[
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
    ]);
}

/* ===============================
   1) هندل POST برای کامنت (بدون خراب کردن بقیه)
================================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action_post = $_POST['action'] ?? '';
    $uid_post    = trim($_POST['order_uid'] ?? '');

    if ($action_post === 'add_comment' && $uid_post !== '') {

        // واکشی سفارش برای اطمینان از دسترسی
        $stmt = $mysqli->prepare("SELECT id, order_uid, buyer_username FROM orders WHERE order_uid=? LIMIT 1");
        $stmt->bind_param('s', $uid_post);
        $stmt->execute();
        $ord = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($ord) {
            if ($role === 'admin' || ($ord['buyer_username'] ?? '') === $username) {
                $order_id  = (int)$ord['id'];
                $msg       = trim($_POST['comment_message'] ?? '');

                if ($msg !== '') {
                    // چک کنیم جدول order_comments وجود دارد یا نه
                    $chk = $mysqli->query("SHOW TABLES LIKE 'order_comments'");
                    if ($chk && $chk->num_rows > 0) {
                        $stmt = $mysqli->prepare("
                            INSERT INTO order_comments (order_id, order_uid, username, role, message, created_at)
                            VALUES (?,?,?,?,?,NOW())
                        ");
                        $stmt->bind_param(
                            'issss',
                            $order_id,
                            $uid_post,
                            $username,
                            $role,
                            $msg
                        );
                        $stmt->execute();
                        $stmt->close();
                    }
                }
            }
        }

        header("Location: buyer_view.php?id=".urlencode($uid_post)."#tab-comments");
        exit;
    }

    // اگر اکشن چیز دیگری بود (مثل buy / handover)، دست نزنیم
}

/* ===============================
   2) دریافت UID و سفارش
================================= */
$uid = trim($_GET['id'] ?? '');
if ($uid === '') {
    exit('شناسه سفارش نامعتبر است.');
}

$stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $uid);
$stmt->execute();
$o = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$o) {
    exit('سفارش یافت نشد.');
}

// فقط سفارش‌های مسئول خرید، به جز ادمین
if ($role !== 'admin') {
    if (($o['buyer_username'] ?? '') !== $username) {
        http_response_code(403);
        exit('دسترسی به این سفارش برای شما مجاز نیست.');
    }
}

/* ===============================
   3) اطلاعات تکمیلی
================================= */
$order_id = (int)($o['id'] ?? 0);

// اقلام سفارش
$items = [];
if ($order_id > 0) {
    $stmt = $mysqli->prepare('SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC');
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while($row = $res->fetch_assoc()){ $items[] = $row; }
    $stmt->close();
}

// کامنت‌ها (اگر جدول وجود داشته باشد)
$comments = [];
$chkC = $mysqli->query("SHOW TABLES LIKE 'order_comments'");
if ($chkC && $chkC->num_rows > 0 && $order_id > 0) {
    $stmt = $mysqli->prepare("
        SELECT oc.*, u.full_name 
        FROM order_comments oc
        LEFT JOIN users u ON u.username = oc.username
        WHERE oc.order_id=?
        ORDER BY oc.id DESC
    ");
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $resC = $stmt->get_result();
    while($row = $resC->fetch_assoc()){ $comments[] = $row; }
    $stmt->close();
}

// لیست سر باربر / لجستیک
$heads = [];
$resHeads = $mysqli->query("
    SELECT username, full_name 
    FROM users 
    WHERE role IN ('logistic','head_carrier') AND is_approved=1
    ORDER BY full_name
");
if ($resHeads) {
    while($r = $resHeads->fetch_assoc()){
        $heads[] = $r;
    }
}

// گارانتی
$wmap = [
  'none'   => 'بدون گارانتی',
  'gold'   => 'طلایی',
  'silver' => 'نقره‌ای',
  'bronze' => 'برنزی',
  ''       => 'بدون گارانتی'
];
$w_raw          = strtolower(trim($o['warranty'] ?? ''));
$warranty_label = $wmap[$w_raw] ?? safe($o['warranty'] ?? '');

// وضعیت فارسی
$status_map = [
  'new'               => '🕓 ثبت شده (در انتظار بررسی)',
  'assigned_to_buyer' => '📌 ارجاع به مسئول خرید',
  'purchased'         => '🛒 کالا خریداری شده (در حال آماده سازی)',
  'handover_to_head'  => '📦 تحویل به سر باربر',
  'out_for_delivery'  => '🚚 در حال ارسال',
  'delivered'         => '✅ تحویل داده شد',
  'failed'            => '❌ تحویل ناموفق / نیاز به هماهنگی'
];

$status_raw   = trim($o['shipping_status'] ?? 'new');
$status_label = $status_map[$status_raw] ?? 'در حال بررسی';

$track_link = rtrim(BASE_URL,'/').'/track.php?code='.rawurlencode($o['tracking_code'] ?? '');
$view_link  = '/orders/view.php?id='.urlencode($uid);

// تایم‌لاین مراحل
$steps = [
    'new'               => 'ثبت سفارش',
    'assigned_to_buyer' => 'ارجاع به مسئول خرید',
    'purchased'         => 'خرید کالا',
    'handover_to_head'  => 'تحویل به سر باربر',
    'out_for_delivery'  => 'در حال ارسال',
    'delivered'         => 'تحویل موفق',
    'failed'            => 'تحویل ناموفق'
];
$step_keys = array_keys($steps);
$current_index = array_search($status_raw, $step_keys, true);
if ($current_index === false) $current_index = 0;
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>سفارش <?= safe($uid) ?> — مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="/orders/assets/buyer_pro.css">
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="page">

  <!-- Smart Header + Timeline -->
  <div class="card">
    <div class="order-header">
      <div class="order-header-main">
        <div class="uid">🧾 سفارش <?= safe($uid) ?></div>
        <div class="customer">
          مشتری: <?= safe($o['customer_name']) ?>
          <?php if(!empty($o['mobile1'])): ?>
            <span class="badge-small">📱 <?= safe($o['mobile1']) ?></span>
          <?php endif; ?>
        </div>
        <div class="customer">
          فروشنده: <?= safe($o['seller_name']) ?> 
          <span class="badge-small">@<?= safe($o['username']) ?></span>
        </div>
      </div>
      <div class="order-header-badges">
        <span class="badge-small">استان: <?= safe($o['province']) ?></span>
        <span class="badge-small">شهر: <?= safe($o['city'] ?? '') ?></span>
        <span class="badge-small">ثبت: <?= toJalaliEn(substr($o['created_at'] ?? '',0,10)) ?></span>
        <span class="badge-small">خرید: <?= toJalaliEn($o['purchase_date'] ?? '') ?></span>
        <span class="badge-small"><?= $status_label ?></span>
      </div>
    </div>

    <div class="timeline">
      <?php
      $i = 0;
      foreach($steps as $key => $label):
        $cls = '';
        if ($i < $current_index) $cls = 'done';
        elseif ($i === $current_index) $cls = 'active';
      ?>
        <div class="timeline-step">
          <div class="timeline-circle <?= $cls ?>"></div>
          <div class="timeline-label"><?= safe($label) ?></div>
        </div>
      <?php
        $i++;
      endforeach;
      ?>
    </div>
  </div>

  <!-- Tabs -->
  <div class="card">
    <div class="tabs">
      <button class="tab-btn active" data-tab="info">اطلاعات سفارش</button>
      <button class="tab-btn" data-tab="status">وضعیت</button>
      <button class="tab-btn" data-tab="buy">ثبت خرید</button>
      <button class="tab-btn" data-tab="handover">تحویل به سر باربر</button>
      <button class="tab-btn" data-tab="comments">یادداشت داخلی</button>
    </div>

    <!-- Tab: Info -->
    <section id="tab-info" class="tab-section active">
      <div class="info-grid" style="margin-top:10px;">
        <div class="info-item">
          <span class="label">کد پیگیری</span>
          <span class="value"><?= safe($o['tracking_code']) ?></span>
        </div>
        <div class="info-item">
          <span class="label">گارانتی</span>
          <span class="value"><?= $warranty_label ?></span>
        </div>
        <div class="info-item">
          <span class="label">بیعانه کل</span>
          <span class="value"><?= nf($o['total_deposit'] ?? 0) ?> تومان</span>
        </div>
        <div class="info-item">
          <span class="label">COD</span>
          <span class="value"><?= nf($o['total_cod'] ?? 0) ?> تومان</span>
        </div>
        <div class="info-item">
          <span class="label">مانده</span>
          <span class="value"><?= nf($o['total_remaining'] ?? 0) ?> تومان</span>
        </div>
      </div>

      <div class="info-item" style="margin-top:8px;">
        <span class="label">آدرس کامل</span>
        <span class="value"><?= safe($o['address']) ?></span>
      </div>

      <?php if(!empty($o['notes'])): ?>
        <div class="note-box">
          <b>توضیحات فروش:</b><br>
          <?= nl2br(safe($o['notes'])) ?>
        </div>
      <?php endif; ?>

      <!-- اقلام -->
      <h3 style="margin-top:12px;">اقلام سفارش</h3>
      <?php if(empty($items)): ?>
        <p style="margin:0;color:#6b7280;font-size:13px;">هیچ قلمی ثبت نشده است.</p>
      <?php else: ?>
        <table class="table">
          <thead>
            <tr>
              <th>#</th>
              <th>مدل</th>
              <th>قیمت</th>
              <th>بیعانه</th>
              <th>COD</th>
              <th>مانده</th>
            </tr>
          </thead>
          <tbody>
          <?php $i=1; foreach($items as $it): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= safe($it['model']) ?></td>
              <td><?= nf($it['price']) ?></td>
              <td><?= nf($it['deposit']) ?></td>
              <td><?= nf($it['cod']) ?></td>
              <td><?= nf($it['remaining']) ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      <?php endif; ?>

      <div class="totals">
        <div>جمع فروش: <b><?= nf($o['total_amount'] ?? 0) ?></b></div>
        <div>بیعانه: <b><?= nf($o['total_deposit'] ?? 0) ?></b></div>
        <div>COD: <b><?= nf($o['total_cod'] ?? 0) ?></b></div>
        <div>مانده: <b><?= nf($o['total_remaining'] ?? 0) ?></b></div>
      </div>

      <div class="actions" style="margin-top:10px;">
        <a class="btn btn-back" href="index.php">بازگشت به لیست</a>
        <a class="btn btn-primary" href="<?= $view_link ?>" target="_blank">مشاهده فاکتور کامل</a>
        <?php if($track_link): ?>
          <a class="btn btn-ghost" href="<?= $track_link ?>" target="_blank">صفحه پیگیری مشتری</a>
        <?php endif; ?>
      </div>
    </section>

    <!-- Tab: Status -->
    <section id="tab-status" class="tab-section">
      <h3>وضعیت سفارش</h3>
      <p style="margin:0 0 1rem;font-weight:600;">
        وضعیت فعلی: <span style="color:#0369a1;"><?= $status_label ?></span>
      </p>

      <form id="statusForm" class="form-grid">
        <div class="field">
          <label>وضعیت</label>
          <select id="statusSelect" name="status">
            <option value="new">ثبت شده (در انتظار بررسی)</option>
            <option value="assigned_to_buyer">ارجاع به مسئول خرید</option>
            <option value="purchased">کالا خریداری شده (در حال آماده سازی)</option>
            <option value="handover_to_head">تحویل به سر باربر</option>
            <option value="out_for_delivery">در حال ارسال</option>
            <option value="delivered">تحویل داده شد</option>
            <option value="failed">تحویل ناموفق / نیاز به هماهنگی</option>
          </select>
        </div>
        <div class="field">
          <label>یادداشت وضعیت</label>
          <input id="statusNote" name="note" value="<?= safe($o['status_note']) ?>">
        </div>
        <div class="actions">
          <button class="btn btn-primary" type="submit">ثبت وضعیت</button>
          <?php if($track_link): ?>
            <a class="btn btn-ghost" href="<?= $track_link ?>" target="_blank">صفحه پیگیری</a>
          <?php endif; ?>
        </div>
      </form>
    </section>

    <!-- Tab: Buy -->
    <section id="tab-buy" class="tab-section">
      <h3>🛒 ثبت خرید کالا</h3>
      <?php if($status_raw !== 'assigned_to_buyer'): ?>
        <p style="font-size:13px;color:#6b7280;">
          فقط زمانی امکان ثبت خرید است که وضعیت «ارجاع به مسئول خرید» باشد.
          وضعیت فعلی: <?= $status_label ?>
        </p>
      <?php else: ?>
        <form method="post" action="action.php" class="form-grid">
          <input type="hidden" name="action" value="buy">
          <input type="hidden" name="order_uid" value="<?= safe($uid) ?>">

          <div class="field">
            <label>تاریخ خرید (شمسی)</label>
            <input 
              type="text" 
              name="buy_date" 
              placeholder="مثال: 1403/09/02"
              style="direction:ltr;text-align:center;">
            <small style="color:#6b7280;font-size:12px;">
              تاریخ را به‌صورت شمسی با عدد انگلیسی وارد کنید.
            </small>
          </div>

          <div class="field">
            <label>توضیحات خرید</label>
            <textarea name="buy_note" rows="3" placeholder="مثلاً: پرداخت انجام شد / فروشنده تحویل داد / ..."></textarea>
          </div>

          <button class="btn btn-primary" type="submit" style="margin-top:6px;">
            ✔ ثبت خرید
          </button>
        </form>
      <?php endif; ?>
    </section>

    <!-- Tab: Handover -->
    <section id="tab-handover" class="tab-section">
      <h3>🚚 تحویل به سر باربر</h3>
      <?php if($status_raw !== 'purchased'): ?>
        <p style="font-size:13px;color:#6b7280;">
          فقط زمانی امکان ثبت تحویل است که وضعیت «کالا خریداری شده» باشد.
          وضعیت فعلی: <?= $status_label ?>
        </p>
      <?php else: ?>
        <form method="post" action="action.php" class="form-grid">
          <input type="hidden" name="action" value="handover">
          <input type="hidden" name="order_uid" value="<?= safe($uid) ?>">

          <div class="field">
            <label>انتخاب سر باربر</label>
            <select name="head_username" required>
              <option value="">انتخاب کنید...</option>
              <?php foreach($heads as $h): ?>
                <option value="<?= safe($h['username']) ?>">
                  <?= safe($h['full_name'] ?: $h['username']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="field">
            <label>تاریخ تحویل (شمسی)</label>
            <input 
              type="text" 
              name="handover_date" 
              placeholder="مثال: 1403/09/03"
              style="direction:ltr;text-align:center;">
          </div>

          <div class="field">
            <label>توضیحات تحویل</label>
            <textarea name="handover_note" rows="3" placeholder="توضیحات تکمیلی تحویل"></textarea>
          </div>

          <button class="btn btn-primary" type="submit" style="margin-top:6px;">
            ✔ ثبت تحویل به سر باربر
          </button>
        </form>
      <?php endif; ?>
    </section>

    <!-- Tab: Comments -->
    <section id="tab-comments" class="tab-section">
      <h3>📝 یادداشت داخلی سفارش</h3>

      <form method="post" class="form-grid">
        <input type="hidden" name="action" value="add_comment">
        <input type="hidden" name="order_uid" value="<?= safe($uid) ?>">
        <div class="field">
          <label>متن یادداشت</label>
          <textarea name="comment_message" rows="3" placeholder="یادداشت داخلی برای خودت یا تیم (برای مشتری نمایش داده نمی‌شود)" required></textarea>
        </div>
        <button class="btn btn-primary" type="submit" style="margin-top:6px;">
          ✔ ثبت یادداشت
        </button>
      </form>

      <div class="comments-list">
        <?php if(empty($comments)): ?>
          <p style="font-size:13px;color:#6b7280;margin-top:8px;">هنوز یادداشتی برای این سفارش ثبت نشده است.</p>
        <?php else: ?>
          <?php foreach($comments as $c): ?>
            <div class="comment-item">
              <div class="comment-meta">
                <?= safe($c['full_name'] ?: $c['username']) ?> 
                (<?= safe($c['role']) ?>) — <?= safe($c['created_at']) ?>
              </div>
              <div class="comment-message"><?= nl2br(safe($c['message'])) ?></div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </section>

  </div> <!-- /card tabs -->

</div> <!-- /page -->

<script>
// مقدار اولیه وضعیت
document.getElementById('statusSelect').value = <?= json_encode($status_raw, JSON_UNESCAPED_UNICODE) ?>;

// ثبت وضعیت با AJAX (به xhr_update_status.php فعلی)
const statusForm = document.getElementById('statusForm');
statusForm.addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData();
  fd.append('order_uid', <?= json_encode($o['order_uid']) ?>);
  fd.append('status', document.getElementById('statusSelect').value);
  fd.append('note',   document.getElementById('statusNote').value);

  try {
    const res = await fetch('../xhr_update_status.php', {
      method:'POST',
      body:fd
    });
    const j = await res.json();
    if(j.ok){
      alert('وضعیت با موفقیت ثبت شد.');
      location.reload();
    }else{
      alert('خطا: ' + (j.error || 'ثبت وضعیت ناموفق بود'));
    }
  } catch(err){
    alert('خطا در ارتباط با سرور');
  }
});

// تب‌ها (SPA سبک)
const tabButtons  = document.querySelectorAll('.tab-btn');
const tabSections = document.querySelectorAll('.tab-section');

function activateTab(name){
  tabButtons.forEach(btn=>{
    btn.classList.toggle('active', btn.dataset.tab === name);
  });
  tabSections.forEach(sec=>{
    sec.classList.toggle('active', sec.id === 'tab-' + name);
  });
}

tabButtons.forEach(btn=>{
  btn.addEventListener('click', ()=>{
    const name = btn.dataset.tab;
    activateTab(name);
    if (history.replaceState) {
      const url = new URL(window.location.href);
      url.hash = 'tab-' + name;
      history.replaceState(null, '', url.toString());
    }
  });
});

// اگر هَش داشت، تب مربوطه را فعال کن
(function initTabFromHash(){
  const hash = window.location.hash;
  if (!hash) return;
  const name = hash.replace('#tab-','');
  const exists = document.getElementById('tab-'+name);
  if (exists) activateTab(name);
})();
</script>

</body>
</html>
