<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

// فقط مسئول خرید و ادمین
if ($role !== 'buyer_manager' && $role !== 'admin') {
    header("Location: /orders/index.php");
    exit;
}

// مپ وضعیت‌ها
$status_map = [
    'new'               => 'ثبت شده',
    'assigned_to_buyer' => 'در انتظار خرید',
    'purchased'         => 'خرید شده',
    'handover_to_head'  => 'تحویل به سرباربر',
    'out_for_delivery'  => 'در حال ارسال',
    'delivered'         => 'تحویل شده',
    'failed'            => 'عدم تحویل'
];

// فیلتر وضعیت
$filter = trim($_GET['status'] ?? '');
$where_status = '';
if ($filter !== '') {
    $filter_safe = $mysqli->real_escape_string($filter);
    $where_status = " AND shipping_status = '$filter_safe' ";
}

// محدودیت بر اساس کاربر
if ($role === 'admin') {
    $where_user = " buyer_username IS NOT NULL ";
} else {
    $u = $mysqli->real_escape_string($username);
    $where_user = " buyer_username = '$u' ";
}

// کوئری
$sql = "
    SELECT id, order_uid, customer_name, province, total_amount,
           shipping_status, created_at, buyer_username
    FROM orders
    WHERE $where_user
      AND shipping_status IN ('assigned_to_buyer','purchased')
      $where_status
    ORDER BY id DESC
";
$q = $mysqli->query($sql);

// تبدیل میلادی به شمسی
function toJalali($dt){
    if(!$dt) return '-';
    $d = substr($dt,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd) = explode('-',$d);
    $j = gregorian_to_jalali($gy,$gm,$gd,'/');
    return $j;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>سفارش‌های مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link rel="stylesheet" href="/orders/assets/style.css">

<style>
body {
    background:#f3f6fa;
    font-family:'IRANSansWeb',sans-serif;
}
.page-wrap {
    padding:12px;
}
.card {
    background:#fff;
    border-radius:12px;
    padding:14px;
    box-shadow:0 2px 8px rgba(15,23,42,0.06);
    margin-bottom:16px;
}
.card h2 {
    margin:0 0 12px;
    font-size:18px;
    font-weight:700;
    color:#0f172a;
}
.filter-row {
    margin-bottom:10px;
}
.filter-row select {
    width:100%;
    padding:8px 10px;
    border-radius:8px;
    border:1px solid #d1d5db;
    font-size:14px;
}
.table-responsive {
    overflow-x:auto;
}
table {
    width:100%;
    border-collapse:collapse;
    font-size:13px;
}
th,td {
    padding:8px 6px;
    border-bottom:1px solid #e5e7eb;
    text-align:center;
}
th {
    background:#eef2f7;
    font-weight:600;
}
.badge {
    display:inline-block;
    padding:2px 8px;
    border-radius:999px;
    font-size:11px;
}
.badge-wait {background:#fef3c7;color:#92400e;}
.badge-done {background:#dcfce7;color:#166534;}
.btn-view {
    display:inline-block;
    padding:5px 10px;
    border-radius:8px;
    background:#0284c7;
    color:#fff;
    text-decoration:none;
    font-size:12px;
}
@media (max-width:600px){
  th,td{white-space:nowrap;}
}
</style>
</head>
<body>

<div class="page-wrap">
  <div class="card">
    <h2>🧾 سفارش‌های ارجاع‌شده به مسئول خرید</h2>

    <form class="filter-row" method="get">
      <select name="status" onchange="this.form.submit()">
        <option value="">همه وضعیت‌ها</option>
        <option value="assigned_to_buyer" <?=$filter==='assigned_to_buyer'?'selected':''?>>در انتظار خرید</option>
        <option value="purchased"         <?=$filter==='purchased'?'selected':''?>>خرید شده</option>
      </select>
    </form>

    <div class="table-responsive">
      <table>
        <thead>
          <tr>
            <th>کد سفارش</th>
            <th>مشتری</th>
            <th>استان</th>
            <th>مبلغ کل</th>
            <th>وضعیت</th>
            <th>تاریخ ثبت</th>
            <th>عملیات</th>
          </tr>
        </thead>
        <tbody>
          <?php while($row = $q->fetch_assoc()): ?>
            <tr>
              <td><?=htmlspecialchars($row['order_uid'] ?: '-');?></td>
              <td><?=htmlspecialchars($row['customer_name'] ?: '-');?></td>
              <td><?=htmlspecialchars($row['province'] ?: '-');?></td>
              <td><?=number_format((int)$row['total_amount']);?> تومان</td>
              <td>
                <?php
                  $st = $row['shipping_status'];
                  $label = $status_map[$st] ?? $st;
                  $class = ($st==='purchased'?'badge-done':'badge-wait');
                ?>
                <span class="badge <?=$class?>"><?=$label?></span>
              </td>
              <td><?=toJalali($row['created_at']);?></td>
              <td>
                <a class="btn-view" href="/orders/management/buyer_view.php?id=<?=$row['id']?>">مشاهده</a>
              </td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>

</body>
</html>
