<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'logistic' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id = (int)($_GET['id'] ?? 0);
if ($id < 1) exit('bad id');

// فقط اگر این سر باربر مسئول است یا ادمین
if ($role === 'admin') {
    $stmt = $mysqli->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
    $stmt->bind_param("i",$id);
} else {
    $stmt = $mysqli->prepare("SELECT * FROM orders WHERE id=? AND head_carrier_username=? LIMIT 1");
    $stmt->bind_param("is",$id,$username);
}
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
if (!$order) exit('سفارش یافت نشد یا مربوط به شما نیست.');

$status_map = [
    'handover_to_head'  => 'تحویل از مسئول خرید',
    'out_for_delivery'  => 'در حال ارسال',
    'delivered'         => 'تحویل شده',
    'failed'            => 'عدم تحویل'
];

function toJalali($dt){
    if(!$dt) return '-';
    $d = substr($dt,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd) = explode('-',$d);
    return gregorian_to_jalali($gy,$gm,$gd,'/');
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>جزئیات سفارش — لجستیک</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link rel="stylesheet" href="/orders/assets/style.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-date/dist/persian-date.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-datepicker/dist/persian-datepicker.min.js"></script>

<style>
body{background:#f3f6fa;font-family:'IRANSansWeb',sans-serif;}
.page{padding:12px;}
.card{
  background:#fff;border-radius:12px;padding:14px;margin-bottom:16px;
  box-shadow:0 2px 8px rgba(15,23,42,0.06);
}
.card h2{margin:0 0 12px;font-size:18px;font-weight:700;}
.info-box{
  background:#f8fafc;border-radius:8px;padding:10px;
  border-right:4px solid #0ea5e9;margin-bottom:10px;
}
.row{margin-bottom:6px;font-size:14px;}
.row label{font-weight:600;}
input,textarea,select{
  width:100%;padding:8px 10px;border-radius:8px;border:1px solid #d1d5db;
  font-size:14px;margin-top:4px;
}
.btn{
  width:100%;padding:10px;border-radius:8px;border:none;
  font-size:15px;margin-top:10px;color:#fff;
}
.btn-blue{background:#0284c7;}
.btn-green{background:#16a34a;}
.btn-red{background:#dc2626;}
</style>
</head>
<body>
<div class="page">

  <div class="card">
    <h2>📦 اطلاعات سفارش</h2>
    <div class="info-box">
      <div class="row"><label>کد سفارش:</label> <?=htmlspecialchars($order['order_uid'] ?: '-')?></div>
      <div class="row"><label>مشتری:</label> <?=htmlspecialchars($order['customer_name'] ?: '-')?></div>
      <div class="row"><label>موبایل:</label> <?=htmlspecialchars($order['mobile1'] ?: '-')?></div>
      <div class="row"><label>استان:</label> <?=htmlspecialchars($order['province'] ?: '-')?></div>
      <div class="row"><label>آدرس:</label> <?=htmlspecialchars($order['address'] ?: '-')?></div>
      <div class="row"><label>وضعیت فعلی:</label> <?=$status_map[$order['shipping_status']] ?? $order['shipping_status']?></div>
      <div class="row"><label>یادداشت وضعیت:</label> <?=htmlspecialchars($order['status_note'] ?: '—')?></div>
      <div class="row"><label>تاریخ ثبت:</label> <?=toJalali(substr($order['created_at'],0,10))?></div>
    </div>
  </div>

  <?php if($order['shipping_status']==='handover_to_head'): ?>
  <div class="card">
    <h2>🚚 ثبت تحویل به راننده / خروج</h2>
    <form action="logistic_save_send.php" method="post">
      <input type="hidden" name="id" value="<?=$order['id']?>">

      <label>نام راننده</label>
      <input type="text" name="driver_name" required>

      <label>شماره راننده</label>
      <input type="text" name="driver_phone" required>

      <label>هزینه تقریبی بار (تومان)</label>
      <input type="number" name="shipping_cost" min="0">

      <label>تاریخ خروج (شمسی)</label>
      <input type="text" id="send_date" name="send_date" placeholder="مثال: 1403/01/22">

      <label>توضیحات</label>
      <textarea name="send_note" rows="3"></textarea>

      <button class="btn btn-blue">ثبت ارسال و تغییر وضعیت به «در حال ارسال»</button>
    </form>
  </div>
  <?php endif; ?>

  <?php if($order['shipping_status']==='out_for_delivery'): ?>
  <div class="card">
    <h2>📬 ثبت تحویل نهایی / عدم تحویل</h2>

    <form action="logistic_save_deliver.php" method="post">
      <input type="hidden" name="id" value="<?=$order['id']?>">
      <label>تاریخ تحویل (شمسی)</label>
      <input type="text" id="deliver_date" name="deliver_date" required placeholder="مثال: 1403/01/23">
      <label>توضیحات</label>
      <textarea name="deliver_note" rows="3"></textarea>
      <button class="btn btn-green">تحویل شد</button>
    </form>

    <form action="logistic_save_failed.php" method="post">
      <input type="hidden" name="id" value="<?=$order['id']?>">
      <label>دلیل عدم تحویل</label>
      <textarea name="failed_reason" rows="3" required></textarea>
      <button class="btn btn-red">عدم تحویل</button>
    </form>
  </div>
  <?php endif; ?>

</div>

<script>
$("#send_date").persianDatepicker({
  format:"YYYY/MM/DD",
  initialValue:false
});
$("#deliver_date").persianDatepicker({
  format:"YYYY/MM/DD",
  initialValue:false
});
</script>

</body>
</html>
