<?php
require __DIR__.'/../../includes/auth.php';
require __DIR__.'/../../includes/config.php';
require __DIR__.'/../../includes/db_connect.php';

if(($_SESSION['role'] ?? '') !== 'admin'){
    http_response_code(403);
    exit('دسترسي مجاز نيست');
}

$id = intval($_GET['id'] ?? 0);
if($id <= 0){
    exit("شناسه معتبر نيست");
}

$stmt = $mysqli->prepare("SELECT id, username, role FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$u = $stmt->get_result()->fetch_assoc();

if(!$u){
    exit("کاربر يافت نشد");
}

// جلوگيري از حذف مدير
if($u['role'] === 'admin'){
    exit("خطا: نمي‌توان مدير را حذف کرد");
}

// جلوگيري از حذف خود ادمين
if($u['username'] === ($_SESSION['username'] ?? '')){
    exit("نمي‌توانيد حساب خود را حذف کنيد");
}

$msg = "";

// پردازش حذف (POST امن)
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    
    $stmt2 = $mysqli->prepare("DELETE FROM users WHERE id=? LIMIT 1");
    $stmt2->bind_param("i", $id);

    if($stmt2->execute()){
        header("Location: user.php?deleted");
        exit;
    } else {
        $msg = "خطا در حذف: ".$stmt2->error;
    }
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>حذف کاربر</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="user.css">

<style>
.delete-box{
    background:white;
    padding:20px;
    border-radius:16px;
    box-shadow:0 6px 18px rgba(0,0,0,0.08);
    max-width:430px;
    margin:50px auto;
    text-align:center;
}
.warn{
    color:#b91c1c;
    font-weight:800;
    font-size:17px;
    margin-bottom:14px;
}
.danger-btn{
    background:#ef4444;
    color:white;
    padding:12px 22px;
    border-radius:12px;
    border:none;
    font-weight:700;
    cursor:pointer;
    margin-top:10px;
}
.danger-btn:hover{
    background:#dc2626;
}
.back-link{
    display:inline-block;
    margin-top:20px;
    text-decoration:none;
    color:#0369a1;
    font-weight:700;
}
</style>

</head>

<body>

<?php require __DIR__.'/../../includes/header.php'; ?>

<div class="saas-container">

    <div class="delete-box">

        <div class="warn">آيا از حذف کاربر مطمئن هستيد؟</div>

        <p><strong>نام کاربري:</strong> <?= htmlspecialchars($u['username']) ?></p>
        <p><strong>نقش:</strong> <?= htmlspecialchars($u['role']) ?></p>

        <?php if($msg): ?>
            <div class="err-msg"><?= htmlspecialchars($msg) ?></div>
        <?php endif; ?>

        <form method="post">
            <button class="danger-btn">تاييد حذف</button>
        </form>

        <a href="user.php" class="back-link">بازگشت</a>

    </div>

</div>

</body>
</html>
