<?php
require __DIR__.'/../../includes/auth.php';
require __DIR__.'/../../includes/config.php';
require __DIR__.'/../../includes/db_connect.php';
require __DIR__.'/../../includes/jdf.php';

if(($_SESSION['role'] ?? '') !== 'admin'){
    http_response_code(403);
    exit('دسترسي مجاز نيست');
}

/* ============================
   دريافت کاربر
============================ */
$id = intval($_GET['id'] ?? 0);
if($id <= 0){
    exit("کاربر يافت نشد");
}

$stmt = $mysqli->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$u = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$u){
    exit("کاربر يافت نشد");
}

$uploadDir  = __DIR__."/../../uploads/logistic/";
$uploadBase = "/orders/uploads/logistic/";
$msg = "";

/* ============================
   ذخيره اطلاعات
============================ */
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // ورودي‌ها
    $full_name   = trim($_POST['full_name'] ?? '');
    $username    = trim($_POST['username'] ?? '');
    $mobile      = trim($_POST['mobile'] ?? '');
    $national_id = trim($_POST['national_id'] ?? '');

    $birth_raw = trim($_POST['birthdate'] ?? '');
    $birthdate = ($birth_raw === "") ? NULL : $birth_raw;

    $address     = trim($_POST['address'] ?? '');
    $vehicle     = trim($_POST['vehicle'] ?? '');
    $plate       = trim($_POST['plate'] ?? '');
    $role        = trim($_POST['role'] ?? '');
    $approved    = intval($_POST['approved'] ?? 0);
    $password    = trim($_POST['password'] ?? '');

    /* ------------------------------
       تابع آپلود امن
    ------------------------------ */
    function uploadFileSafe($key, $dir){
        if(!isset($_FILES[$key]) || $_FILES[$key]['error'] !== 0) return "";
        $ext = strtolower(pathinfo($_FILES[$key]['name'], PATHINFO_EXTENSION));
        $name = uniqid().".".$ext;
        move_uploaded_file($_FILES[$key]['tmp_name'], $dir.$name);
        return $name;
    }

    $face = uploadFileSafe("photo_face", $uploadDir);
    $nid  = uploadFileSafe("photo_nid",  $uploadDir);
    $car  = uploadFileSafe("photo_car",  $uploadDir);

    /* ------------------------------------
       1) آپدیت فیلدهای عادی (بدون عکس/رمز)
    ------------------------------------ */
    $stmt_u = $mysqli->prepare("
        UPDATE users SET
            full_name=?,
            username=?,
            mobile=?,
            national_id=?,
            birthdate=?,
            address=?,
            vehicle=?,
            plate=?,
            role=?,
            is_approved=?
        WHERE id=?
        LIMIT 1
    ");

    $stmt_u->bind_param(
        "sssssssssis",
        $full_name,
        $username,
        $mobile,
        $national_id,
        $birthdate,
        $address,
        $vehicle,
        $plate,
        $role,
        $approved,
        $id
    );

    if(!$stmt_u->execute()){
        $msg = "خطا در ذخيره: ".$stmt_u->error;
    }
    $stmt_u->close();

    /* ------------------------------------
       2) اگر رمز جدید ارسال شده بود
    ------------------------------------ */
    if($password !== ""){
        $hash = password_hash($password, PASSWORD_BCRYPT);
        $stmt_p = $mysqli->prepare("UPDATE users SET password_hash=? WHERE id=? LIMIT 1");
        $stmt_p->bind_param("si", $hash, $id);
        $stmt_p->execute();
        $stmt_p->close();
    }

    /* ------------------------------------
       3) آپدیت عکس‌ها
    ------------------------------------ */
    if($face){
        $stmt_f = $mysqli->prepare("UPDATE users SET photo_face=? WHERE id=? LIMIT 1");
        $stmt_f->bind_param("si", $face, $id);
        $stmt_f->execute();
        $stmt_f->close();
    }

    if($nid){
        $stmt_f = $mysqli->prepare("UPDATE users SET photo_nid=? WHERE id=? LIMIT 1");
        $stmt_f->bind_param("si", $nid, $id);
        $stmt_f->execute();
        $stmt_f->close();
    }

    if($car){
        $stmt_f = $mysqli->prepare("UPDATE users SET photo_car=? WHERE id=? LIMIT 1");
        $stmt_f->bind_param("si", $car, $id);
        $stmt_f->execute();
        $stmt_f->close();
    }

    header("Location: user_edit.php?id=".$id."&ok");
    exit;
}

/* ============================
   تابع تاريخ شمسي
============================ */
function toJ($d){
    if(!$d || !preg_match('/^\d+/', $d)) return '-';
    list($y,$m,$d2) = explode('-', substr($d,0,10));
    return gregorian_to_jalali($y,$m,$d2,'/');
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>ويرايش کاربر</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="user.css">

<style>
.current-photo{
    width:130px;
    border-radius:10px;
    margin-top:6px;
    box-shadow:0 4px 12px rgba(0,0,0,.12);
}
.ok-msg{
    background:#d1fae5;
    color:#065f46;
    padding:10px;
    border-radius:10px;
    margin-bottom:12px;
}
.err-msg{
    background:#fee2e2;
    color:#b91c1c;
    padding:10px;
    border-radius:10px;
    margin-bottom:12px;
}
</style>

</head>

<body>

<?php require __DIR__.'/../../includes/header.php'; ?>

<div class="saas-container">

    <a href="user.php" class="saas-btn" style="margin-bottom:18px;">بازگشت</a>

    <h1 class="saas-title">ويرايش کاربر</h1>

    <?php if(isset($_GET['ok'])): ?>
        <div class="ok-msg">تغييرات با موفقيت ذخيره شد</div>
    <?php endif; ?>

    <?php if($msg): ?>
        <div class="err-msg"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>


    <form method="post" enctype="multipart/form-data">

        <!-- ===== مشخصات فردی ===== -->
        <div class="saas-card">
            <div class="saas-card-title">اطلاعات فردي</div>
            <div class="saas-card-content">

                <div class="saas-form-group">
                    <label>نام</label>
                    <input type="text" name="full_name" value="<?= htmlspecialchars($u['full_name'] ?? '') ?>" required>
                </div>

                <div class="saas-form-group">
                    <label>نام کاربري</label>
                    <input type="text" name="username" value="<?= htmlspecialchars($u['username'] ?? '') ?>" required>
                </div>

                <div class="saas-form-group">
                    <label>موبايل</label>
                    <input type="text" name="mobile" value="<?= htmlspecialchars($u['mobile'] ?? '') ?>" required>
                </div>

                <div class="saas-form-group">
                    <label>کد ملي</label>
                    <input type="text" name="national_id" value="<?= htmlspecialchars($u['national_id'] ?? '') ?>">
                </div>

                <div class="saas-form-group">
                    <label>تاريخ تولد</label>
                    <input type="text" name="birthdate" value="<?= htmlspecialchars($u['birthdate'] ?? '') ?>">
                </div>

                <div class="saas-form-group">
                    <label>آدرس</label>
                    <textarea name="address" rows="3"><?= htmlspecialchars($u['address'] ?? '') ?></textarea>
                </div>

            </div>
        </div>

        <!-- ===== نقش و وضعیت ===== -->
        <div class="saas-card">
            <div class="saas-card-title">نقش و وضعيت</div>
            <div class="saas-card-content">

                <div class="saas-form-group">
                    <label>نقش</label>
                    <select name="role">
                        <option value="seller" <?= ($u['role'] ?? '')=='seller'?'selected':'' ?>>فروشنده</option>
                        <option value="buyer" <?= ($u['role'] ?? '')=='buyer'?'selected':'' ?>>مسئول خريد</option>
                        <option value="logistic" <?= ($u['role'] ?? '')=='logistic'?'selected':'' ?>>لجستيک</option>
                        <option value="head_carrier" <?= ($u['role'] ?? '')=='head_carrier'?'selected':'' ?>>سرکارگر</option>
                        <option value="support" <?= ($u['role'] ?? '')=='support'?'selected':'' ?>>پشتيباني</option>
                        <option value="admin" <?= ($u['role'] ?? '')=='admin'?'selected':'' ?>>مدير</option>
                    </select>
                </div>

                <div class="saas-form-group">
                    <label>وضعيت</label>
                    <select name="approved">
                        <option value="0" <?= ($u['is_approved'] ?? 0)==0?'selected':'' ?>>منتظر تاييد</option>
                        <option value="1" <?= ($u['is_approved'] ?? 0)==1?'selected':'' ?>>تاييد شده</option>
                        <option value="2" <?= ($u['is_approved'] ?? 0)==2?'selected':'' ?>>رد شده</option>
                    </select>
                </div>

                <div class="saas-form-group">
                    <label>رمز جديد (اختياري)</label>
                    <input type="password" name="password" placeholder="اگر خالي باشد تغيير نمي‌کند">
                </div>

            </div>
        </div>

        <!-- ===== وسیله نقلیه ===== -->
        <div class="saas-card">
            <div class="saas-card-title">اطلاعات وسيله نقليه</div>
            <div class="saas-card-content">

                <div class="saas-form-group">
                    <label>نوع وسيله</label>
                    <select name="vehicle">
                        <option value="motorcycle" <?= ($u['vehicle'] ?? '')=='motorcycle'?'selected':'' ?>>موتورسیکلت</option>
                        <option value="car" <?= ($u['vehicle'] ?? '')=='car'?'selected':'' ?>>خودرو</option>
                        <option value="van" <?= ($u['vehicle'] ?? '')=='van'?'selected':'' ?>>وانت</option>
                    </select>
                </div>

                <div class="saas-form-group">
                    <label>پلاک</label>
                    <input type="text" name="plate" value="<?= htmlspecialchars($u['plate'] ?? '') ?>">
                </div>

            </div>
        </div>

        <!-- ===== مدارک ===== -->
        <div class="saas-card">
            <div class="saas-card-title">عکس‌ها و مدارک</div>
            <div class="saas-card-content">

                <div class="saas-form-group">
                    <label>عکس چهره</label>
                    <?php if(!empty($u['photo_face'])): ?>
                        <img src="<?= $uploadBase.$u['photo_face'] ?>" class="current-photo">
                    <?php endif; ?>
                    <input type="file" name="photo_face">
                </div>

                <div class="saas-form-group">
                    <label>کارت ملي</label>
                    <?php if(!empty($u['photo_nid'])): ?>
                        <img src="<?= $uploadBase.$u['photo_nid'] ?>" class="current-photo">
                    <?php endif; ?>
                    <input type="file" name="photo_nid">
                </div>

                <div class="saas-form-group">
                    <label>مدرک خودرو</label>
                    <?php if(!empty($u['photo_car'])): ?>
                        <img src="<?= $uploadBase.$u['photo_car'] ?>" class="current-photo">
                    <?php endif; ?>
                    <input type="file" name="photo_car">
                </div>

            </div>
        </div>

        <button class="saas-btn">ذخيره تغييرات</button>

    </form>

</div>

</body>
</html>
