<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
header('Content-Type: application/json; charset=utf-8');

if(($_SESSION['role'] ?? '') !== 'admin'){
  echo json_encode(['ok'=>false,'msg'=>'دسترسی غیرمجاز']);
  exit;
}

try {
  $q = $mysqli->query("
    SELECT username,
      COALESCE((SELECT SUM(total_deposit) FROM orders WHERE username=u.username),0) AS total_deposit,
      COALESCE((SELECT SUM(w.amount)
        FROM withdrawals w
        JOIN orders o ON o.id=w.order_id
        WHERE o.username=u.username),0) AS total_withdraw
    FROM users u
    WHERE role='seller'
  ");

  while($r = $q->fetch_assoc()){
    $remain = (int)$r['total_deposit'] - (int)$r['total_withdraw'];
    $u = $mysqli->prepare("UPDATE users SET balance=? WHERE username=?");
    $u->bind_param("is",$remain,$r['username']);
    $u->execute();
    $u->close();
  }

  echo json_encode(['ok'=>true,'msg'=>'✅ مانده‌ها با موفقیت به‌روزرسانی شدند']);
} catch(Throwable $e){
  echo json_encode(['ok'=>false,'msg'=>'❌ خطا: '.$e->getMessage()]);
}
