<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';
require_once __DIR__.'/includes/jdf.php';

function nf($n){ return number_format((float)$n, 0, '.', ','); }

// ===============================
// 1️⃣ دریافت شناسه امن از URL
// ===============================
$uid = trim($_GET['id'] ?? '');
if ($uid === '') {
    http_response_code(400);
    exit('شناسه سفارش معتبر نیست.');
}

// ===============================
// 2️⃣ واکشی سفارش بر اساس order_uid
// ===============================
$stmt = $mysqli->prepare('SELECT * FROM orders WHERE order_uid=? LIMIT 1');
$stmt->bind_param('s', $uid);
$stmt->execute();
$o = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$o) {
    http_response_code(404);
    ?>
    <!doctype html><html lang="fa" dir="rtl"><meta charset="utf-8">
    <title>سفارش یافت نشد</title>
    <link rel="stylesheet" href="https://salambaba.co/orders/assets/view.css">
    <body><div class="container">
    <section class="card" style="margin-top:2rem">
      <h3>سفارش یافت نشد</h3>
      <p>هیچ سفارشی با این شناسه (<?=htmlspecialchars($uid)?>) وجود ندارد.</p>
      <a class="btn ghost" href="orders.php">بازگشت</a>
    </section></div></body></html>
    <?php
    exit;
}

// ===============================
// 3️⃣ واکشی اقلام و برداشت‌ها
// ===============================
$order_id = (int)$o['id'];

$items = $mysqli->query("SELECT * FROM order_items WHERE order_id={$order_id} ORDER BY id ASC");
$wds   = $mysqli->query("SELECT * FROM withdrawals WHERE order_id={$order_id} ORDER BY id DESC");

// ===============================
// 4️⃣ مقادیر نمایشی
// ===============================
function safe($x){ return htmlspecialchars($x ?? '', ENT_QUOTES, 'UTF-8'); }
function toJalaliEn($d){
  if(!$d || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
  list($gy,$gm,$gd)=explode('-',$d);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j,['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

$track_link = rtrim(BASE_URL, '/').'/track.php?code='.rawurlencode($o['tracking_code']);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>فاکتور <?= safe($o['invoice_no']) ?> | سلام‌بابا</title>
<link rel="stylesheet" href="assets/view.css">
<body>
<div class="container">

<header class="brand">
  <div class="logo">سلام‌بابا</div>
  <div class="userbox">
    <a class="btn ghost" href="orders.php">بازگشت</a>
    <a class="btn danger" href="logout.php">خروج</a>
  </div>
</header>

<!-- ===============================
     اطلاعات اصلی سفارش
================================== -->
<section class="card order-info">
  <h3>جزئیات سفارش</h3>
  <div class="info-grid">
    <div class="info-item"><span class="label">مشتری:</span><span class="value"><?= safe($o['customer_name']) ?></span></div>
    <div class="info-item"><span class="label">فروشنده:</span><span class="value"><?= safe($o['seller_name']) ?></span></div>
    <div class="info-item"><span class="label">تاریخ:</span><span class="value"><?= toJalaliEn($o['purchase_date']) ?></span></div>
    <div class="info-item"><span class="label">آدرس:</span><span class="value"><?= safe($o['address']) ?></span></div>
    <?php
$wmap = [
  'none'   => 'بدون گارانتی',
  'gold'   => 'طلایی',
  'silver' => 'نقره‌ای',
  'bronze' => 'برنزی',
  ''       => 'بدون گارانتی'
];
$warranty_label = $wmap[strtolower(trim($o['warranty'] ?? ''))] ?? safe($o['warranty']);
?>
<div class="info-item">
  <span class="label">گارانتی:</span>
  <span class="value"><?= $warranty_label ?></span>
</div>

    <?php if(!empty($o['notes'])): ?>
      <div class="info-item wide"><span class="label">توضیحات:</span><span class="value"><?= nl2br(safe($o['notes'])) ?></span></div>
    <?php endif; ?>
  </div>

  <div class="note track-box">
    <span class="label">کد رهگیری سفارش:</span>
    <span class="code"><?= safe($o['tracking_code']) ?></span>
    <a href="<?= $track_link ?>" target="_blank" class="btn small ghost">مشاهده وضعیت</a>
  </div>
</section>

<!-- ===============================
     جدول اقلام
================================== -->
<section class="card">
  <h3>اقلام سفارش</h3>
  <table class="table">
    <thead><tr><th>#</th><th>مدل</th><th>قیمت</th><th>بیعانه</th><th>COD</th><th>مانده</th></tr></thead>
    <tbody>
    <?php $i=1; while($it=$items->fetch_assoc()): ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= safe($it['model']) ?></td>
        <td><?= nf($it['price']) ?></td>
        <td><?= nf($it['deposit']) ?></td>
        <td><?= nf($it['cod']) ?></td>
        <td><?= nf($it['remaining']) ?></td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
  <div class="totals">
    <div>جمع فروش: <b><?= nf($o['total_amount']) ?></b></div>
    <div>بیعانه: <b><?= nf($o['total_deposit']) ?></b></div>
    <div>COD: <b><?= nf($o['total_cod']) ?></b></div>
    <div>مانده: <b><?= nf($o['total_remaining']) ?></b></div>
  </div>
</section>

<!-- ===============================
     برداشت‌ها
================================== -->
<section class="card">
  <h3>برداشت‌ها</h3>
  <form id="wdForm" class="grid-3">
    <label class="field"><span>مبلغ برداشت</span><input name="amount" type="number" min="0" required></label>
    <label class="field"><span>توضیح</span><input name="note"></label>
    <div class="field">
      <span>&nbsp;</span>
      <button class="btn primary">ثبت برداشت</button>
      <a class="btn ghost" href="invoice.php?id=<?= safe($o['order_uid']) ?>">PDF</a>
      <a class="btn ghost" href="invoice_print.php?id=<?= safe($o['order_uid']) ?>">پرینت</a>
    </div>
  </form>

  <table class="table">
    <thead><tr><th>#</th><th>مبلغ</th><th>توضیح</th><th>تاریخ</th></tr></thead>
    <tbody id="wdTableBody">
    <?php while($w=$wds->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$w['id'] ?></td>
        <td><?= nf($w['amount']) ?></td>
        <td><?= safe($w['note']) ?></td>
        <td><?= safe($w['created_at']) ?></td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
</section>

<!-- ===============================
     وضعیت سفارش
================================== -->
<?php
$status_map = [
  'pending'    => '🕓 در حال آماده‌سازی',
  'processing' => '🔧 در حال پردازش',
  'shipped'    => '🚚 ارسال شد',
  'delivered'  => '✅ تحویل داده شد',
  'cancelled'  => '❌ لغو شد'
];
$status_label = $status_map[$o['status']] ?? 'نامشخص';
?>
<section class="card">
  <h3>وضعیت سفارش</h3>
  <p style="margin:0 0 1rem;font-weight:600;">
    وضعیت فعلی: <span style="color:#0369a1;"><?= $status_label ?></span>
  </p>
  <form id="statusForm" class="grid-3">
    <label class="field">
      <span>وضعیت</span>
      <select id="statusSelect" name="status">
        <option value="pending">در حال آماده‌سازی</option>
        <option value="shipped">ارسال شد</option>
        <option value="delivered">تحویل داده شد</option>
        <option value="cancelled">لغو شد</option>
      </select>
    </label>
    <label class="field">
      <span>یادداشت</span>
      <input id="statusNote" name="note" value="<?= safe($o['status_note']) ?>">
    </label>
    <div class="field">
      <span>&nbsp;</span>
      <button class="btn primary">ثبت وضعیت</button>
      <a class="btn ghost" href="<?= $track_link ?>" target="_blank">صفحه رهگیری</a>
    </div>
  </form>
</section>

<script>
document.getElementById('statusSelect').value = <?= json_encode($o['status'], JSON_UNESCAPED_UNICODE) ?>;

document.getElementById('wdForm').addEventListener('submit', async e=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  fd.append('order_uid', '<?= safe($o['order_uid']) ?>');
  const r = await fetch('xhr_add_withdrawal.php', {method:'POST', body:fd});
  const j = await r.json();
  if(j.ok) location.reload(); else alert(j.error||'خطا');
});

document.getElementById('statusForm').addEventListener('submit', async e=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  fd.append('order_uid', '<?= safe($o['order_uid']) ?>');
  const r = await fetch('xhr_update_status.php', {method:'POST', body:fd});
  const j = await r.json();
  if(j.ok) location.reload(); else alert(j.error||'خطا');
});
</script>

</div>
</body>
</html>
