<?php
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';
session_start();

$user = $_SESSION['username'];
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

$conditions = [];

if(!$is_admin)
  $conditions[] = "username='".$mysqli->real_escape_string($user)."'";

if(!empty($_GET['search'])){
  $s = $mysqli->real_escape_string($_GET['search']);
  $conditions[] = "(customer_name LIKE '%$s%' OR seller_name LIKE '%$s%' OR id LIKE '%$s%')";
}

if(!empty($_GET['seller'])){
  $seller = $mysqli->real_escape_string($_GET['seller']);
  $conditions[] = "seller_name='$seller'";
}

if(!empty($_GET['month'])){
  $month = (int)$_GET['month'];
  $conditions[] = "MONTH(purchase_date)=$month";
}

if(!empty($_GET['year'])){
  $year = (int)$_GET['year'];
  $conditions[] = "YEAR(purchase_date)=$year";
}

$where = $conditions ? implode(' AND ', $conditions) : '1';
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

function nf($n){return number_format((int)$n,0,'.',',');}
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  $en = strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
  return $en;
}

ob_start();
if($q->num_rows==0){
  echo '<tr><td colspan="9" style="text-align:center;color:#777;">هیچ فاکتوری پیدا نشد</td></tr>';
}else{
  $i=1;
  while($r=$q->fetch_assoc()){
    echo "<tr>
      <td>{$i}</td>
      <td>".htmlspecialchars($r['customer_name'])."</td>
      <td>".htmlspecialchars($r['seller_name'])."</td>
      <td>".toJalaliEn($r['purchase_date'])."</td>
      <td>".nf($r['total_amount'])."</td>
      <td>".nf($r['total_deposit'])."</td>
      <td>".nf($r['total_remaining'])."</td>
      <td>";

    $s = $r['status'];
    $map = [
      'pending' => '🕓 در انتظار',
      'processing' => '🔧 آماده‌سازی',
      'shipped' => '🚚 ارسال شد',
      'delivered' => '✅ تحویل داده شد',
      'cancelled' => '❌ لغو شد'
    ];
    echo ($map[$s] ?? 'نامشخص')."</td>";

    echo "<td>
      <div class='action-menu'>
        <button class='action-btn' aria-label='منوی عملیات'>⋯</button>
        <div class='action-list'>
          <a href='view.php?id={$r['id']}' class='btn small primary'>👁 مشاهده</a>
          <a href='edit.php?id={$r['id']}' class='btn small ghost'>✏️ ویرایش</a>
          <a href='invoice.php?id={$r['id']}' class='btn small ghost'>🧾 PDF</a>
          <a href='invoice_print.php?id={$r['id']}' class='btn small ghost'>🖨 پرینت</a>";
    if($is_admin){
      echo "<button class='btn small danger' onclick='deleteOrder({$r['id']})'>🗑 حذف</button>";
    }
    echo "</div></div></td></tr>";
    $i++;
  }
}
$html = ob_get_clean();
echo json_encode(['html' => $html]);
