<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';
require __DIR__ . '/../includes/header.php';


function nf($n){
    return number_format((int)($n ?? 0), 0, '.', ',');
}
function e($v){
    return htmlspecialchars((string)($v ?? ''), ENT_QUOTES, 'UTF-8');
}
if (!function_exists('toJalaliEn')) {
    function toJalaliEn($date){
        if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
        $date = substr($date,0,10);
        list($gy,$gm,$gd) = explode('-',$date);
        if(!function_exists('gregorian_to_jalali')) return $date;
        $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
        return strtr($j, [
            '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
            '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
        ]);
    }
}

$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

$requested_user = trim($_GET['username'] ?? '');

// اگر یوزرنیم داده نشده، برای فروشنده خودش
if ($requested_user === '') {
    $requested_user = $login_user;
}

// اگر فروشنده است، فقط اجازه دیدن خودش را دارد
if ($role !== 'admin' && $requested_user !== $login_user) {
    http_response_code(403);
    echo "<div style='padding:20px;color:#b91c1c;font-weight:bold;'>دسترسی غیرمجاز</div>";
    exit;
}

// اگر مدیر است و هنوز یوزرنیم فروشنده واقعی نیست، بعداً از دراپ‌داون انتخاب می‌کند
if ($role === 'admin' && $requested_user === 'admin') {
    $requested_user = '';
}

// گرفتن اطلاعات فروشنده (فقط role=seller)
$seller = null;
if ($requested_user !== '') {
    $stmt = $mysqli->prepare("
        SELECT username, full_name
        FROM users
        WHERE username = ?
          AND role = 'seller'
        LIMIT 1
    ");
    $stmt->bind_param('s', $requested_user);
    $stmt->execute();
    $res  = $stmt->get_result();
    $seller = $res->fetch_assoc();
    $stmt->close();
}

// لیست فروشنده‌ها برای دراپ‌داون مدیر
$seller_list = [];
if ($role === 'admin') {
    $rs = $mysqli->query("SELECT username, full_name FROM users WHERE role='seller' ORDER BY full_name, username");
    while($row = $rs->fetch_assoc()){
        $seller_list[] = $row;
    }
}

// اگر مدیر است و هنوز فروشنده انتخاب نشده
if ($role === 'admin' && !$seller && $requested_user !== '') {
    echo "<div style='padding:20px;color:#b91c1c;font-weight:bold;'>فروشنده پیدا نشد.</div>";
}

// ------------------ فیلترها ------------------
$filterStatus = trim($_GET['shipping_status'] ?? '');
$search       = trim($_GET['q'] ?? '');
$monthJ       = trim($_GET['month'] ?? ''); // مثال: 1404/08

$applyMonth = false;
$monthStart = null;
$monthEnd   = null;

if ($monthJ !== '' && preg_match('/^\d{4}\/\d{2}$/',$monthJ)) {
    $applyMonth = true;
    list($jy,$jm) = explode('/',$monthJ);
    list($gy,$gm,$gd) = jalali_to_gregorian((int)$jy,(int)$jm,1);
    $monthStart = sprintf('%04d-%02d-01 00:00:00',$gy,$gm);
    $monthEnd   = date('Y-m-t 23:59:59',strtotime($monthStart));
}

// اگر فروشنده مشخص باشد، آمار و لیست ها را می‌سازیم
$total_deposit   = 0;
$total_amount    = 0;
$total_cod       = 0;
$total_remaining = 0;
$total_withdraw  = 0;
$current_balance = 0;
$orders          = [];
$withdraws       = [];

if ($seller) {

    // جمع بیعانه‌ها و مقادیر کلی از orders (بدون فیلتر ماه)
    $stmt = $mysqli->prepare("
        SELECT 
            COALESCE(SUM(total_deposit),0)   AS total_deposit,
            COALESCE(SUM(total_amount),0)    AS total_amount,
            COALESCE(SUM(total_cod),0)       AS total_cod,
            COALESCE(SUM(total_remaining),0) AS total_remaining
        FROM orders
        WHERE username = ?
    ");
    $stmt->bind_param('s', $requested_user);
    $stmt->execute();
    $res = $stmt->get_result();
    $agg_orders = $res->fetch_assoc();
    $stmt->close();

    $total_deposit   = (int)($agg_orders['total_deposit'] ?? 0);
    $total_amount    = (int)($agg_orders['total_amount'] ?? 0);
    $total_cod       = (int)($agg_orders['total_cod'] ?? 0);
    $total_remaining = (int)($agg_orders['total_remaining'] ?? 0);

    // جمع برداشت‌ها بر اساس orders.username (نه withdrawals.username)
    $stmt = $mysqli->prepare("
        SELECT COALESCE(SUM(w.amount),0) AS total_withdraw
        FROM withdrawals w
        JOIN orders o ON o.id = w.order_id
        WHERE o.username = ?
    ");
    $stmt->bind_param('s', $requested_user);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    $stmt->close();

    $total_withdraw = (int)($row['total_withdraw'] ?? 0);
    $current_balance = $total_deposit - $total_withdraw;

    // ------------------ لیست فاکتورها با فیلتر ------------------
    $sql = "
        SELECT 
            id,
            order_uid,
            invoice_no,
            customer_name,
            purchase_date,
            created_at,
            total_amount,
            total_deposit,
            total_cod,
            total_remaining,
            shipping_status
        FROM orders
        WHERE username = ?
    ";

    $types  = 's';
    $params = [$requested_user];

    if ($filterStatus !== '') {
        $sql .= " AND shipping_status = ? ";
        $types  .= 's';
        $params[] = $filterStatus;
    }

    if ($search !== '') {
        $sql .= " AND (invoice_no LIKE CONCAT('%',?,'%')
                    OR customer_name LIKE CONCAT('%',?,'%')
                    OR order_uid LIKE CONCAT('%',?,'%')) ";
        $types  .= 'sss';
        $params[] = $search;
        $params[] = $search;
        $params[] = $search;
    }

    if ($applyMonth) {
        $sql .= " AND created_at BETWEEN ? AND ? ";
        $types  .= 'ss';
        $params[] = $monthStart;
        $params[] = $monthEnd;
    }

    $sql .= " ORDER BY id DESC";

    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $orders_res = $stmt->get_result();
    $orders = $orders_res->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // ------------------ لیست برداشت‌ها (با join روی orders) ------------------
    $wdSql = "
        SELECT 
          w.id, w.amount, w.note, w.created_at,
          o.order_uid, o.invoice_no
        FROM withdrawals w
        JOIN orders o ON o.id = w.order_id
        WHERE o.username = ?
    ";
    $wdTypes  = 's';
    $wdParams = [$requested_user];

    if ($applyMonth) {
        $wdSql .= " AND w.created_at BETWEEN ? AND ? ";
        $wdTypes  .= 'ss';
        $wdParams[] = $monthStart;
        $wdParams[] = $monthEnd;
    }

    $wdSql .= " ORDER BY w.id DESC";

    $stmt = $mysqli->prepare($wdSql);
    $stmt->bind_param($wdTypes, ...$wdParams);
    $stmt->execute();
    $wres = $stmt->get_result();
    $withdraws = $wres->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>

<link rel="stylesheet" href="../assets/style.css">

<style>
.finance-wrapper{
  max-width:1200px;
  margin:20px auto 40px;
  padding:0 10px;
}
.finance-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:16px;
  gap:8px;
}
.finance-header h1{
  font-size:22px;
  font-weight:700;
  margin:0;
}
.finance-header .meta{
  font-size:13px;
  color:#6b7280;
}
.finance-filters{
  display:flex;
  flex-wrap:wrap;
  gap:8px;
  align-items:center;
  margin-bottom:14px;
  background:#f9fafb;
  border-radius:12px;
  padding:10px 12px;
  border:1px solid #e5e7eb;
}
.finance-filters label{
  font-size:12px;
  color:#4b5563;
}
.finance-filters select,
.finance-filters input{
  font-size:13px;
  padding:6px 8px;
  border-radius:8px;
  border:1px solid #d1d5db;
  background:#ffffff;
}
.finance-filters button{
  padding:7px 12px;
  border-radius:8px;
  border:none;
  background:#0ea5e9;
  color:#ffffff;
  font-size:13px;
  cursor:pointer;
}
.finance-filters button:hover{
  background:#0284c7;
}

.finance-cards{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:12px;
  margin-bottom:20px;
}
.fin-card{
  background:#ffffff;
  border-radius:14px;
  border:1px solid #e5e7eb;
  padding:14px 16px;
  box-shadow:0 1px 4px rgba(15,23,42,0.04);
}
.fin-card .label{
  font-size:13px;
  color:#6b7280;
  margin-bottom:6px;
}
.fin-card .value{
  font-size:18px;
  font-weight:700;
  color:#0f172a;
}
.fin-card .sub{
  font-size:12px;
  color:#9ca3af;
  margin-top:4px;
}
.fin-card.main-balance{
  border:1px solid #0ea5e9;
  box-shadow:0 0 0 1px rgba(14,165,233,0.12);
}

.table-card{
  background:#ffffff;
  border-radius:16px;
  border:1px solid #e5e7eb;
  padding:16px;
  margin-top:18px;
  box-shadow:0 1px 4px rgba(15,23,42,0.04);
}
.table-card h2{
  font-size:16px;
  margin:0 0 10px;
}
.table-responsive{
  width:100%;
  overflow-x:auto;
}
.table{
  width:100%;
  border-collapse:collapse;
  font-size:13px;
}
.table th,
.table td{
  border-bottom:1px solid #f1f5f9;
  padding:6px 8px;
  white-space:nowrap;
}
.table th{
  background:#f9fafb;
  font-weight:600;
  color:#4b5563;
}
.badge-status{
  display:inline-block;
  padding:2px 8px;
  border-radius:999px;
  font-size:11px;
}
.badge-status.new{background:#e0f2fe;color:#075985;}
.badge-status.assigned_to_buyer{background:#fef9c3;color:#854d0e;}
.badge-status.purchased{background:#dcfce7;color:#166534;}
.badge-status.handover_to_head{background:#e0f2fe;color:#1d4ed8;}
.badge-status.out_for_delivery{background:#fee2e2;color:#b91c1c;}
.badge-status.delivered{background:#bbf7d0;color:#166534;}
.badge-status.failed{background:#fee2e2;color:#b91c1c;}

@media (max-width:768px){
  .finance-header{
    flex-direction:column;
    align-items:flex-start;
  }
}
</style>

<div class="finance-wrapper">

  <div class="finance-header">
    <h1>
      حساب مالی فروشنده
      <?php if($seller): ?>
        : <?= e($seller['full_name'] ?: $seller['username']) ?>
      <?php endif; ?>
    </h1>
    <div class="meta">
      <?php if($seller): ?>
        یوزرنیم: <strong><?= e($seller['username']) ?></strong>
      <?php else: ?>
        <?php if($role === 'admin'): ?>
          لطفا یک فروشنده انتخاب کنید.
        <?php endif; ?>
      <?php endif; ?>
    </div>
  </div>

  <!-- فیلترها -->
  <form method="get" class="finance-filters">
    <?php if($role === 'admin'): ?>
      <label>فروشنده:</label>
      <select name="username">
        <option value="">انتخاب فروشنده...</option>
        <?php foreach($seller_list as $s): ?>
          <option value="<?=e($s['username'])?>" <?=$s['username']===$requested_user?'selected':''?>>
            <?=e($s['full_name'] ?: $s['username'])?>
          </option>
        <?php endforeach; ?>
      </select>
    <?php else: ?>
      <input type="hidden" name="username" value="<?=e($requested_user)?>">
    <?php endif; ?>

    <label>ماه (شمسی):</label>
    <input type="text" id="monthPicker" name="month" value="<?=e($monthJ)?>" placeholder="مثال: 1404/08">

    <label>وضعیت ارسال:</label>
    <select name="shipping_status">
      <option value="">همه وضعیت‌ها</option>
      <option value="new"               <?=$filterStatus==='new'?'selected':''?>>جدید</option>
      <option value="assigned_to_buyer" <?=$filterStatus==='assigned_to_buyer'?'selected':''?>>ارجاع به خریدار</option>
      <option value="purchased"         <?=$filterStatus==='purchased'?'selected':''?>>خریداری شده</option>
      <option value="handover_to_head"  <?=$filterStatus==='handover_to_head'?'selected':''?>>تحویل به مسئول ارسال</option>
      <option value="out_for_delivery"  <?=$filterStatus==='out_for_delivery'?'selected':''?>>در حال ارسال</option>
      <option value="delivered"         <?=$filterStatus==='delivered'?'selected':''?>>تحویل موفق</option>
      <option value="failed"            <?=$filterStatus==='failed'?'selected':''?>>ناموفق</option>
    </select>

    <label>جستجو:</label>
    <input type="text" name="q" value="<?=e($search)?>" placeholder="شماره فاکتور / مشتری / UID">

    <button type="submit">اعمال فیلتر</button>
  </form>

  <?php if($seller): ?>

  <div class="finance-cards">
    <div class="fin-card main-balance">
      <div class="label">مانده قابل برداشت</div>
      <div class="value"><?= nf($current_balance) ?> تومان</div>
      <div class="sub">جمع بیعانه‌ها − جمع برداشت‌ها</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع بیعانه‌های ثبت شده</div>
      <div class="value"><?= nf($total_deposit) ?> تومان</div>
      <div class="sub">از روی فاکتورهای ثبت شده</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع برداشت‌های ثبت شده</div>
      <div class="value"><?= nf($total_withdraw) ?> تومان</div>
      <div class="sub">تمام برداشت‌ها از جدول withdrawals</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع کل مبلغ فاکتورها</div>
      <div class="value"><?= nf($total_amount) ?> تومان</div>
      <div class="sub">total_amount برای این فروشنده</div>
    </div>
  </div>
<?php
$statusMap = [
    'new'               => '🟦 جدید',
    'assigned_to_buyer' => '🟨 ارجاع به خریدار',
    'purchased'         => '🟩 خریداری شد',
    'handover_to_head'  => '🔵 تحویل به مسئول ارسال',
    'out_for_delivery'  => '🟧 در حال ارسال',
    'delivered'         => '🟩 تحویل موفق',
    'failed'            => '🔴 ناموفق',
];
?>

  <div class="table-card">
    <h2>📄 فاکتورهای این فروشنده</h2>
    <div class="table-responsive">
      <table class="table">
        <thead>
        <tr>
          <th>#</th>
          <th>فاکتور</th>
          <th>مشتری</th>
          <th>تاریخ خرید</th>
          <th>وضعیت ارسال</th>
          <th>جمع فاکتور</th>
          <th>بیعانه</th>
          <th>COD</th>
          <th>مانده</th>
          <th>لینک</th>
        </tr>
        </thead>
        <tbody>
        <?php if(!$orders): ?>
          <tr><td colspan="10" style="text-align:center;color:#9ca3af;">فاکتوری برای این فیلتر پیدا نشد.</td></tr>
        <?php else: ?>
          <?php $i=1; foreach($orders as $o): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($o['invoice_no']) ?></td>
              <td><?= e($o['customer_name']) ?></td>
              <td>
                <?php
                  $dateSrc = $o['purchase_date'] ?: $o['created_at'];
                  echo toJalaliEn($dateSrc);
                ?>
              </td>
              <td>
    <?php
        $st    = $o['shipping_status'] ?? 'new';
        $cls   = $st;
        $label = $statusMap[$st] ?? 'نامشخص';
    ?>
    <span class="badge-status <?=$cls?>"><?= $label ?></span>
</td>

              <td><?= nf($o['total_amount']) ?></td>
              <td><?= nf($o['total_deposit']) ?></td>
              <td><?= nf($o['total_cod']) ?></td>
              <td><?= nf($o['total_remaining']) ?></td>
              <td>
                <?php if(!empty($o['order_uid'])): ?>
                  <a href="../view.php?id=<?= e($o['order_uid']) ?>" target="_blank">👁 مشاهده</a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="table-card">
    <h2>💸 سوابق برداشت از حساب</h2>
    <div class="table-responsive">
      <table class="table">
        <thead>
        <tr>
          <th>#</th>
          <th>تاریخ</th>
          <th>مبلغ</th>
          <th>توضیحات</th>
          <th>فاکتور مرتبط</th>
        </tr>
        </thead>
        <tbody>
        <?php if(!$withdraws): ?>
          <tr><td colspan="5" style="text-align:center;color:#9ca3af;">برداشتی برای این فیلتر ثبت نشده است.</td></tr>
        <?php else: ?>
          <?php $i=1; foreach($withdraws as $w): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= toJalaliEn(substr($w['created_at'],0,10)) ?></td>
              <td><?= nf($w['amount']) ?></td>
              <td><?= e($w['note']) ?></td>
              <td>
                <?php if(!empty($w['order_uid'])): ?>
                  <a href="../view.php?id=<?= e($w['order_uid']) ?>" target="_blank">👁 مشاهده</a>
                <?php else: ?>
                  <?= e($w['invoice_no'] ?: '-') ?>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php endif; // end if seller ?>

</div>

<script>
// اگر خواستی ماه شمسی رو با datepicker هم کنی، اینجا می‌تونی PersianDatepicker وصل کنی.
// فعلا ماه رو دستی به صورت 1404/08 وارد می‌کنی.
</script>
