<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require_once __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if (!in_array($role, ['admin','head_carrier','logistic'], true)) {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

function nf($n){ return number_format((float)$n, 0, '.', ','); }
function safe($x){ return htmlspecialchars($x ?? '', ENT_QUOTES, 'UTF-8'); }
function toJalaliEn($d){
    if(!$d || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd)=explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return $j[0].'/'.$j[1].'/'.$j[2];
}

$status_map = [
  'new'               => '🕓 ثبت شده (در انتظار بررسی)',
  'assigned_to_buyer' => '📌 ارجاع به مسئول خرید',
  'purchased'         => '🛒 کالا خریداری شده (در حال آماده سازی)',
  'handover_to_head'  => '📦 تحویل به سر باربر',
  'out_for_delivery'  => '🚚 در حال ارسال',
  'delivered'         => '✅ تحویل داده شد',
  'failed'            => '❌ تحویل ناموفق / نیاز به هماهنگی'
];
function build_driver_link($o){
    if(!defined('DELIVERY_LINK_SECRET')) return '';
    if(empty($o['tracking_code']) || empty($o['order_uid'])) return '';

    $token = hash_hmac('sha256', $o['order_uid'], DELIVERY_LINK_SECRET);

    return "/orders/delivery/delivery.php?code="
        .rawurlencode($o['tracking_code'])
        ."&token="
        .rawurlencode($token);
}


$valid_statuses = array_keys($status_map);

// ===============================
// 1) هندل ثبت مدرک تحویل (Proof)
// ===============================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'upload_proof') {

        $uid = trim($_POST['order_uid'] ?? '');
        if ($uid === '') {
            header("Location: index.php");
            exit;
        }

        // واکشی سفارش و چک دسترسی سر باربر
        $stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
        $stmt->bind_param('s', $uid);
        $stmt->execute();
        $o = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if (!$o) {
            header("Location: index.php");
            exit;
        }

        if ($role !== 'admin' && ($o['head_carrier_username'] ?? '') !== $username) {
            http_response_code(403);
            exit('دسترسی به این سفارش ندارید.');
        }

        $order_id = (int)$o['id'];

        // اگر جدول وجود نداشت، کرش نکن
        $chk = $mysqli->query("SHOW TABLES LIKE 'order_delivery_proofs'");
        if (!$chk || $chk->num_rows === 0) {
            // جدول وجود ندارد
            header("Location: index.php?id=".urlencode($uid)."&msg=noproof_table");
            exit;
        }

        // آماده‌سازی آپلود
        $uploadDir = __DIR__.'/../uploads/delivery/';
        $uploadWeb = 'uploads/delivery/';

        if (!is_dir($uploadDir)) {
            @mkdir($uploadDir, 0775, true);
        }

        $serial_number = trim($_POST['serial_number'] ?? '');
        $note          = trim($_POST['note'] ?? '');

        $photos = ['','',''];

        // تابع کوچک برای آپلود
        $slots = ['photo1','photo2','photo3'];
        foreach ($slots as $idx => $field) {
            if (!empty($_FILES[$field]['name']) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {

                $tmp_name = $_FILES[$field]['tmp_name'];
                $orig     = $_FILES[$field]['name'];

                // فقط عکس
                $finfo = @getimagesize($tmp_name);
                if ($finfo === false) {
                    continue;
                }

                $ext = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
                if (!in_array($ext, ['jpg','jpeg','png','webp','gif'], true)) {
                    $ext = 'jpg';
                }

                $newName = time() . '_' . mt_rand(1000,9999) . '.' . $ext;
                $destPath = $uploadDir . $newName;

                if (@move_uploaded_file($tmp_name, $destPath)) {
                    $photos[$idx] = $uploadWeb . $newName;
                }
            }
        }

        // درج در جدول
        $stmt = $mysqli->prepare("
            INSERT INTO order_delivery_proofs
            (order_id, item_id, serial_number, customer_name, customer_phone, address_snapshot, note,
             photo1, photo2, photo3, video1, created_by)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
        ");

        $customer_name  = $o['customer_name'] ?? '';
        $customer_phone = $o['mobile1'] ?? '';
        $address_snap   = $o['address'] ?? '';
        $video = null;

        $item_id_null = null;

        $stmt->bind_param(
            'iissssssssss',
            $order_id,
            $item_id_null,
            $serial_number,
            $customer_name,
            $customer_phone,
            $address_snap,
            $note,
            $photos[0],
            $photos[1],
            $photos[2],
            $video,
            $username
        );
        $stmt->execute();
        $stmt->close();

        header("Location: index.php?id=".urlencode($uid)."#proofs");
        exit;
    }
}

// ===============================
// 2) لیست سفارش‌های سر باربر
// ===============================
$uid    = trim($_GET['id'] ?? '');
$q      = trim($_GET['q'] ?? '');
$status = trim($_GET['status'] ?? '');

$conditions = [];

if ($role === 'admin') {
    $conditions[] = "head_carrier_username IS NOT NULL AND head_carrier_username <> ''";
} else {
    $u_esc = $mysqli->real_escape_string($username);
    $conditions[] = "head_carrier_username = '{$u_esc}'";
}

if ($q !== '') {
    $q_esc = $mysqli->real_escape_string($q);
    $conditions[] = "(customer_name LIKE '%{$q_esc}%' OR order_uid LIKE '%{$q_esc}%' OR invoice_no LIKE '%{$q_esc}%')";
}

if ($status !== '' && in_array($status, $valid_statuses, true)) {
    $st_esc = $mysqli->real_escape_string($status);
    $conditions[] = "shipping_status = '{$st_esc}'";
}

$where = $conditions ? implode(' AND ', $conditions) : '1=0';

$res = $mysqli->query("SELECT * FROM orders WHERE {$where} ORDER BY id DESC");
$orders = [];
if ($res) {
    while($r = $res->fetch_assoc()){ $orders[] = $r; }
}

// اگر id خالی بود، اولین سفارش را انتخاب کن
if ($uid === '' && !empty($orders)) {
    $uid = $orders[0]['order_uid'] ?? '';
}

// ===============================
// 3) جزئیات سفارش انتخاب‌شده
// ===============================
$o = null;
$items = [];
$proofs = [];
$status_raw = 'new';
$status_label = '';
$track_link = '';
$view_link  = '';

if ($uid !== '') {
    $stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
    $stmt->bind_param('s', $uid);
    $stmt->execute();
    $o = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if ($o && ($role === 'admin' || $o['head_carrier_username'] === $username)) {

        $order_id = (int)$o['id'];

        $stmt = $mysqli->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC");
        $stmt->bind_param('i', $order_id);
        $stmt->execute();
        $resI = $stmt->get_result();
        while($row = $resI->fetch_assoc()){ $items[] = $row; }
        $stmt->close();

        // proofs
        $chk = $mysqli->query("SHOW TABLES LIKE 'order_delivery_proofs'");
        if ($chk && $chk->num_rows > 0) {
            $stmt = $mysqli->prepare("SELECT * FROM order_delivery_proofs WHERE order_id=? ORDER BY id DESC");
            $stmt->bind_param('i', $order_id);
            $stmt->execute();
            $resP = $stmt->get_result();
            while($row = $resP->fetch_assoc()){ $proofs[] = $row; }
            $stmt->close();
        }

        $status_raw   = trim($o['shipping_status'] ?? 'new');
        $status_label = $status_map[$status_raw] ?? $status_raw;

        $track_link = rtrim(BASE_URL,'/').'/track.php?code='.rawurlencode($o['tracking_code'] ?? '');
        $view_link  = '/orders/view.php?id='.urlencode($uid);

    } else {
        $o = null;
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>پنل سر باربر — سلام‌بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="/orders/assets/view.css">

<style>
body{
    font-size:15px;
}
.container{
    max-width:1200px;
}
.card{
    margin-bottom:12px;
}
h3{
    font-size:18px;
    margin-top:0;
}
input,select,textarea{
    font-size:15px;
    padding:8px 10px;
    border-radius:6px;
    border:1px solid #d1d5db;
}
.btn{
    font-size:14px;
    padding:8px 14px;
    border-radius:6px;
}
.table th,.table td{
    font-size:14px;
}
.layout{
    display:flex;
    flex-wrap:wrap;
    gap:10px;
}
.panel-list{
    flex:1 1 280px;
    max-width:350px;
}
.panel-detail{
    flex:2 1 500px;
    min-width:0;
}
.order-row{
    padding:8px 10px;
    border-bottom:1px solid #e5e7eb;
    cursor:pointer;
}
.order-row.active{
    background:#f0f9ff;
    border-right:3px solid #0ea5e9;
}
.order-row .top{
    display:flex;
    justify-content:space-between;
    font-size:13px;
}
.order-row .customer{
    font-size:14px;
    font-weight:600;
}
.order-row .meta{
    font-size:12px;
    color:#6b7280;
}
.badge{
    display:inline-block;
    padding:2px 6px;
    border-radius:999px;
    background:#e5e7eb;
    font-size:11px;
    margin-left:4px;
}
.status-label{
    font-weight:600;
    color:#0369a1;
    font-size:14px;
}
.proofs-grid{
    display:flex;
    flex-wrap:wrap;
    gap:8px;
}
.proof-card{
    border:1px solid #e5e7eb;
    border-radius:8px;
    padding:6px;
    width:170px;
    font-size:12px;
}
.proof-card img{
    width:100%;
    height:110px;
    object-fit:cover;
    border-radius:6px;
    margin-bottom:4px;
}
.form-grid{
    display:flex;
    flex-direction:column;
    gap:6px;
    margin-top:6px;
}
@media (max-width:800px){
    .panel-list,.panel-detail{
        flex:1 1 100%;
        max-width:100%;
    }
}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="container">

<div class="layout">

    <!-- لیست سفارش‌ها -->
    <div class="panel-list">
        <section class="card">
            <h3>📦 سفارش‌های سر باربر</h3>

            <form method="get" style="display:flex;flex-direction:column;gap:6px;margin-bottom:8px;">
                <input name="q" value="<?=safe($q)?>" placeholder="نام مشتری / UID / فاکتور">
                <select name="status">
                    <option value="">همه وضعیت‌ها</option>
                    <?php foreach($valid_statuses as $st): ?>
                        <option value="<?=$st?>" <?=$status===$st?'selected':''?>><?=safe($status_map[$st])?></option>
                    <?php endforeach; ?>
                </select>
                <button class="btn">جستجو</button>
            </form>

            <?php if(empty($orders)): ?>
                <p style="font-size:13px;color:#6b7280;margin:0;">
                    سفارشی برای شما پیدا نشد.
                </p>
            <?php else: ?>
                <?php foreach($orders as $ord): 
                    $ouid   = $ord['order_uid'] ?? '';
                    $active = ($ouid === $uid);
                ?>
                    <a href="index.php?id=<?=urlencode($ouid)?>&q=<?=urlencode($q)?>&status=<?=urlencode($status)?>" style="text-decoration:none;color:inherit;">
                        <div class="order-row <?=$active?'active':''?>">
                            <div class="top">
                                <span>#<?=safe($ouid)?></span>
                                <span style="font-size:12px;">
                                   <?=toJalaliEn(substr($ord['created_at'] ?? '',0,10))?>
                                </span>
                            </div>
                            <div class="customer">
                                <?=safe($ord['customer_name'] ?? '')?>
                            </div>
                            <div class="meta">
                                <?=nf($ord['total_amount'] ?? 0)?> تومان
                                <?php if(!empty($ord['province'])): ?>
                                    • <?=safe($ord['province'])?>
                                <?php endif; ?>
                            </div>
                            <div class="meta">
                                <?=safe($status_map[$ord['shipping_status']] ?? $ord['shipping_status'])?>
                            </div>
                        </div>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </section>
    </div>

    <!-- جزئیات سفارش -->
    <div class="panel-detail">
    <?php if(!$o): ?>
        <section class="card">
            <h3>جزئیات سفارش</h3>
            <p style="font-size:13px;color:#6b7280;margin:0;">
                سفارشی انتخاب نشده یا دسترسی ندارید.
            </p>
        </section>
    <?php else: ?>
        <section class="card">
            <h3>سفارش <?=safe($uid)?></h3>

            <div class="info-grid">
                <div class="info-item">
                    <span class="label">مشتری:</span>
                    <span class="value"><?=safe($o['customer_name'])?></span>
                </div>
                <div class="info-item">
                    <span class="label">موبایل:</span>
                    <span class="value"><?=safe($o['mobile1'])?></span>
                </div>
                <div class="info-item">
                    <span class="label">استان:</span>
                    <span class="value"><?=safe($o['province'])?></span>
                </div>
                <div class="info-item">
                    <span class="label">فروشنده:</span>
                    <span class="value"><?=safe($o['seller_name'])?></span>
                </div>
                <div class="info-item">
                    <span class="label">تاریخ ثبت:</span>
                    <span class="value"><?=toJalaliEn(substr($o['created_at'],0,10))?></span>
                </div>
                <div class="info-item">
                    <span class="label">وضعیت فعلی:</span>
                    <span class="value status-label"><?=safe($status_label)?></span>
                </div>
                <div class="info-item wide">
                    <span class="label">آدرس:</span>
                    <span class="value"><?=safe($o['address'])?></span>
                </div>
            </div>

            <div style="margin-top:10px;">
                <a class="btn btn-ghost" href="<?=safe($view_link)?>" target="_blank">مشاهده فاکتور کامل</a>
                <?php if($track_link): ?>
                    <a class="btn btn-ghost" href="<?=safe($track_link)?>" target="_blank">صفحه پیگیری مشتری</a>
                <?php endif; ?>
                <?php $driver_link = build_driver_link($o); ?>
<?php if($driver_link): ?>
    <a class="btn btn-ghost" href="<?=$driver_link?>" target="_blank">لینک تحویل راننده</a>
<?php endif; ?>

            </div>
        </section>

        <!-- اقلام -->
        <section class="card">
            <h3>اقلام سفارش</h3>
            <?php if(empty($items)): ?>
                <p style="font-size:13px;color:#6b7280;margin:0;">هیچ قلمی ثبت نشده است.</p>
            <?php else: ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>مدل</th>
                            <th>قیمت</th>
                            <th>بیعانه</th>
                            <th>COD</th>
                            <th>مانده</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach($items as $it): ?>
                        <tr>
                            <td><?=$i++?></td>
                            <td><?=safe($it['model'])?></td>
                            <td><?=nf($it['price'])?></td>
                            <td><?=nf($it['deposit'])?></td>
                            <td><?=nf($it['cod'])?></td>
                            <td><?=nf($it['remaining'])?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </section>

        <!-- تغییر وضعیت -->
        <section class="card">
            <h3>تغییر وضعیت سفارش</h3>
            <p style="font-size:13px;color:#6b7280;margin:0 0 6px;">
                وضعیت فعلی: <span class="status-label"><?=safe($status_label)?></span>
            </p>

            <form id="statusForm" class="form-grid">
                <select id="statusSelect">
                    <?php foreach($valid_statuses as $st): ?>
                        <option value="<?=$st?>"><?=safe($status_map[$st])?></option>
                    <?php endforeach; ?>
                </select>
                <input id="statusNote" placeholder="یادداشت وضعیت (اختیاری)" value="<?=safe($o['status_note'])?>">
                <button type="submit" class="btn btn primary">ثبت وضعیت</button>
            </form>
        </section>

        <!-- مدرک تحویل -->
        <section class="card" id="proofs">
            <h3>مدرک تحویل (عکس + سریال نامبر)</h3>

            <form method="post" enctype="multipart/form-data" class="form-grid">
                <input type="hidden" name="action" value="upload_proof">
                <input type="hidden" name="order_uid" value="<?=safe($uid)?>">

                <input name="serial_number" placeholder="سریال نامبر محصول (مثال: 1234ABC567)" style="direction:ltr;text-align:center;">

                <textarea name="note" rows="3" placeholder="توضیحات (مثلاً: سریال تایید شد، محصول سالم، جعبه باز، ... )"></textarea>

                <div>
                    <label>عکس محصول (حداکثر ۳ تصویر):</label><br>
                    <input type="file" name="photo1" accept="image/*"><br>
                    <input type="file" name="photo2" accept="image/*"><br>
                    <input type="file" name="photo3" accept="image/*">
                </div>

                <button type="submit" class="btn btn primary" style="margin-top:4px;">
                    ✔ ثبت مدرک تحویل
                </button>
            </form>

            <?php if(!empty($proofs)): ?>
                <hr>
                <div class="proofs-grid">
                    <?php foreach($proofs as $p): ?>
                        <div class="proof-card">
                            <?php if(!empty($p['photo1'])): ?>
                                <img src="/orders/<?=safe($p['photo1'])?>" alt="">
                            <?php endif; ?>
                            <div><b>سریال:</b> <?=safe($p['serial_number'])?></div>
                            <?php if(!empty($p['note'])): ?>
                                <div><?=nl2br(safe($p['note']))?></div>
                            <?php endif; ?>
                            <div style="font-size:11px;color:#6b7280;margin-top:3px;">
                                <?=safe($p['created_at'])?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </section>

    <?php endif; ?>
    </div>

</div><!-- /layout -->

</div><!-- /container -->

<script>
// تنظیم مقدار اولیه وضعیت
<?php if($o): ?>
document.getElementById('statusSelect').value = <?=json_encode($status_raw, JSON_UNESCAPED_UNICODE)?>;
<?php endif; ?>

// ارسال تغییر وضعیت با xhr_update_status.php
<?php if($o): ?>
document.getElementById('statusForm').addEventListener('submit', async function(e){
    e.preventDefault();
    const fd = new FormData();
    fd.append('order_uid', <?=json_encode($uid)?>);
    fd.append('status', document.getElementById('statusSelect').value);
    fd.append('note',   document.getElementById('statusNote').value);

    try{
        const r = await fetch('../xhr_update_status.php',{
            method:'POST',
            body:fd
        });
        const j = await r.json();
        if(j.ok){
            alert('وضعیت با موفقیت ثبت شد.');
            location.reload();
        }else{
            alert('خطا: '+(j.error || 'ثبت وضعیت ناموفق بود'));
        }
    }catch(err){
        alert('خطا در ارتباط با سرور');
    }
});
<?php endif; ?>
</script>

</body>
</html>
