<?php
header("Content-Type: application/json; charset=utf-8");

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
require __DIR__ . '/../includes/db_connect.php';

// مقدار جستجو
$q = trim($_GET['q'] ?? '');
if ($q === '') {
    echo json_encode([]);
    exit;
}

// ساخت الگوی LIKE
$q_like = "%{$q}%";

// جستجو فقط روی ستون title
$stmt = $mysqli->prepare("
    SELECT id, title
    FROM product
    WHERE title LIKE ?
    ORDER BY title ASC
    LIMIT 20
");
$stmt->bind_param("s", $q_like);
$stmt->execute();
$res = $stmt->get_result();

$out = [];
while ($row = $res->fetch_assoc()) {

    // همیشه title را برای Select2 برمی‌گردانیم
    $out[] = [
        "id"    => $row["id"],      // مقدار واقعی دیتابیس
        "text"  => $row["title"],   // نمایش در Select2
        "title" => $row["title"]    // ذخیره در فرم
    ];
}

// خروجی JSON استاندارد
echo json_encode($out, JSON_UNESCAPED_UNICODE);
exit;
