<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require_once __DIR__.'/../includes/jdf.php';

$username = $_SESSION['username'];
$role     = $_SESSION['role'];

// فقط مدیر و سر باربر اجازه دارند
if(!in_array($role, ['admin', 'head_carrier'])){
    echo "⛔ دسترسی غیرمجاز";
    exit;
}

// ===========================
// فیلتر صحیح بر اساس ستون موجود
// created_by = کاربری که تحویل را ثبت کرده (سر باربر)
// ===========================
$where = ($role === 'head_carrier')
    ? "WHERE p.created_by = '$username'"
    : ""; // مدیر → همه را می‌بیند

$q = $mysqli->query("
    SELECT 
        p.*,
        o.invoice_no,
        o.customer_name AS order_customer
    FROM order_delivery_proofs p
    LEFT JOIN orders o ON o.id = p.order_id
    $where
    ORDER BY p.id DESC
");

function toJ($gdate){
    if(!$gdate) return '-';
    $d = substr($gdate, 0, 10);
    list($gy,$gm,$gd)=explode('-', $d);
    return gregorian_to_jalali($gy,$gm,$gd,'/');
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>📦 لیست تحویل‌ها</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="../assets/style.css">

<style>
body{
    background:#f7f8fa;
    font-family:'IRANSansWeb';
    margin:0;
    padding:20px;
}
.box{
    max-width:1000px;
    margin:0 auto;
}
.card{
    background:white;
    padding:14px;
    border-radius:12px;
    margin-bottom:12px;
    box-shadow:0 2px 8px rgba(0,0,0,.06);
}
.card h3{
    margin:0 0 8px 0;
    font-size:16px;
}
.grid{
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:10px;
}
.thumb img{
    width:100%;
    border-radius:8px;
}
.btn{
    display:inline-block;
    background:#2563eb;
    color:white;
    padding:6px 12px;
    border-radius:8px;
    text-decoration:none;
    font-size:13px;
}
</style>

</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="box">

<h2 style="margin-bottom:15px;">📦 آرشیو تحویل کالا</h2>

<?php if($q->num_rows == 0): ?>
    <div class="card">هنوز هیچ تحویلی ثبت نشده است.</div>
<?php endif; ?>

<?php while($p = $q->fetch_assoc()): ?>

<div class="card">

    <h3>فاکتور: <?= htmlspecialchars($p['invoice_no']) ?></h3>

    <div class="grid">

        <div>
            <b>مشتری:</b> <?= htmlspecialchars($p['customer_name']) ?: htmlspecialchars($p['order_customer']) ?><br>
            <b>موبایل:</b> <?= htmlspecialchars($p['customer_phone']) ?><br>
            <b>سریال دستگاه:</b> <?= htmlspecialchars($p['serial_number']) ?><br>
            <b>ثبت شده توسط:</b> <?= htmlspecialchars($p['created_by']) ?><br>
            <b>تاریخ تحویل:</b> <?= toJ($p['created_at']) ?><br>

            <?php if($p['note']): ?>
                <b>توضیح:</b>
                <div><?= nl2br(htmlspecialchars($p['note'])) ?></div>
            <?php endif; ?>
        </div>

        <div style="text-align:left;">
            <?php if($p['order_id']): ?>
            <a class="btn" href="../view.php?id=<?= $p['order_id'] ?>" target="_blank">
                👁 مشاهده سفارش
            </a>
            <?php endif; ?>
        </div>

    </div>

    <?php if($p['address_snapshot']): ?>
    <div style="margin-top:12px;">
        <b>آدرس مشتری (در لحظهٔ تحویل):</b>
        <div style="white-space:pre-wrap;">
            <?= nl2br(htmlspecialchars($p['address_snapshot'])) ?>
        </div>
    </div>
    <?php endif; ?>

    <div style="margin-top:12px;">
        <h4>تصاویر تحویل:</h4>

        <div class="grid">

            <?php if($p['photo1']): ?>
            <div class="thumb">
                <img src="<?= htmlspecialchars($p['photo1']) ?>">
            </div>
            <?php endif; ?>

            <?php if($p['photo2']): ?>
            <div class="thumb">
                <img src="<?= htmlspecialchars($p['photo2']) ?>">
            </div>
            <?php endif; ?>

            <?php if($p['photo3']): ?>
            <div class="thumb">
                <img src="<?= htmlspecialchars($p['photo3']) ?>">
            </div>
            <?php endif; ?>

        </div>

        <?php if($p['video1']): ?>
            <div style="margin-top:12px;">
                <h4>ویدئو:</h4>
                <a class="btn" href="<?= htmlspecialchars($p['video1']) ?>" target="_blank">🎥 مشاهده ویدئو</a>
            </div>
        <?php endif; ?>

    </div>

</div>

<?php endwhile; ?>

</div>

</body>
</html>
