<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/header.php';

$username = $_SESSION['username'] ?? '';
$role     = $_SESSION['role'] ?? '';

if (!in_array($role, ['head_carrier','admin'], true)) {
    http_response_code(403);
    echo "دسترسی غیرمجاز";
    exit;
}

$order_id = (int)($_GET['order_id'] ?? $_POST['order_id'] ?? 0);

if ($order_id <= 0) {
    echo "شناسه سفارش نامعتبر است.";
    exit;
}

// گرفتن اطلاعات سفارش
$res = $mysqli->query("SELECT * FROM orders WHERE id=$order_id");
$order = $res ? $res->fetch_assoc() : null;
if (!$order) {
    echo "سفارش یافت نشد.";
    exit;
}

// پردازش ثبت فرم
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $serial_number  = trim($_POST['serial_number'] ?? '');
    $customer_name  = trim($_POST['customer_name'] ?? '');
    $customer_phone = trim($_POST['customer_phone'] ?? '');
    $note           = trim($_POST['note'] ?? '');

    // آپلود فایل‌ها (ساده – بدون ولیدیشن پیچیده)
    $uploadDir = __DIR__ . '/../../uploads/delivery/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0775, true);
    }

    $photo1 = $photo2 = $photo3 = $video1 = null;

    $filesMap = [
        'photo1' => 'photo1',
        'photo2' => 'photo2',
        'photo3' => 'photo3',
        'video1' => 'video1',
    ];

    foreach ($filesMap as $field => &$varName) {
        if (!empty($_FILES[$field]['name'])) {
            $ext = pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION);
            $filename = 'ord'.$order_id.'_'.$field.'_'.time().'.'.$ext;
            $target = $uploadDir . $filename;
            if (move_uploaded_file($_FILES[$field]['tmp_name'], $target)) {
                $$varName = 'uploads/delivery/'.$filename;
            }
        }
    }

    $stmt = $mysqli->prepare("
        INSERT INTO order_delivery_proofs
        (order_id, serial_number, customer_name, customer_phone, note,
         photo1, photo2, photo3, video1, created_by)
        VALUES (?,?,?,?,?,?,?,?,?,?)
    ");
    $stmt->bind_param(
        "isssssssss",
        $order_id,
        $serial_number,
        $customer_name,
        $customer_phone,
        $note,
        $photo1,
        $photo2,
        $photo3,
        $video1,
        $username
    );
    $stmt->execute();

    // آپدیت وضعیت سفارش
    $mysqli->query("
      UPDATE orders
      SET shipping_status='delivered',
          delivered_at = NOW()
      WHERE id=$order_id
    ");

    // نوتیف برای فروشنده و ادمین
    $sellerUser = $order['username'];
    $title   = 'سفارش تحویل شد';
    $message = "سفارش {$order['invoice_no']} تحویل مشتری شد.";

    $n = $mysqli->prepare("
      INSERT INTO notifications (username, type, order_id, title, message)
      VALUES (?,?,?,?,?)
    ");
    $type = 'delivery_submitted';

    foreach ([$sellerUser, 'admin'] as $u) {
        $n->bind_param("ssiss", $u, $type, $order_id, $title, $message);
        $n->execute();
    }

    echo "<p>تحویل ثبت شد.</p>";
    echo '<p><a href="../head/index.php">بازگشت به لیست سفارش‌های سر باربر</a></p>';
    exit;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>ثبت تحویل سفارش</title>
</head>
<body>
<h1>ثبت تحویل برای فاکتور <?=htmlspecialchars($order['invoice_no'])?></h1>

<form method="post" enctype="multipart/form-data">
  <input type="hidden" name="order_id" value="<?=$order_id?>">

  <div>
    <label>نام مشتری</label>
    <input type="text" name="customer_name" value="<?=htmlspecialchars($order['customer_name'])?>">
  </div>

  <div>
    <label>شماره تماس مشتری</label>
    <input type="text" name="customer_phone" value="<?=htmlspecialchars($order['mobile1'])?>">
  </div>

  <div>
    <label>سریال دستگاه</label>
    <input type="text" name="serial_number">
  </div>

  <div>
    <label>توضیحات</label>
    <textarea name="note" rows="3"></textarea>
  </div>

  <div>
    <label>عکس ۱</label>
    <input type="file" name="photo1" accept="image/*">
  </div>
  <div>
    <label>عکس ۲</label>
    <input type="file" name="photo2" accept="image/*">
  </div>
  <div>
    <label>عکس ۳</label>
    <input type="file" name="photo3" accept="image/*">
  </div>
  <div>
    <label>ویدئو</label>
    <input type="file" name="video1" accept="video/*">
  </div>

  <button type="submit">ثبت تحویل</button>
</form>
</body>
</html>
