<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';

// دسترسی فقط مسئول خرید
$role = $_SESSION['role'] ?? '';
if ($role !== 'buyer_manager' && $role !== 'admin') {
    exit("دسترسی غیرمجاز");
}

$buyer = $_SESSION['username'];

// فیلترها
$search = trim($_GET['search'] ?? '');
$month  = trim($_GET['month'] ?? '');
$where  = "buyer_username='" . $mysqli->real_escape_string($buyer) . "' 
           AND shipping_status IN ('assigned_to_buyer','purchased')";

// فیلتر جستجو
if ($search !== '') {
    $s = $mysqli->real_escape_string($search);
    $where .= " AND (customer_name LIKE '%$s%' OR order_uid LIKE '%$s%' OR invoice_no LIKE '%$s%')";
}

// فیلتر ماه شمسی
if ($month !== '') {
    // تبدیل ماه شمسی به بازه میلادی
    list($jy, $jm) = explode('-', $month);
    $start = jalali_to_gregorian($jy, $jm, 1, '-');
    $end   = jalali_to_gregorian($jy, $jm, 31, '-');

    $where .= " AND DATE(created_at) BETWEEN '$start' AND '$end'";
}

// دریافت سفارش‌ها
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

// تابع وضعیت
function statusTitle($st){
    switch($st){
        case 'assigned_to_buyer': return "در انتظار خرید";
        case 'purchased': return "خرید شده";
        default: return $st;
    }
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>سفارش‌های ارجاع شده — مسئول خرید</title>

<link rel="stylesheet" href="../assets/style.css">

<style>
body{background:#f3f5f9;font-family:'IRANSansWeb';}
.topbar{
    background:#0ea5e9;
    color:#fff;
    padding:12px 16px;
    font-size:18px;
    font-weight:700;
    text-align:center;
    border-bottom:3px solid #0284c7;
}
.card{
    background:#fff;
    padding:16px;
    margin:16px;
    border-radius:12px;
    box-shadow:0 3px 8px rgba(0,0,0,0.05);
}
.list-table{
    width:100%;
    border-collapse:collapse;
}
.list-table th{
    background:#e8f5ff;
    padding:10px;
    font-size:14px;
    border-bottom:1px solid #d0dee9;
}
.list-table td{
    padding:10px;
    font-size:14px;
    border-bottom:1px solid #f1f1f1;
}
.btn{
    padding:6px 12px;
    background:#0ea5e9;
    color:#fff;
    border-radius:6px;
    font-size:13px;
    text-decoration:none;
}
.filter-box{
    display:flex;
    flex-direction:column;
    gap:8px;
    margin-bottom:10px;
}
input,select{
    padding:8px;
    border:1px solid #d1d5db;
    border-radius:6px;
    font-size:14px;
}
@media(max-width:720px){
    .list-table{
        display:block;
        overflow-x:auto;
        white-space:nowrap;
    }
}
</style>

<!-- تقویم شمسی -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

</head>
<body>

<div class="topbar">سفارش‌های ارجاع شده به شما</div>

<div class="card">

<form method="get" class="filter-box">

    <input type="text" name="search" value="<?=$search?>" placeholder="جستجو: نام مشتری / کد سفارش">

    <input type="text" id="monthPicker" name="month" value="<?=$month?>" placeholder="فیلتر ماه (۱۴۰۳-۱۲)">

    <button class="btn" style="width:120px;">فیلتر</button>

</form>

<table class="list-table">
<thead>
<tr>
    <th>#</th>
    <th>کد سفارش</th>
    <th>مشتری</th>
    <th>مبلغ کل</th>
    <th>وضعیت</th>
    <th>عملیات</th>
</tr>
</thead>
<tbody>

<?php 
$i=1; 
while($o = $q->fetch_assoc()): 
?>
<tr>
    <td><?=$i++?></td>
    <td><?=$o['order_uid']?></td>
    <td><?=htmlspecialchars($o['customer_name'])?></td>
    <td><?=number_format($o['total_amount'])?> تومان</td>
    <td><?=statusTitle($o['shipping_status'])?></td>
    <td>
        <a class="btn" href="buyer_view.php?id=<?=$o['id']?>">مشاهده</a>
    </td>
</tr>
<?php endwhile; ?>

</tbody>
</table>

</div>

<script>
$("#monthPicker").persianDatepicker({
    format: 'YYYY-MM',
    viewMode: 'year',
});
</script>

</body>
</html>
