<?php
ini_set("display_errors", 1);
error_reporting(E_ALL);

// مسیر صحیح
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';


$username = $_SESSION['full_name'] ?? $_SESSION['username'];
$role     = $_SESSION['role'] ?? '';
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>داشبورد مدیریت — سلام‌بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="/orders/assets/style.css">

<style>
body{
    background:#f3f4f6;
    font-family:IRANSansWeb;
    padding:20px;
}

.container{
    max-width:900px;
    margin:0 auto;
}

h1{
    font-size:22px;
    margin-bottom:20px;
}

.grid{
    display:grid;
    grid-template-columns:repeat(auto-fill, minmax(220px,1fr));
    gap:15px;
}

.card{
    background:white;
    padding:18px;
    border-radius:14px;
    box-shadow:0 4px 15px rgba(0,0,0,.05);
    text-align:center;
    font-size:16px;
}

.card a{
    color:#0ea5e9;
    font-weight:bold;
}
</style>

</head>
<body>

<div class="container">

    <h1>👋 خوش آمدی <?=htmlspecialchars($username)?> </h1>

    <div class="grid">

        <!-- خانه -->
        <div class="card">
            <a href="/orders/index.php">🏠 داشبورد</a>
        </div>

        <!-- فاکتور جدید -->
        <div class="card">
            <a href="/orders/new.php">🛒 فاکتور جدید</a>
        </div>

        <!-- فاکتورها -->
        <div class="card">
            <a href="/orders/orders.php">🛍️ لیست فاکتورها</a>
        </div>

        <!-- محصولات -->
        <div class="card">
            <a href="/orders/product/">📦 محصولات</a>
        </div>

        <!-- برداشت -->
        <div class="card">
            <a href="/orders/payment/withdraw.php">💰 برداشت از حساب</a>
        </div>

        <!-- مانده حساب (فروشنده) -->
        <?php if($role === 'seller'): ?>
        <div class="card">
            <a href="/orders/finance/seller.php?username=<?=$_SESSION['username']?>">💳 مانده حساب من</a>
        </div>
        <?php endif; ?>

        <!-- مدیریت مالی (ادمین) -->
        <?php if($role === 'admin'): ?>
        <div class="card">
            <a href="/orders/finance/">📊 مدیریت مالی</a>
        </div>

        <div class="card">
            <a href="/orders/finance/seller.php">📈 سود / گزارش فروشنده‌ها</a>
        </div>

        <div class="card">
            <a href="/orders/payment/withdraw_list.php">💵 لیست برداشت‌ها</a>
        </div>

        <div class="card">
            <a href="/orders/buyer/dashboard.php">🛒 مدیریت خرید</a>
        </div>

        <div class="card">
            <a href="/orders/head/dashboard.php">🚚 مدیریت باربری/حمل</a>
        </div>
        <?php endif; ?>

    </div>

</div>

</body>
</html>
