<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'logistic' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id     = (int)($_POST['id'] ?? 0);
$reason = trim($_POST['failed_reason'] ?? '');

if ($id < 1 || $reason === '') {
    exit('bad data');
}

$status_note = "عدم تحویل: ".$reason;

// آپدیت سفارش
if ($role === 'admin') {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='failed', status_note=?
        WHERE id=? LIMIT 1
    ");
    $stmt->bind_param("si", $status_note, $id);
} else {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='failed', status_note=?
        WHERE id=? AND head_carrier_username=? LIMIT 1
    ");
    $stmt->bind_param("sis", $status_note, $id, $username);
}
$stmt->execute();

// نوتیفیکیشن
$info = $mysqli->query("SELECT username, customer_name FROM orders WHERE id=".$id." LIMIT 1")->fetch_assoc();
if ($info) {
    $seller   = $mysqli->real_escape_string($info['username'] ?? '');
    $customer = $mysqli->real_escape_string($info['customer_name'] ?? '');
    if ($seller !== '') {
        $msg = "سفارش مشتری $customer تحویل نشد. دلیل: $reason";
        $mysqli->query("
            INSERT INTO notifications (username, type, order_id, title, message, created_at)
            VALUES (
              '$seller',
              'status',
              $id,
              'عدم تحویل',
              '$msg',
              NOW()
            )
        ");
    }
}

header("Location: logistic_view.php?id=".$id);
exit;
