<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/header.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';
?>
<link rel="stylesheet" href="../assets/withdraw.css">

<div class="card sb-card">

  <h2>ثبت برداشت از حساب</h2>

  <form id="withdrawForm">

    <?php if ($role === 'admin'): ?>
      <label>انتخاب فروشنده</label>
      <select name="username" required>
        <option value="">انتخاب کنید…</option>
        <?php
        $q = $mysqli->query("SELECT username FROM users WHERE role='seller' ORDER BY username ASC");
        while ($u = $q->fetch_assoc()):
        ?>
          <option value="<?= htmlspecialchars($u['username']) ?>">
            <?= htmlspecialchars($u['username']) ?>
          </option>
        <?php endwhile; ?>
      </select>
    <?php else: ?>
      <input type="hidden" name="username" value="<?= htmlspecialchars($login_user) ?>">
      <div class="info-box">
        برداشت برای حساب: <strong><?= htmlspecialchars($login_user) ?></strong>
      </div>
    <?php endif; ?>

    <label>مبلغ برداشت (تومان)</label>
    <input type="number" name="amount" min="1000" step="1000" placeholder="مثال: 5000000" required>

    <label>روش برداشت</label>
    <select name="method">
      <option value="bank">واریز بانکی</option>
      <option value="cash">نقدی</option>
      <option value="wallet">انتقال از کیف پول</option>
    </select>

    <label>توضیحات (اختیاری)</label>
    <textarea name="note" rows="3" placeholder="مثال: تسویه کمیسیون هفته دوم"></textarea>

    <button type="submit" class="sb-btn-primary">ثبت برداشت</button>

  </form>

  <div id="result" class="result-box"></div>

</div>

<script>
document.getElementById('withdrawForm').addEventListener('submit', function(e){
    e.preventDefault();

    const formData = new FormData(this);

    fetch("withdraw_action.php", {
        method: "POST",
        body: formData,
        credentials: "include" // برای ارسال سشن
    })
    .then(res => res.text())
    .then(txt => {
        const r = document.getElementById('result');
        r.classList.remove('ok','err');

        if (txt === "OK") {
            r.classList.add('ok');
            r.innerText = "✔ برداشت ثبت شد";
            this.reset();
        }
        else if (txt === "balance_not_enough") {
            r.classList.add('err');
            r.innerText = "❌ موجودی کافی نیست!";
        }
        else if (txt === "seller_not_found") {
            r.classList.add('err');
            r.innerText = "❌ فروشنده پیدا نشد!";
        }
        else if (txt === "no_session") {
            r.classList.add('err');
            r.innerText = "❌ سشن یافت نشد! (خروج و ورود مجدد کنید)";
        }
        else if (txt === "forbidden") {
            r.classList.add('err');
            r.innerText = "❌ اجازه ثبت برداشت برای این کاربر را ندارید!";
        }
        else if (txt === "invalid_input") {
            r.classList.add('err');
            r.innerText = "❌ ورودی نامعتبر است!";
        }
        else if (txt === "db_error") {
            r.classList.add('err');
            r.innerText = "❌ خطای پایگاه داده!";
        }
        else {
            r.classList.add('err');
            r.innerText = "❌ خطای ناشناخته: " + txt;
        }
    })
    .catch(err => {
        const r = document.getElementById('result');
        r.classList.add('err');
        r.innerText = "❌ خطای ارتباط با سرور";
        console.error(err);
    });
});
</script>
