<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

if ($_SESSION['role'] !== 'admin') exit("Access denied");

if ($_POST) {

    if ($_POST['action'] === 'add') {
        $code  = trim($_POST['code']);
        $label = trim($_POST['label']);
        $chat  = trim($_POST['chat_id']);
        $token = trim($_POST['bot_token']);
        $sort  = (int)$_POST['sort_order'];

        $stmt = $mysqli->prepare("
            INSERT INTO telegram_channels (code, label, chat_id, bot_token, sort_order, is_active)
            VALUES (?,?,?,?,?,1)
        ");
        $stmt->bind_param("ssssi", $code, $label, $chat, $token, $sort);
        $stmt->execute();
    }

    if ($_POST['action'] === 'update') {
        foreach ($_POST['items'] as $id => $data) {
            $label   = trim($data['label']);
            $chat    = trim($data['chat_id']);
            $token   = trim($data['bot_token']);
            $sort    = (int)$data['sort'];
            $active  = isset($data['active']) ? 1 : 0;

            $stmt = $mysqli->prepare("
                UPDATE telegram_channels
                SET label=?, chat_id=?, bot_token=?, sort_order=?, is_active=?
                WHERE id=?
            ");
            $stmt->bind_param("sssiii", $label, $chat, $token, $sort, $active, $id);
            $stmt->execute();
        }
    }

    header("Location: telegram_channels.php");
    exit;
}

$res = $mysqli->query("SELECT * FROM telegram_channels ORDER BY sort_order ASC, id ASC");
$channels = $res->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>مدیریت کانال‌های تلگرام — SUPER PRO PLUS</title>
<link rel="stylesheet" href="../assets/style.css">
<style>
.table input[type=text], .table input[type=number] {width:100%;padding:6px;}
</style>
</head>
<body>
<div class="container">

<h2>مدیریت کانال‌های تلگرام — SUPER PRO PLUS</h2>

<form method="post">
<input type="hidden" name="action" value="update">

<table class="table">
<thead>
<tr>
<th>ID</th>
<th>کد</th>
<th>عنوان</th>
<th>Chat ID</th>
<th>Bot Token</th>
<th>فعال</th>
<th>اولویت</th>
</tr>
</thead>
<tbody>
<?php foreach ($channels as $ch): ?>
<tr>
<td><?=$ch['id']?></td>
<td><?=$ch['code']?></td>

<td><input type="text" name="items[<?=$ch['id']?>][label]" value="<?=$ch['label']?>"></td>
<td><input type="text" name="items[<?=$ch['id']?>][chat_id]" value="<?=$ch['chat_id']?>"></td>
<td><input type="text" name="items[<?=$ch['id']?>][bot_token]" value="<?=$ch['bot_token']?>"></td>
<td><input type="checkbox" name="items[<?=$ch['id']?>][active]" <?=$ch['is_active']?'checked':''?>></td>
<td><input type="number" name="items[<?=$ch['id']?>][sort]" value="<?=$ch['sort_order']?>"></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<button class="button" style="margin-top:10px;">ثبت تغییرات</button>
</form>

<hr>

<h3>افزودن کانال جدید</h3>

<form method="post">
<input type="hidden" name="action" value="add">

<div class="grid-4">
<label class="field">
<span>کد</span>
<input type="text" name="code" required>
</label>

<label class="field">
<span>عنوان</span>
<input type="text" name="label" required>
</label>

<label class="field">
<span>Chat ID</span>
<input type="text" name="chat_id" required>
</label>

<label class="field">
<span>Bot Token</span>
<input type="text" name="bot_token" required>
</label>

<label class="field">
<span>اولویت</span>
<input type="number" name="sort_order" value="0" required>
</label>
</div>

<button class="button">افزودن</button>
</form>

<hr>

<h3>ارسال پیام تست</h3>

<form action="test_send.php" method="post">
    <label class="field">
        <span>کد کانال (code)</span>
        <input type="text" name="code" required placeholder="مثال: t1 یا manager یا lg_center">
    </label>

    <button class="button" style="margin-top:10px;">ارسال تست</button>
</form>

</div>
</body>
</html>
