<?php
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';
require_once __DIR__.'/includes/jdf.php';

/* ============================================================
   دریافت ورودی به‌صورت هوشمند (حل مشکل مقدار "?" و شکایت)
   ============================================================ */

$code = trim($_GET['code'] ?? '');
$id   = trim($_GET['id'] ?? '');
$o    = null;

// اگر code نبود ولی id بود → استخراج tracking_code
if ($code === '' && $id !== '' && ctype_digit($id)) {
    $o = $mysqli->query("SELECT * FROM orders WHERE id=".(int)$id)->fetch_assoc();
    if ($o) {
        $code = $o['tracking_code'];
    }
}
if ($o && $o['tracking_code'] === null) $o['tracking_code'] = '';
if ($o && $o['customer_name'] === null) $o['customer_name'] = '';
if ($o && $o['mobile'] === null) $o['mobile'] = '';


// اگر code داریم → از روی tracking_code بکش
if ($code !== '') {
    $safe = $mysqli->real_escape_string($code);
    $o = $mysqli->query("SELECT * FROM orders WHERE tracking_code='{$safe}'")->fetch_assoc();
}

function nf($n){
    return number_format((int)$n,0,'.',',');
}

function toJalaliEn($datetime){
    if(!$datetime || !preg_match('/^\d{4}-\d{2}-\d{2}/',$datetime)) return '-';
    list($date,$time) = array_pad(explode(' ', trim($datetime)), 2, '');
    list($gy,$gm,$gd)=explode('-',$date);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    $j = strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
    $time = substr($time,0,5);
    return trim($j.($time ? ' - '.$time : ''));
}

// موبایل مشتری برای شکایت
$customerMobile = '';
if ($o) {
    if (!empty($o['customer_mobile'])) $customerMobile = $o['customer_mobile'];
    elseif (!empty($o['mobile']))      $customerMobile = $o['mobile'];
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport"
      content="width=device-width, initial-scale=1, maximum-scale=1,
      minimum-scale=1, viewport-fit=cover, user-scalable=no">
<title>پیگیری سفارش — سلام‌بابا</title>

<style>
/* --- فونت‌ها --- */
@font-face {
  font-family: 'IRANSansWeb';
  src: url('https://salambaba.co/font/IRANSansWeb.woff2') format('woff2'),
       url('https://salambaba.co/font/IRANSansWeb.woff') format('woff');
  font-weight: 400;
  font-style: normal;
  font-display: swap;
}
@font-face {
  font-family: 'IRANSansWeb';
  src: url('https://salambaba.co/font/IRANSansWeb_Bold.woff2') format('woff2'),
       url('https://salambaba.co/font/IRANSansWeb_Bold.woff') format('woff');
  font-weight: 700;
  font-style: normal;
  font-display: swap;
}

/* --- پایه UI --- */
*{box-sizing:border-box;}
body{
  margin:0;
  font-family:'IRANSansWeb';
  background:#f3f4f6;
  color:#0f172a;
}
.app-wrap{
  max-width:900px;margin:0 auto;padding:16px;
}

/* --- هدر --- */
.app-header{
  background:#0f172a;
  color:#fff;
  padding:14px 16px;
  border-radius:18px;
  display:flex;justify-content:space-between;align-items:center;
  margin-bottom:16px;
}
.app-header-left{display:flex;align-items:center;gap:10px;}
.app-logo-stripes{display:flex;gap:2px;}
.app-logo-stripes span{width:6px;height:22px;border-radius:6px;display:inline-block;}
.app-logo-stripes .b{background:#0ea5e9;}
.app-logo-stripes .g{background:#22c55e;}
.app-logo-stripes .y{background:#facc15;}
.app-logo-stripes .r{background:#ef4444;}
.app-logo-text{font-size:18px;font-weight:800;}
.app-header-right{font-size:12px;opacity:.9}

/* کارت‌ها */
.card{
  background:#fff;
  border-radius:18px;
  padding:16px 16px 14px;
  box-shadow:0 6px 18px rgba(15,23,42,.08);
  margin-bottom:14px;
}

/* وضعیت */
.status-chip{
  display:inline-flex;gap:6px;padding:6px 10px;
  border-radius:999px;background:#eff6ff;color:#1d4ed8;
  font-size:12px;font-weight:700;
}
.status-main-title{margin:0 0 8px;font-size:17px;font-weight:700;}
.status-note{
  margin-top:8px;background:#f9fafb;
  border-radius:12px;padding:10px;
  font-size:13px;color:#334155;border-right:3px solid #0ea5e9;
}

/* استپ‌ها */
.steps-pro{display:flex;justify-content:space-between;margin-top:14px;}
.step{width:25%;text-align:center;font-size:11px;color:#6b7280;}
.step-circle{
  width:26px;height:26px;border-radius:50%;border:2px solid #cbd5e1;
  margin:0 auto 4px;display:flex;align-items:center;justify-content:center;
  font-size:12px;font-weight:700;background:#fff;
}
.step.active .step-circle{background:#0ea5e9;border-color:#0ea5e9;color:#fff;}
.step.active .step-label{color:#0ea5e9;font-weight:700;}

/* تایم‌لاین */
.timeline{
  margin-top:10px;border-right:2px solid #e2e8f0;padding-right:14px;
}
.tl-item{position:relative;padding:8px 0 10px;}
.tl-dot{
  width:12px;height:12px;border-radius:50%;background:#0ea5e9;
  position:absolute;right:-20px;top:12px;
}
.tl-title{font-size:14px;font-weight:700;}
.tl-note{font-size:13px;margin-top:4px;color:#334155;}
.tl-date{font-size:12px;margin-top:4px;color:#64748b;}

/* اطلاعات */
.info-grid{
  display:grid;grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
  gap:10px;margin-top:6px;
}
.info-label{font-size:12px;color:#6b7280;}
.info-value{font-size:14px;font-weight:600;}

/* کد پیگیری */
.track-chip{
  margin-top:10px;display:flex;align-items:center;gap:8px;flex-wrap:wrap;
}
.track-chip .code{
  background:#0f172a;color:#e5e7eb;padding:4px 10px;
  border-radius:999px;font-size:13px;font-weight:700;
}
.track-chip button{
  border:none;background:#111827;color:#e5e7eb;
  border-radius:999px;padding:4px 8px;font-size:11px;cursor:pointer;
}

/* اقلام */
.table-wrap{overflow-x:auto;}
.table{width:100%;border-collapse:collapse;margin-top:6px;}
.table thead{background:#f9fafb;}
.table th,.table td{padding:8px 6px;font-size:13px;text-align:center;}
.table tbody tr:nth-child(even){background:#f9fafb;}

/* مالی */
.summary-grid{
  display:grid;grid-template-columns:repeat(auto-fit,minmax(140px,1fr));
  gap:10px;margin-top:8px;
}
.summary-box{
  border-radius:12px;padding:10px;background:#f9fafb;font-size:13px;
}
.summary-box strong{display:block;font-size:14px;margin-top:4px;}

/* شکایت */
.complaint-btn{
  width:100%;padding:12px;border-radius:999px;border:none;
  background:linear-gradient(135deg,#ef4444,#b91c1c);
  color:#fff;font-size:14px;font-weight:700;margin-top:8px;cursor:pointer;
}
.complaint-overlay{
  position:fixed;inset:0;background:rgba(15,23,42,.65);
  display:none;justify-content:center;align-items:center;
  z-index:9999;
}
.complaint-box{
  background:#fff;width:92%;max-width:420px;border-radius:20px;
  padding:18px 16px 16px;box-shadow:0 20px 40px rgba(15,23,42,.35);
}
.complaint-meta{font-size:12px;color:#6b7280;margin-bottom:10px;}
.complaint-box textarea{
  width:100%;height:120px;border-radius:12px;border:1px solid #e5e7eb;
  padding:8px;font-size:13px;
}
.complaint-actions{display:flex;gap:8px;margin-top:10px;}
.btn-cancel{background:#e5e7eb;color:#111827;}
.btn-send{background:#0ea5e9;color:#fff;}
</style>
</head>
<body>

<div class="app-wrap">

<!-- هدر -->
<div class="app-header">
  <div class="app-header-left">
    <div class="app-logo-stripes">
      <span class="b"></span><span class="g"></span><span class="y"></span><span class="r"></span>
    </div>
    <div class="app-logo-text">سلام‌بابا</div>
  </div>
  <div class="app-header-right">پیگیری وضعیت سفارش</div>
</div>

<?php if(!$o): ?>

<div class="card error-card">کد پیگیری واردشده معتبر نیست یا سفارشی یافت نشد.</div>

<?php else: ?>

<!-- وضعیت -->
<div class="card">
  <div class="status-chip">وضعیت فعلی</div>
  <h2 class="status-main-title"><?=htmlspecialchars($o['status'])?></h2>

  <?php if($o['status_note']): ?>
    <div class="status-note"><?=nl2br(htmlspecialchars($o['status_note']))?></div>
  <?php endif; ?>

  <?php
    $s = strtolower(trim($o["status"]));
    $st1=$st2=$st3=$st4="";
    if($s=="pending")        $st1="active";
    elseif($s=="processing") $st2="active";
    elseif($s=="on_delivery")$st3="active";
    elseif($s=="delivered")  $st4="active";
  ?>
  <div class="steps-pro">
    <div class="step <?=$st1?>">
      <div class="step-circle">1</div><div class="step-label">ثبت سفارش</div>
    </div>
    <div class="step <?=$st2?>">
      <div class="step-circle">2</div><div class="step-label">در حال پردازش</div>
    </div>
    <div class="step <?=$st3?>">
      <div class="step-circle">3</div><div class="step-label">در حال ارسال</div>
    </div>
    <div class="step <?=$st4?>">
      <div class="step-circle">4</div><div class="step-label">تحویل شده</div>
    </div>
  </div>

  <!-- تایم‌لاین -->
  <div class="timeline">
    <div class="tl-item">
      <div class="tl-dot"></div>
      <div class="tl-title"><?=htmlspecialchars($o['status'])?></div>
      <?php if($o['status_note']): ?>
        <div class="tl-note"><?=nl2br(htmlspecialchars($o['status_note']))?></div>
      <?php endif; ?>
      <div class="tl-date"><?=toJalaliEn($o['purchase_date'])?></div>
    </div>
  </div>
</div>

<!-- اطلاعات سفارش -->
<div class="card">
  <div class="info-grid">
    <div>
      <div class="info-label">شماره فاکتور</div>
      <div class="info-value"><?=htmlspecialchars($o['invoice_no'])?></div>
    </div>
    <div>
      <div class="info-label">نام مشتری</div>
      <div class="info-value"><?=htmlspecialchars($o['customer_name'])?></div>
    </div>
    <div>
      <div class="info-label">تاریخ ثبت سفارش</div>
      <div class="info-value"><?=toJalaliEn($o['purchase_date'])?></div>
    </div>
  </div>

  <div class="track-chip">
    <span class="info-label">کد پیگیری:</span>
    <span class="code"><?=htmlspecialchars($o['tracking_code'])?></span>
    <button onclick="navigator.clipboard.writeText('<?=htmlspecialchars($o['tracking_code'])?>')">کپی</button>
  </div>
</div>

<?php
$items = $mysqli->query("SELECT * FROM order_items WHERE order_id=".(int)$o['id']);
$hasItems = $items && $items->num_rows > 0;
?>

<?php if($hasItems): ?>
<!-- اقلام -->
<div class="card">
  <div style="font-size:14px;font-weight:700;margin-bottom:4px;">اقلام خریداری‌شده</div>

  <div class="table-wrap">
    <table class="table">
      <thead><tr><th>مدل</th><th>قیمت</th><th>بیعانه</th><th>مانده</th></tr></thead>
      <tbody>
      <?php
        $total_price=0;$total_deposit=0;$total_remaining=0;$models=[];
        while($it = $items->fetch_assoc()):
          $total_price += (int)$it['price'];
          $total_deposit += (int)$it['deposit'];
          $total_remaining += (int)$it['remaining'];
          if(trim($it['model'])) $models[] = trim($it['model']);
      ?>
        <tr>
          <td><?=htmlspecialchars($it['model'])?></td>
          <td><?=nf($it['price'])?> تومان</td>
          <td><?=nf($it['deposit'])?> تومان</td>
          <td><?=nf($it['remaining'])?> تومان</td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- خلاصه مالی -->
<div class="card">
  <div style="font-size:14px;font-weight:700;margin-bottom:4px;">خلاصه مالی</div>

  <div class="summary-grid">
    <div class="summary-box">
      مدل کالاها:
      <strong><?=count($models)? htmlspecialchars(implode('، ',$models)) : '-'?></strong>
    </div>
    <div class="summary-box">
      مجموع قیمت:
      <strong><?=nf($total_price)?> تومان</strong>
    </div>
    <div class="summary-box">
      مجموع بیعانه:
      <strong><?=nf($total_deposit)?> تومان</strong>
    </div>
    <div class="summary-box">
      مانده کل:
      <strong><?=nf($total_remaining)?> تومان</strong>
    </div>
  </div>
</div>
<?php endif; ?>

<?php endif; ?>

<!-- راهنما -->
<div class="card help-card">
  <div style="font-size:14px;font-weight:700;margin-bottom:4px;">نکات مهم تحویل و نصب</div>
  <ul>
    <li>قبل از تسویه، سلامت کامل کالا را چک کنید.</li>
    <li>پرداخت فقط از طریق واریز بانکی انجام می‌شود.</li>
    <li>نصب تلویزیون فقط توسط نصاب معتبر انجام شود.</li>
    <li>در صورت تأخیر، با فروشنده تماس بگیرید.</li>
  </ul>
  <a href="https://salambaba.co/help/terms-delivery" target="_blank" class="help-link">
    مشاهده شرایط کامل
  </a>
</div>

</div>

</body>
</html>
