<?php
// send.php — processes Form 1, sends to Telegram, returns JSON with tracking code.
header('Content-Type: application/json; charset=utf-8');

// --- SETTINGS (TEST) ---
// Token & chat_id based on user's supplied values.
$BOT_TOKEN = '490048283:AAGEC4Cj0c8SkIicNrMXl7QNDLC2rKK5LAs';
$CHAT_ID   = '-1003122605108'; // warranty channel

// --- Helpers ---
function tg_escape_md($s){
  $search = ['\\','_','*','[',']','(',')','~','`','>','#','+','-','=','|','{','}','.','!'];
  foreach($search as $ch) $s = str_replace($ch, '\\'.$ch, $s);
  return $s;
}
function gen_tracking($len=10){
  $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; // no 0/O/1/I
  $t='';
  for($i=0;$i<$len;$i++){ $t .= $chars[random_int(0, strlen($chars)-1)]; }
  return 'SBG'.date('y').$t; // brand + year + random mix
}
function clean($s){
  return htmlspecialchars(trim($s ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}
function save_upload($field){
  if(!isset($_FILES[$field]) || $_FILES[$field]['error'] !== UPLOAD_ERR_OK) return null;
  $dir = __DIR__ . '/uploads';
  if(!is_dir($dir)) mkdir($dir, 0775, true);
  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if(!in_array($ext, ['jpg','jpeg','png','webp','gif'])) $ext = 'jpg';
  $name = uniqid('u_',true).'.'.$ext;
  $dest = $dir.'/'.$name;
  if(move_uploaded_file($_FILES[$field]['tmp_name'], $dest)) return $dest;
  return null;
}
function send_media_group($token, $chat_id, $caption, $paths){
  $media = [];
  $files = [];
  $i=0;
  foreach($paths as $p){
    if(!$p) continue;
    $key = 'file'.$i;
    $media[] = ['type'=>'photo', 'media'=>'attach://'.$key];
    $files[$key] = new CURLFile($p);
    $i++;
  }
  if(empty($media)){
    // no media -> sendMessage
    $payload = ['chat_id'=>$chat_id,'text'=>$caption,'parse_mode'=>'MarkdownV2','disable_web_page_preview'=>true];
    $ch=curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch,[CURLOPT_POST=>true,CURLOPT_POSTFIELDS=>$payload,CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>20]);
    $res=curl_exec($ch); curl_close($ch); return $res;
  }
  $payload = ['chat_id'=>$chat_id,'media'=>json_encode($media, JSON_UNESCAPED_UNICODE)];
  $ch = curl_init("https://api.telegram.org/bot{$token}/sendMediaGroup");
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_TIMEOUT, 30);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $payload + $files);
  $res = curl_exec($ch);
  if(curl_errno($ch)){
    // fallback single
    foreach($files as $k=>$f){
      $ch2=curl_init("https://api.telegram.org/bot{$token}/sendPhoto");
      curl_setopt_array($ch2,[CURLOPT_POST=>true,CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>20,
        CURLOPT_POSTFIELDS=>['chat_id'=>$chat_id,'photo'=>$f,'caption'=>$caption,'parse_mode'=>'MarkdownV2']]);
      curl_exec($ch2); curl_close($ch2);
      $caption=null; // only first has caption
    }
  } else {
    curl_close($ch);
    // send a separate caption message (since media group shows caption on first photo only)
    $payload = ['chat_id'=>$chat_id,'text'=>$caption,'parse_mode'=>'MarkdownV2','disable_web_page_preview'=>true];
    $ch3=curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch3,[CURLOPT_POST=>true,CURLOPT_POSTFIELDS=>$payload,CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>20]);
    curl_exec($ch3); curl_close($ch3);
  }
  return true;
}

// --- Collect form data ---
$seller = clean($_POST['seller'] ?? '');
if($seller === 'سایر'){ $seller = clean($_POST['seller_other'] ?? 'سایر'); }
$customer_name = clean($_POST['customer_name'] ?? '');
$province = clean($_POST['province'] ?? '');
$address  = clean($_POST['address'] ?? '');
$mobile   = clean($_POST['mobile'] ?? '');
$phone    = clean($_POST['phone'] ?? '');
$model    = clean($_POST['model'] ?? '');
$warranty = clean($_POST['warranty'] ?? '');
$notes    = clean($_POST['notes'] ?? '');
$purchase_jalali = clean($_POST['purchase_jalali'] ?? '');
$purchase_greg   = clean($_POST['purchase_gregorian'] ?? '');

$items = $_POST['items'] ?? [];
if(!is_array($items)) $items = [];
$items = array_map(fn($x)=>clean($x), $items);
if(in_array('سایر', $items)){ $items = array_diff($items, ['سایر']); $items[] = 'سایر:'.clean($_POST['item_other'] ?? ''); }

// Basic validation
if($customer_name==='' || $province==='' || $address==='' || $mobile==='' || $model===''){
  http_response_code(422);
  echo json_encode(['success'=>false,'error':'فیلدهای لازم پر نشده‌اند.']); exit;
}

// Save uploads
$p1 = save_upload('photo1');
$p2 = save_upload('photo2');
$p3 = save_upload('photo3');

// Generate tracking code
$tracking = gen_tracking();

// Build caption
$lines = [];
$lines[] = "*فرم جدید درخواست نصب*";
$lines[] = "*کد رهگیری:* " . tg_escape_md($tracking);
$lines[] = "*فروشنده:* " . tg_escape_md($seller);
$lines[] = "*مشتری:* " . tg_escape_md($customer_name);
$lines[] = "*استان:* " . tg_escape_md($province);
$lines[] = "*آدرس:* " . tg_escape_md($address);
$lines[] = "*همراه:* " . tg_escape_md($mobile) . ($phone ? "  |  *ثابت:* ".tg_escape_md($phone) : "");
$lines[] = "*کالا:* " . tg_escape_md(implode('، ', $items));
$lines[] = "*مدل:* " . tg_escape_md($model);
if($warranty!=='') $lines[] = "*گارانتی:* " . tg_escape_md($warranty);
if($purchase_jalali!=='') $lines[] = "*تاریخ خرید (شمسی):* " . tg_escape_md($purchase_jalali);
if($notes!=='') $lines[] = "*توضیحات فروشنده:* " . tg_escape_md($notes);
$lines[] = "_ارسال از فرم: salambaba.co/guaranti در " . date('Y-m-d H:i') . "_";
$caption = implode("\n", $lines);

// Send to Telegram
$media_paths = array_values(array_filter([$p1,$p2,$p3]));
send_media_group($BOT_TOKEN, $CHAT_ID, $caption, $media_paths);

// Response
echo json_encode(['success'=>true,'tracking'=>$tracking]);
