<?php
require_once __DIR__.'/config.php';

function sb_escape($s){ return htmlspecialchars(trim($s ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/**
 * Save request (Form 1) to DB
 * @param array $data
 * @return bool
 */
function sb_save_request($data){
    $db = sb_db_connect();
    $sql = "INSERT INTO guarantee_requests
        (tracking_code, seller, customer_name, province, address, mobile, phone, model, warranty, purchase_date, notes)
        VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    $stmt = $db->prepare($sql);
    if(!$stmt){ error_log('save_request prepare failed: '.$db->error); return false; }
    $tracking = $data['tracking_code'] ?? '';
    $seller   = $data['seller'] ?? '';
    $customer = $data['customer_name'] ?? '';
    $province = $data['province'] ?? '';
    $address  = $data['address'] ?? '';
    $mobile   = $data['mobile'] ?? '';
    $phone    = $data['phone'] ?? null;
    $model    = $data['model'] ?? '';
    $warranty = $data['warranty'] ?? null;
    $purchase = $data['purchase_date'] ?? null;
    $notes    = $data['notes'] ?? null;
    $stmt->bind_param('sssssssssss',
        $tracking, $seller, $customer, $province, $address, $mobile, $phone, $model, $warranty, $purchase, $notes
    );
    $ok = $stmt->execute();
    if(!$ok){ error_log('save_request exec failed: '.$stmt->error); }
    $stmt->close(); $db->close();
    return $ok;
}

/**
 * Save installation (Form 2) to DB
 * @param array $data
 * @return bool
 */
function sb_save_install($data){
    $db = sb_db_connect();
    $sql = "INSERT INTO installations
        (tracking_code, installer_name, install_date, serial_number, notes)
        VALUES (?,?,?,?,?)";
    $stmt = $db->prepare($sql);
    if(!$stmt){ error_log('save_install prepare failed: '.$db->error); return false; }
    $tracking = $data['tracking_code'] ?? '';
    $installer= $data['installer_name'] ?? '';
    $date     = $data['install_date'] ?? '';
    $serial   = $data['serial_number'] ?? '';
    $notes    = $data['notes'] ?? null;
    $stmt->bind_param('sssss', $tracking, $installer, $date, $serial, $notes);
    $ok = $stmt->execute();
    if(!$ok){ error_log('save_install exec failed: '.$stmt->error); }
    $stmt->close(); $db->close();
    return $ok;
}
?>
