<?php
// admin.php - پنل مدیریت گارانتی (نسخه‌ی ساده و امن)
// قرار بده در /guaranti/admin.php
// نیازمند: assets/admin-style.css و اتصال به دیتابیس slmbredirects_guaranti

session_start();
error_reporting(0);
ini_set('display_errors', 0);
header('Content-Type: text/html; charset=utf-8');

// === تنظیمات دیتابیس - از قبل تعیین‌شده توسط تو ===
define('DB_HOST','localhost');
define('DB_NAME','slmbredirects_guaranti');
define('DB_USER','slmbredirects_guaranti');
define('DB_PASS','Reza1372!@');

// === رمز ورود (SHA256) ===
// رمز خامی که خواستی: SanaAdmin1372
// هشِ SHA256ِ "SanaAdmin1372" آمده اینجا (مخفی‌شده به صورت هش):
$ADMIN_HASH = 'f220a5e646b5728ee419ac7560cfc3b1cae0ba18e7bc29160c421d4add339655'; 
// اگر خواستی هش را عوض کنم با bcrypt بزنم، بگو؛ فعلاً SHA256 ثابت گذاشتم.

// توجه: برای امنیت بیشتر در Production از HTTPS و bcrypt استفاده کن.

// تابع اتصال DB
function db() {
    static $m = null;
    if ($m === null) {
        $m = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if ($m->connect_errno) {
            die("<div style='padding:20px;color:#a00'>خطا در اتصال به دیتابیس: {$m->connect_error}</div>");
        }
        $m->set_charset('utf8mb4');
    }
    return $m;
}

// لاگین
$action = $_GET['action'] ?? '';
if ($action === 'logout') {
    session_destroy();
    header('Location: admin.php');
    exit;
}
if (isset($_POST['password'])) {
    $p = trim($_POST['password']);
    $h = hash('sha256', $p);
    if (hash_equals($h, $ADMIN_HASH)) {
        $_SESSION['admin_logged'] = true;
        // regenerate id
        session_regenerate_id(true);
        header('Location: admin.php');
        exit;
    } else {
        $login_error = "رمز اشتباه است.";
    }
}

// اگر درخواست export باشه - CSV خروجی بده
if (isset($_GET['export']) && !empty($_SESSION['admin_logged'])) {
    $type = $_GET['export'];
    $db = db();
    if ($type === 'requests') {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="guarantee_requests.csv"');
        $out = fopen('php://output','w');
        fputs($out, "\xEF\xBB\xBF"); // UTF-8 BOM
        fputcsv($out, ['id','tracking_code','seller','customer_name','province','mobile','model','created_at']);
        $q = $db->query("SELECT id,tracking_code,seller,customer_name,province,mobile,model,created_at FROM guarantee_requests ORDER BY id DESC");
        while($r = $q->fetch_assoc()) fputcsv($out, $r);
        fclose($out); exit;
    } elseif ($type === 'installs') {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="installations.csv"');
        $out = fopen('php://output','w');
        fputs($out, "\xEF\xBB\xBF");
        fputcsv($out, ['id','tracking_code','installer_name','install_date','serial_number','photo_path','notes','created_at']);
        $q = $db->query("SELECT id,tracking_code,installer_name,install_date,serial_number,photo_path,notes,created_at FROM installations ORDER BY id DESC");
        while($r = $q->fetch_assoc()) fputcsv($out, $r);
        fclose($out); exit;
    }
}

// اگر لاگین نشده نمایش صفحه لاگین
if (empty($_SESSION['admin_logged'])) {
    ?>
    <!doctype html>
    <html lang="fa">
    <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width,initial-scale=1">
      <title>ورود مدیریت گارانتی</title>
      <link rel="stylesheet" href="assets/admin-style.css">
      <style>
        .login-box{max-width:420px;margin:80px auto;padding:20px;background:#fff;border-radius:12px;box-shadow:0 8px 30px rgba(2,6,23,.06)}
        .login-box h2{margin:0 0 10px;font-size:20px}
        .note{color:#666;margin-bottom:12px}
      </style>
    </head>
    <body>
    <div class="container">
      <div class="login-box">
        <h2>ورود مدیر | سانا صنعت</h2>
        <div class="note">رمز ورود را وارد کنید.</div>
        <?php if(!empty($login_error)) echo "<div class='error'>{$login_error}</div>"; ?>
        <form method="post" action="admin.php">
          <input type="password" name="password" placeholder="رمز مدیریت" style="width:100%;padding:10px;margin-bottom:10px;border-radius:8px;border:1px solid #ddd">
          <button type="submit" class="button">ورود</button>
        </form>
      </div>
    </div>
    </body>
    </html>
    <?php
    exit;
}

// === Admin area ===
$db = db();
$q = trim($_GET['q'] ?? '');
$type = $_GET['t'] ?? 'requests'; // requests | installs
$limit = 200;

// آمار
$totReq = $db->query("SELECT COUNT(*) AS c FROM guarantee_requests")->fetch_assoc()['c'] ?? 0;
$totInst = $db->query("SELECT COUNT(*) AS c FROM installations")->fetch_assoc()['c'] ?? 0;
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>پنل مدیریت گارانتی | سانا صنعت</title>
  <link rel="stylesheet" href="assets/admin-style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="bar"></div>
    <h1>پنل مدیریت گارانتی — سانا صنعت</h1>
    <div style="margin-top:8px">
      <a class="button" href="admin.php?action=logout">خروج</a>
      <a class="button ghost" href="admin.php?export=requests">خروجی درخواست‌ها (CSV)</a>
      <a class="button ghost" href="admin.php?export=installs">خروجی نصب‌ها (CSV)</a>
    </div>
  </div>

  <div style="display:flex;gap:12px;margin:14px 0;align-items:center">
    <div class="card" style="padding:12px">
      <div style="font-size:14px;color:#64748b">درخواست‌ها</div>
      <div style="font-size:24px;font-weight:700"><?php echo (int)$totReq; ?></div>
    </div>
    <div class="card" style="padding:12px">
      <div style="font-size:14px;color:#64748b">نصب‌ها</div>
      <div style="font-size:24px;font-weight:700"><?php echo (int)$totInst; ?></div>
    </div>

    <form style="margin-left:auto;display:flex;gap:8px" method="get" action="admin.php">
      <input type="hidden" name="t" value="<?php echo htmlspecialchars($type,ENT_QUOTES) ?>">
      <input type="text" name="q" value="<?php echo htmlspecialchars($q,ENT_QUOTES) ?>" placeholder="جستجو (کد، نام، مدل، فروشنده)" style="padding:8px;border-radius:8px;border:1px solid #e5e7eb">
      <button class="button" type="submit">جستجو</button>
    </form>
  </div>

  <div class="tabs" style="margin-bottom:12px">
    <a class="tab <?php echo $type==='requests'?'active':'' ?>" href="admin.php?t=requests">درخواست‌های نصب</a>
    <a class="tab <?php echo $type==='installs'?'active':'' ?>" href="admin.php?t=installs">نصب‌های انجام‌شده</a>
  </div>

  <div class="card">
    <?php if($type === 'installs'): 
        // installs list
        $sql = "SELECT i.id,i.tracking_code,i.installer_name,i.install_date,i.serial_number,i.photo_path,i.notes,i.created_at, r.customer_name, r.model
                FROM installations i
                LEFT JOIN guarantee_requests r ON r.tracking_code = i.tracking_code
                WHERE 1 ";
        $params = [];
        if($q!==''){
            $sql .= " AND (i.tracking_code LIKE ? OR i.installer_name LIKE ? OR r.customer_name LIKE ? OR i.serial_number LIKE ? OR r.model LIKE ?) ";
            $like = "%{$q}%";
            $params = [$like,$like,$like,$like,$like];
        }
        $sql .= " ORDER BY i.id DESC LIMIT {$limit}";
        $stmt = $db->prepare($sql);
        if($params) $stmt->bind_param(str_repeat('s',count($params)), ...$params);
        $stmt->execute();
        $res = $stmt->get_result();
    ?>
      <table>
        <thead><tr><th>#</th><th>کد</th><th>مشتری</th><th>سرویس‌کار</th><th>تاریخ نصب</th><th>سریال</th><th>مدل</th><th>عکس</th><th>ثبت‌شده</th></tr></thead>
        <tbody>
        <?php while($r = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo (int)$r['id'] ?></td>
            <td><code><?php echo htmlspecialchars($r['tracking_code']) ?></code></td>
            <td><?php echo htmlspecialchars($r['customer_name']) ?></td>
            <td><?php echo htmlspecialchars($r['installer_name']) ?></td>
            <td><?php echo htmlspecialchars($r['install_date']) ?></td>
            <td><?php echo htmlspecialchars($r['serial_number']) ?></td>
            <td><?php echo htmlspecialchars($r['model']) ?></td>
            <td><?php if($r['photo_path']): ?><a target="_blank" href="<?php echo htmlspecialchars($r['photo_path']); ?>">مشاهده</a><?php endif;?></td>
            <td><?php echo htmlspecialchars($r['created_at']) ?></td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    <?php else:
        // requests list
        $sql = "SELECT id,tracking_code,seller,customer_name,province,mobile,model,created_at FROM guarantee_requests WHERE 1 ";
        $params = [];
        if($q!==''){
            $sql .= " AND (tracking_code LIKE ? OR seller LIKE ? OR customer_name LIKE ? OR province LIKE ? OR mobile LIKE ? OR model LIKE ?) ";
            $like = "%{$q}%";
            $params = [$like,$like,$like,$like,$like,$like];
        }
        $sql .= " ORDER BY id DESC LIMIT {$limit}";
        $stmt = $db->prepare($sql);
        if($params) $stmt->bind_param(str_repeat('s',count($params)), ...$params);
        $stmt->execute();
        $res = $stmt->get_result();
    ?>
      <table>
        <thead><tr><th>#</th><th>کد</th><th>فروشنده</th><th>مشتری</th><th>استان</th><th>همراه</th><th>مدل</th><th>ثبت‌شده</th></tr></thead>
        <tbody>
        <?php while($r = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo (int)$r['id'] ?></td>
            <td><code><?php echo htmlspecialchars($r['tracking_code']) ?></code></td>
            <td><?php echo htmlspecialchars($r['seller']) ?></td>
            <td><?php echo htmlspecialchars($r['customer_name']) ?></td>
            <td><?php echo htmlspecialchars($r['province']) ?></td>
            <td><?php echo htmlspecialchars($r['mobile']) ?></td>
            <td><?php echo htmlspecialchars($r['model']) ?></td>
            <td><?php echo htmlspecialchars($r['created_at']) ?></td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>

</div>
</body>
</html>
