<?php
// admin/index.php
require __DIR__.'/config.php';
if (empty($_SESSION['auth'])) { header('Location: login.php'); exit; }

$json = file_exists($data_file) ? file_get_contents($data_file) : '{}';
$data = json_decode($json, true) ?: ['sections'=>[]];

$sections = $data['sections'] ?? [];
?>
<!doctype html><html lang="fa" dir="rtl"><meta charset="utf-8">
<title>مدیریت راهنما - سلام بابا</title>
<link rel="stylesheet" href="assets/admin.css">
<script defer src="assets/admin.js"></script>
<body>
<div class="wrap">
  <div class="card">
    <div class="topbar">
      <h1>مدیریت راهنمای تحویل و پرداخت</h1>
      <div>
        <a class="badge" href="../public/index.php" target="_blank">مشاهده سایت</a>
        <a class="badge" href="logout.php">خروج</a>
      </div>
    </div>

    <form method="post" action="save.php">
      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token(), ENT_QUOTES,'UTF-8'); ?>">
      <div class="row">
        <div>
          <label>عنوان سایت
            <input type="text" name="site_title" value="<?php echo htmlspecialchars($data['site_title'] ?? '', ENT_QUOTES,'UTF-8'); ?>" required>
          </label>
          <div class="notice">برای هر بخش می‌توانید HTML کامل قرار دهید (لیست‌ها، پاراگراف‌ها، لینک‌ها). محتوا مستقیماً در صفحه نمایش داده می‌شود.</div>
          <h2>افزودن بخش جدید</h2>
          <label>شناسه (لاتین و یکتا - برای آدرس)
            <input type="text" name="new[id]" placeholder="مثال: delivery">
          </label>
          <label>عنوان
            <input type="text" name="new[title]" placeholder="مثال: 🚚 تحویل">
          </label>
          <label>باز باشد؟
            <select name="new[open]">
              <option value="0">خیر</option>
              <option value="1">بله</option>
            </select>
          </label>
          <label>محتوا (HTML)
            <textarea name="new[content_html]" placeholder="<p>متن...</p>"></textarea>
          </label>
          <button type="submit" name="action" value="add">افزودن بخش</button>
        </div>
        <div>
          <h2>بخش‌های موجود</h2>
          <table class="table">
            <thead><tr><th>#</th><th>شناسه</th><th>عنوان</th><th>باز؟</th><th>اقدامات</th></tr></thead>
            <tbody>
              <?php foreach ($sections as $i=>$sec): ?>
                <tr>
                  <td><?php echo $i+1; ?></td>
                  <td><?php echo htmlspecialchars($sec['id'], ENT_QUOTES,'UTF-8'); ?></td>
                  <td><?php echo htmlspecialchars($sec['title'], ENT_QUOTES,'UTF-8'); ?></td>
                  <td><?php echo !empty($sec['open']) ? 'بله' : 'خیر'; ?></td>
                  <td class="actions">
                    <a class="badge" href="index.php?edit=<?php echo urlencode($sec['id']); ?>">ویرایش</a>
                    <form method="post" action="save.php" style="display:inline">
                      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token(), ENT_QUOTES,'UTF-8'); ?>">
                      <input type="hidden" name="id" value="<?php echo htmlspecialchars($sec['id'], ENT_QUOTES,'UTF-8'); ?>">
                      <button class="delete" data-action="delete" type="submit" name="action" value="delete">حذف</button>
                    </form>
                    <form method="post" action="save.php" style="display:inline">
                      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token(), ENT_QUOTES,'UTF-8'); ?>">
                      <input type="hidden" name="id" value="<?php echo htmlspecialchars($sec['id'], ENT_QUOTES,'UTF-8'); ?>">
                      <button type="submit" name="action" value="up">بالا</button>
                    </form>
                    <form method="post" action="save.php" style="display:inline">
                      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token(), ENT_QUOTES,'UTF-8'); ?>">
                      <input type="hidden" name="id" value="<?php echo htmlspecialchars($sec['id'], ENT_QUOTES,'UTF-8'); ?>">
                      <button type="submit" name="action" value="down">پایین</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
      <button type="submit" name="action" value="save-all">ذخیره عنوان سایت</button>
    </form>
  </div>

  <?php if (!empty($_GET['edit'])):
      $id = $_GET['edit'];
      $sec = null;
      foreach ($sections as $s) if ($s['id']===$id) { $sec=$s; break; }
      if ($sec): ?>
  <div class="card">
    <h2>ویرایش بخش: <?php echo htmlspecialchars($sec['title'], ENT_QUOTES,'UTF-8'); ?></h2>
    <form method="post" action="save.php">
      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token(), ENT_QUOTES,'UTF-8'); ?>">
      <input type="hidden" name="id" value="<?php echo htmlspecialchars($sec['id'], ENT_QUOTES,'UTF-8'); ?>">
      <label>عنوان
        <input type="text" name="title" value="<?php echo htmlspecialchars($sec['title'], ENT_QUOTES,'UTF-8'); ?>" required>
      </label>
      <label>باز باشد؟
        <select name="open">
          <option value="0" <?php echo empty($sec['open'])?'selected':''; ?>>خیر</option>
          <option value="1" <?php echo !empty($sec['open'])?'selected':''; ?>>بله</option>
        </select>
      </label>
      <label>محتوا (HTML)
        <textarea name="content_html"><?php echo htmlspecialchars($sec['content_html'], ENT_QUOTES,'UTF-8'); ?></textarea>
      </label>
      <button type="submit" name="action" value="update">ذخیره تغییرات</button>
    </form>
  </div>
  <?php endif; endif; ?>
</div>
</body></html>
