<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
$DATA = __DIR__ . '/data/tips.json';
if (!($_SESSION['logged_in'] ?? false)) { http_response_code(403); exit('Forbidden'); }
if (!isset($_POST['csrf']) || $_POST['csrf'] !== ($_SESSION['csrf'] ?? '')) { http_response_code(403); exit('CSRF'); }
$action = $_POST['action'] ?? ''; $id = (int)($_POST['id'] ?? 0);
function read_data($f){ return is_readable($f) ? (json_decode(file_get_contents($f), true) ?: []) : []; }
function write_data($f,$arr){ $tmp=$f.'.tmp'; $ok=file_put_contents($tmp, json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); if(!$ok) return false; return rename($tmp,$f); }
$tips = read_data($DATA);
if ($action==='delete' && $id>0){ $tips = array_values(array_filter($tips,function($t) use($id){ return (int)$t['id']!==$id; })); write_data($DATA,$tips); header('Location: admin.php'); exit; }
if ($action==='load' && $id>0){ foreach($tips as $t){ if((int)$t['id']===$id){ $_SESSION['edit_item']=$t; break; } } header('Location: admin.php'); exit; }
if ($action==='upsert'){
  $title=trim($_POST['title']??''); $desc=trim($_POST['desc']??''); $tag=trim($_POST['tag']??'سلام‌بابا');
  $visible=(int)($_POST['visible']??1); $sort_order=(int)($_POST['sort_order']??$id);
  $bullets_raw=trim($_POST['bullets']??''); $bullets=$bullets_raw?preg_split('/
?
/',$bullets_raw):[];
  $item=['id'=>$id,'title'=>$title,'bullets'=>$bullets,'desc'=>$desc,'tag'=>$tag,'visible'=>$visible,'sort_order'=>$sort_order];
  $found=false; foreach($tips as &$t){ if((int)$t['id']===$id){ $t=$item; $found=true; break; } } if(!$found){ $tips[]=$item; }
  usort($tips,function($a,$b){ return ($a['sort_order']??$a['id']) <=> ($b['sort_order']??$b['id']); });
  if(!write_data($DATA,$tips)){ http_response_code(500); exit('خطا در ذخیره فایل'); }
  header('Location: admin.php'); exit;
}
header('Location: admin.php'); exit;