<?php
require __DIR__ . '/../includes/db_connect.php';
$mysqli->set_charset('utf8mb4');

$q = trim($_GET['q'] ?? '');
$q = $mysqli->real_escape_string($q);

$sql = "
    SELECT id, brand, model, category, default_price, product_name_fa
    FROM products
    WHERE model LIKE '%{$q}%'
       OR product_name_fa LIKE '%{$q}%'
    ORDER BY product_name_fa
    LIMIT 20
";
$res = $mysqli->query($sql);

$data = [];
while ($r = $res->fetch_assoc()) {

    // متن زیبا برای select2
    $text = $r['product_name_fa']
        ? $r['product_name_fa']
        : ($r['brand'] . ' ' . $r['model']);

    $data[] = [
        'id'       => (int)$r['id'],
        'brand'    => $r['brand'],
        'model'    => $r['model'],
        'category' => $r['category'],
        'price'    => (int)$r['default_price'],
        'name_fa'  => $r['product_name_fa'],
        'text'     => $text
    ];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($data, JSON_UNESCAPED_UNICODE);
