<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require_once __DIR__.'/../includes/jdf.php';

$role = $_SESSION['role'] ?? '';
if ($role !== 'admin') {
    header('Location: seller.php');
    exit;
}

function nf($n){ return number_format((int)$n,0,'.',','); }

if (!function_exists('toJalaliEn')) {
    function toJalaliEn($date){
        if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
        list($gy,$gm,$gd)=explode('-',substr($date,0,10));
        return gregorian_to_jalali($gy,$gm,$gd,'/');
    }
}

/* --------------------------
   فیلتر فروشنده و ماه شمسی
-------------------------- */

$filterSeller = trim($_GET['seller'] ?? '');
$filterMonthJ = trim($_GET['month'] ?? ''); // مثال: 1404/10

$applyMonth = false;
$monthStart = null;
$monthEnd   = null;

if ($filterMonthJ !== '' && preg_match('/^\d{4}\/\d{2}$/', $filterMonthJ)) {
    $applyMonth = true;
    list($jy,$jm) = explode('/', $filterMonthJ);
    list($gy,$gm,$gd) = jalali_to_gregorian($jy,$jm,1);
    $monthStart = sprintf("%04d-%02d-01 00:00:00",$gy,$gm);
    $monthEnd   = date('Y-m-t 23:59:59',strtotime($monthStart));
}

/* --------------------------
   آمار کلی سیستم
-------------------------- */

$summaryRes = $mysqli->query("
    SELECT 
      (SELECT COALESCE(SUM(total_deposit),0) FROM orders) AS all_deposit,
      (SELECT COALESCE(SUM(w.amount),0)
       FROM withdrawals w
       JOIN orders o ON o.id=w.order_id
      ) AS all_withdraw
");
$summary = $summaryRes->fetch_assoc();
$allDeposit = (int)$summary['all_deposit'];
$allWithdraw = (int)$summary['all_withdraw'];
$allBalance = $allDeposit - $allWithdraw;

/* --------------------------
   لیست فروشنده‌ها
-------------------------- */
$sellersList = $mysqli->query("SELECT username, full_name FROM users WHERE role='seller' ORDER BY full_name");

/* --------------------------
   جدول فروشنده‌ها (به همراه فیلترها)
-------------------------- */

$sql = "
  SELECT 
    u.username,
    u.full_name,
    u.balance,
    (SELECT COALESCE(SUM(total_deposit),0)
       FROM orders 
      WHERE username = u.username
";

if ($applyMonth) $sql .= " AND created_at BETWEEN '$monthStart' AND '$monthEnd' ";

$sql .= ") AS month_deposit,

    (SELECT COALESCE(SUM(w.amount),0)
       FROM withdrawals w
       JOIN orders o ON o.id=w.order_id
      WHERE o.username = u.username
";

if ($applyMonth) $sql .= " AND o.created_at BETWEEN '$monthStart' AND '$monthEnd' ";

$sql .= "
    ) AS month_withdraw
  FROM users u
  WHERE u.role='seller'
";

if ($filterSeller !== '') {
    $safe = $mysqli->real_escape_string($filterSeller);
    $sql .= " AND u.username='$safe' ";
}

$sql .= " ORDER BY u.full_name ASC";

$sellersRes = $mysqli->query($sql);

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>📊 داشبورد مالی مدیر | سلام‌بابا</title>
<link rel="stylesheet" href="../assets/style.css">

<!-- Persian Datepicker -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-date/dist/persian-date.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

<style>
/* ظاهر شیک */
body{font-family:'IRANSansWeb','Tahoma';background:#f3f4f6;margin:0;}
.container{max-width:1200px;margin:auto;padding:20px;}
.card{
  background:#fff;border-radius:16px;padding:22px;
  box-shadow:0 2px 10px rgba(0,0,0,0.08);margin-bottom:20px;
}
.card h3{margin:0 0 12px;font-size:18px;}
.stats{display:flex; flex-wrap:wrap; gap:12px;margin-top:10px;}
.stat{flex:1 1 200px;background:#f9fafb;border:1px solid #e5e7eb;padding:14px;border-radius:14px;}
.stat span{font-size:12px;color:#6b7280;}
.stat b{font-size:16px;margin-top:4px;display:block;}

.table-wrapper{overflow-x:auto;margin-top:14px;}
table{width:100%; border-collapse:collapse;font-size:13px;min-width:850px;}
th,td{padding:8px 10px;text-align:center;border-bottom:1px solid #f1f5f9;}
th{background:#f8fafc;position:sticky;top:0;}
tr:nth-child(even) td{background:#f9fafb;}
.badge{padding:2px 8px;border-radius:999px;font-size:11px;}
.badge.pos{background:#dcfce7;color:#166534;}
.badge.neg{background:#fee2e2;color:#b91c1c;}

.filter-box{display:flex;gap:10px;flex-wrap:wrap;margin-top:10px;}
select,input{padding:7px 9px;border-radius:10px;border:1px solid #d1d5db;font-size:13px;}
button{padding:7px 14px;border:0;border-radius:10px;background:#0ea5e9;color:#fff;cursor:pointer;}
button:hover{background:#0284c7;}
body {
  font-family: 'IRANSansWeb','IRANYekan',sans-serif;
  background:#f3f4f6;
  margin:0;
  color:#0f172a;
}
.container {
  max-width:1200px;
  margin:0 auto;
  padding:20px;
}
.card {
  background:#fff;
  border-radius:16px;
  box-shadow:0 2px 10px rgba(15,23,42,0.08);
  padding:20px 24px;
  margin-bottom:20px;
}
.card h3 {
  margin:0 0 12px;
  font-size:18px;
  display:flex;
  align-items:center;
  gap:6px;
}
.stats {
  display:flex;
  flex-wrap:wrap;
  gap:12px;
  margin-top:10px;
}
.stat {
  flex:1 1 200px;
  background:linear-gradient(135deg,#eff6ff,#ffffff);
  border-radius:14px;
  padding:14px 16px;
  border:1px solid #e5e7eb;
}
.stat span {
  display:block;
  font-size:13px;
  color:#6b7280;
}
.stat b {
  display:block;
  margin-top:4px;
  font-size:18px;
}
.stat.deposit b { color:#0ea5e9; }
.stat.withdraw b { color:#f97316; }
.stat.balance b { color:#22c55e; }

.filter-row {
  display:flex;
  flex-wrap:wrap;
  gap:10px;
  align-items:center;
  margin-top:10px;
}
.filter-row label {
  font-size:13px;
  color:#374151;
}
.filter-row input[type="month"],
.filter-row input[type="text"] {
  padding:6px 10px;
  border-radius:8px;
  border:1px solid #d1d5db;
  font-size:13px;
}
.filter-row button {
  background:#2563eb;
  color:#fff;
  border:none;
  border-radius:8px;
  padding:7px 14px;
  cursor:pointer;
  font-size:13px;
}
.filter-row button:hover { background:#1d4ed8; }

.table-wrapper {
  margin-top:12px;
  background:#fff;
  border-radius:12px;
  border:1px solid #e5e7eb;
  overflow-x:auto;
}
table {
  width:100%;
  border-collapse:collapse;
  min-width:800px;
  font-size:13px;
}
th,td {
  padding:8px 10px;
  text-align:center;
  border-bottom:1px solid #f1f5f9;
  white-space:nowrap;
}
th {
  background:#f9fafb;
  font-weight:600;
  color:#111827;
  position:sticky;
  top:0;
  z-index:1;
}
tr:nth-child(even) td { background:#f9fafb; }
tr:hover td { background:#eff6ff; }

.badge {
  display:inline-block;
  padding:2px 8px;
  border-radius:999px;
  font-size:11px;
}
.badge.pos { background:#dcfce7; color:#166534; }
.badge.neg { background:#fee2e2; color:#b91c1c; }

.btn {
  background:#2563eb;
  color:#fff;
  padding:4px 10px;
  border-radius:8px;
  font-size:12px;
  text-decoration:none;
  display:inline-block;
}
.btn:hover { background:#1d4ed8; }
.btn.ghost {
  background:#f3f4f6;
  color:#111827;
}
.btn.ghost:hover { background:#e5e7eb; }

@media (max-width:768px){
  .container { padding:10px; }
  table { font-size:12px; }
  th,td { padding:6px 8px; }
}
</style>
</head>

<body>
<div class="container">

<?php require __DIR__.'/../includes/header.php'; ?>

<section class="card">
  <h3>📊 داشبورد مالی مدیر</h3>

  <div class="stats">
    <div class="stat"><span>کل بیعانه‌ها</span><b><?=nf($allDeposit)?> تومان</b></div>
    <div class="stat"><span>کل برداشت‌ها</span><b><?=nf($allWithdraw)?></b></div>
    <div class="stat"><span>مانده تجمعی</span><b><?=nf($allBalance)?></b></div>
  </div>

  <form method="get" class="filter-box">

    <label>فروشنده:</label>
    <select name="seller">
      <option value="">همه فروشنده‌ها</option>
      <?php while($s = $sellersList->fetch_assoc()): ?>
        <option value="<?=$s['username']?>" <?=$s['username']===$filterSeller?'selected':''?>>
          <?=$s['full_name']?> (<?=$s['username']?>)
        </option>
      <?php endwhile; ?>
    </select>

    <label>ماه:</label>
    <input type="text" id="monthPicker" placeholder="نمایش همه ماه‌ها" readonly>
    <input type="hidden" name="month" id="monthValue" value="<?=htmlspecialchars($filterMonthJ)?>">

    <button type="submit">اعمال فیلتر</button>
  </form>
</section>

<script>
$(function(){
    let currentMonth = "<?=$filterMonthJ?>";
    $("#monthPicker").val(currentMonth || "نمایش همه ماه‌ها");

    $("#monthPicker").persianDatepicker({
        format: "YYYY/MM",
        initialValue: false,
        autoClose: true,
        viewMode: "month",
        onSelect: function(unix){
            let p = new persianDate(unix).format("YYYY/MM");
            $("#monthValue").val(p);
            $("#monthPicker").val(p);
        }
    });
});
</script>

<section class="card">
  <h3>👤 لیست فروشنده‌ها</h3>

  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>فروشنده</th>
          <th>نام کامل</th>
          <th>بیعانه ماه</th>
          <th>برداشت ماه</th>
          <th>مانده فعلی</th>
          <th>وضعیت</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>

      <?php if($sellersRes->num_rows===0): ?>
        <tr><td colspan="7">چیزی پیدا نشد.</td></tr>
      <?php else: ?>

      <?php while($row = $sellersRes->fetch_assoc()): 
            $dep = (int)$row['month_deposit'];
            $wdr = (int)$row['month_withdraw'];
            $bal = (int)$row['balance'];
            $cls = $bal>=0?'pos':'neg';
            $txt = $bal>=0?'مثبت':'بدهکار';
      ?>
        <tr>
          <td><?=htmlspecialchars($row['username'])?></td>
          <td><?=htmlspecialchars($row['full_name'])?></td>
          <td><?=nf($dep)?></td>
          <td><?=nf($wdr)?></td>
          <td><?=nf($bal)?></td>
          <td><span class="badge <?=$cls?>"><?=$txt?></span></td>
          <td>
            <a class="btn" href="seller.php?username=<?=urlencode($row['username'])?>">📄 مشاهده حساب</a>
            <a class="btn ghost" href="edit_seller.php?username=<?=urlencode($row['username'])?>">✏️ ویرایش فروشنده</a>
          </td>
        </tr>
      <?php endwhile; ?>

      <?php endif; ?>

      </tbody>
    </table>
  </div>

</section>

</div>
</body>
</html>
