<?php
session_start();

require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

header("Content-Type: text/plain; charset=utf-8");

if (!isset($_SESSION['username'])) {
    echo "no_session";
    exit;
}

$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

$username = trim($_POST['username'] ?? '');
$amount   = (int)($_POST['amount'] ?? 0);
$method   = trim($_POST['method'] ?? 'bank');
$note     = trim($_POST['note'] ?? '');

if ($username === '') {
    echo "seller_not_found";
    exit;
}

if ($role !== 'admin' && $username !== $login_user) {
    echo "forbidden";
    exit;
}

$q = $mysqli->prepare("SELECT balance FROM users WHERE username=? LIMIT 1");
$q->bind_param("s", $username);
$q->execute();
$res = $q->get_result();

if ($res->num_rows === 0) {
    echo "seller_not_found";
    exit;
}

$current = (int)$res->fetch_assoc()['balance'];

if ($amount <= 0 || $amount > $current) {
    echo "balance_not_enough";
    exit;
}

$stmt = $mysqli->prepare("
INSERT INTO withdrawals (username, order_id, amount, method, note, created_at)
VALUES (?, NULL, ?, ?, ?, NOW())
");
$stmt->bind_param("siss", $username, $amount, $method, $note);
$stmt->execute();

$u = $mysqli->prepare("UPDATE users SET balance = balance - ? WHERE username=?");
$u->bind_param("is", $amount, $username);
$u->execute();

echo "OK";
exit;
