<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $brand = trim($_POST['brand'] ?? '');
    $model = trim($_POST['model'] ?? '');
    $price = (int)($_POST['price'] ?? 0);

    if ($title === '') {
        $error = 'عنوان محصول الزامی است.';
    } else {
        $stmt = $mysqli->prepare("INSERT INTO product (title, brand, model, price) VALUES (?,?,?,?)");
        $stmt->bind_param("sssi", $title, $brand, $model, $price);
        $stmt->execute();
        header("Location: index.php");
        exit;
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>افزودن محصول</title>
<link rel="stylesheet" href="product.css">
</head>
<body>

<div class="product-page narrow">

  <div class="product-header">
    <h1>افزودن محصول جدید</h1>
    <a href="index.php" class="btn-secondary">← بازگشت به لیست</a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-error"><?=$error?></div>
  <?php endif; ?>

  <form method="post" class="product-form">
    <div class="field">
      <label>عنوان محصول<span class="req">*</span></label>
      <input type="text" name="title" required value="<?=htmlspecialchars($title ?? '')?>">
      <small>مثلاً: غذاساز فیلیپس HR7778</small>
    </div>

    <div class="field">
      <label>برند</label>
      <input type="text" name="brand" value="<?=htmlspecialchars($brand ?? '')?>">
      <small>مثلاً: فیلیپس</small>
    </div>

    <div class="field">
      <label>مدل</label>
      <input type="text" name="model" value="<?=htmlspecialchars($model ?? '')?>">
      <small>مثلاً: HR7778</small>
    </div>

    <div class="field">
      <label>قیمت پایه (تومان)</label>
      <input type="number" name="price" min="0" step="1000" value="<?=htmlspecialchars($price ?? 0)?>">
    </div>

    <div class="form-actions">
      <button type="submit" class="btn-primary">ثبت محصول</button>
      <a href="index.php" class="btn-secondary">انصراف</a>
    </div>
  </form>

</div>

</body>
</html>
