<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
$mysqli->set_charset('utf8mb4');

$q = $mysqli->query("SELECT * FROM orders ORDER BY id DESC");

function nf($n){ return number_format((int)$n, 0, '.', ','); }
?>
<!-- ==========================================
     صفحه تحلیل حساب مدیریت
=========================================== -->

<div class="page-wrapper" style="padding:20px;">

<h1 style="margin-bottom:20px;">تحلیل حساب مدیریت</h1>

<!-- ============ خلاصه حساب ============ -->
<div style="
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:16px;
    margin-bottom:20px;
">
  <div style="background:#fff;padding:16px;border-radius:14px;box-shadow:0 0 10px #0001;">
    <h3 style="margin:0 0 6px;font-size:14px;">بدهی به تأمین‌کننده</h3>
    <div class="summary-supplier">—</div>
  </div>
  <div style="background:#fff;padding:16px;border-radius:14px;box-shadow:0 0 10px #0001;">
    <h3 style="margin:0 0 6px;font-size:14px;">بدهی به باربر</h3>
    <div class="summary-carrier">—</div>
  </div>
  <div style="background:#fff;padding:16px;border-radius:14px;box-shadow:0 0 10px #0001;">
    <h3 style="margin:0 0 6px;font-size:14px;">بدهی گارانتی</h3>
    <div class="summary-warranty">—</div>
  </div>
  <div style="background:#fff;padding:16px;border-radius:14px;box-shadow:0 0 10px #0001;">
    <h3 style="margin:0 0 6px;font-size:14px;">سود فروشنده‌ها</h3>
    <div class="summary-seller">—</div>
  </div>
</div>

<!-- ============ جدول اصلی ============ -->
<div style="background:#fff;padding:20px;border-radius:14px;box-shadow:0 0 10px #0001;">

  <h2 style="margin:0 0 10px;">لیست فاکتورها</h2>

  <table style="width:100%;border-collapse:collapse;margin-top:10px;">
    <tr style="background:#f1f1f1;font-weight:bold;">
      <th style="padding:8px">#</th>
      <th style="padding:8px">مدل</th>
      <th style="padding:8px">فروشنده</th>
      <th style="padding:8px">فروش</th>
      <th style="padding:8px">خرید</th>
      <th style="padding:8px">حمل</th>
      <th style="padding:8px">گارانتی</th>
      <th style="padding:8px">سود فروشنده</th>
      <th style="padding:8px">توضیحات</th>
      <th style="padding:8px">ویرایش</th>
    </tr>

<?php while($o = $q->fetch_assoc()): ?>
  <?php
    $note = $o['finance_note'] ?? '';
    $note_short = mb_strlen($note,'UTF-8') > 30 ? mb_substr($note,0,30,'UTF-8').'…' : $note;
  ?>

  <tr data-id="<?= $o['id'] ?>">
    <td style="padding:8px"><?= $o['id'] ?></td>
    <td style="padding:8px"><?= htmlspecialchars($o['model']) ?></td>
    <td style="padding:8px"><?= htmlspecialchars($o['seller']) ?></td>
    <td style="padding:8px" class="col-sale"><?= nf($o['invoice_total']) ?></td>
    <td style="padding:8px" class="col-purchase"><?= nf($o['purchase_price']) ?></td>
    <td style="padding:8px" class="col-delivery"><?= nf($o['delivery_cost']) ?></td>
    <td style="padding:8px" class="col-warranty"><?= nf($o['warranty_cost_company']) ?></td>
    <td style="padding:8px" class="col-seller-profit"><?= nf($o['seller_profit']) ?></td>
    <td style="padding:8px" class="col-note" title="<?= htmlspecialchars($note) ?>">
      <?= htmlspecialchars($note_short) ?>
    </td>
    <td style="padding:8px">
      <button
        class="btn-edit"
        data-id="<?= $o['id'] ?>"
        data-purchase="<?= $o['purchase_price'] ?>"
        data-delivery="<?= $o['delivery_cost'] ?>"
        data-carrierextra="<?= $o['carrier_extra'] ?>"
        data-warranty="<?= $o['warranty_cost_company'] ?>"
        data-sellerprofit="<?= $o['seller_profit'] ?>"
        data-note="<?= htmlspecialchars($note) ?>"
        style="
          background:#2563eb;color:#fff;border:none;
          padding:6px 10px;border-radius:8px;cursor:pointer;
        "
      >ویرایش</button>
    </td>
  </tr>

<?php endwhile; ?>

  </table>
</div>

</div> <!-- page-wrapper -->

<!-- ===========================================================
     مودال پاپ‌آپ ویرایش
=========================================================== -->
<div id="editModal" style="
  position:fixed;inset:0;background:rgba(0,0,0,.35);
  display:none;justify-content:center;align-items:center;z-index:999;
">
  <div style="
    background:#fff;padding:18px;border-radius:14px;
    width:100%;max-width:420px;box-shadow:0 10px 25px #0003;
  ">
    <h2 style="margin-top:0;font-size:16px;">ویرایش مالی فاکتور</h2>

    <form id="editForm">
      <input type="hidden" name="id" id="edit_id">

      <div style="display:grid;grid-template-columns:1fr 1fr;gap:10px;">
        <div>
          <label>خرید</label>
          <input type="number" name="purchase_price" id="edit_purchase"
            style="width:100%;padding:6px;border-radius:8px;border:1px solid #ddd;">
        </div>
        <div>
          <label>حمل</label>
          <input type="number" name="delivery_cost" id="edit_delivery"
            style="width:100%;padding:6px;border-radius:8px;border:1px solid #ddd;">
        </div>
        <div>
          <label>جانبی باربر</label>
          <input type="number" name="carrier_extra" id="edit_carrierextra"
            style="width:100%;padding:6px;border-radius:8px;border:1px solid #ddd;">
        </div>
        <div>
          <label>گارانتی</label>
          <input type="number" name="warranty_cost_company" id="edit_warranty"
            style="width:100%;padding:6px;border-radius:8px;border:1px solid #ddd;">
        </div>
        <div>
          <label>سود فروشنده</label>
          <input type="number" name="seller_profit" id="edit_sellerprofit"
            style="width:100%;padding:6px;border-radius:8px;border:1px solid #ddd;">
        </div>
      </div>

      <div style="margin-top:10px;">
        <label>توضیحات</label>
        <textarea name="finance_note" id="edit_note" style="
          width:100%;min-height:70px;padding:6px;border-radius:8px;border:1px solid #ddd;
        "></textarea>
      </div>

      <div style="margin-top:14px;text-align:left;">
        <button type="button" id="btnCancel"
          style="padding:6px 12px;border-radius:8px;border:none;background:#ddd;cursor:pointer;">
          انصراف
        </button>
        <button type="submit"
          style="padding:6px 12px;border-radius:8px;border:none;background:#16a34a;color:#fff;cursor:pointer;">
          ذخیره
        </button>
      </div>

    </form>
  </div>
</div>

<script>
const modal = document.getElementById("editModal");
const form  = document.getElementById("editForm");

const inId         = document.getElementById("edit_id");
const inPurchase   = document.getElementById("edit_purchase");
const inDelivery   = document.getElementById("edit_delivery");
const inCarrierEx  = document.getElementById("edit_carrierextra");
const inWarranty   = document.getElementById("edit_warranty");
const inSellerProf = document.getElementById("edit_sellerprofit");
const inNote       = document.getElementById("edit_note");

document.querySelectorAll(".btn-edit").forEach(btn=>{
  btn.onclick = ()=>{
    inId.value         = btn.dataset.id;
    inPurchase.value   = btn.dataset.purchase;
    inDelivery.value   = btn.dataset.delivery;
    inCarrierEx.value  = btn.dataset.carrierextra;
    inWarranty.value   = btn.dataset.warranty;
    inSellerProf.value = btn.dataset.sellerprofit;
    inNote.value       = btn.dataset.note;

    modal.style.display = "flex";
  };
});

document.getElementById("btnCancel").onclick = ()=>{
  modal.style.display = "none";
};

modal.onclick = e=>{
  if(e.target === modal) modal.style.display = "none";
};

// AJAX ذخیره
form.onsubmit = e=>{
  e.preventDefault();

  let fd = new FormData(form);

  fetch("ajax_update_order_finance.php", {
    method:"POST",
    body: fd
  })
  .then(r=>r.json())
  .then(j=>{
    if(j.status === "ok"){
      let id = inId.value;
      let tr = document.querySelector(`tr[data-id="${id}"]`);
      if(tr){
        tr.querySelector(".col-purchase").textContent      = j.data.purchase_price_fmt;
        tr.querySelector(".col-delivery").textContent      = j.data.delivery_cost_fmt;
        tr.querySelector(".col-warranty").textContent      = j.data.warranty_cost_company_fmt;
        tr.querySelector(".col-seller-profit").textContent = j.data.seller_profit_fmt;

        tr.querySelector(".col-note").textContent = j.data.note_short;
        tr.querySelector(".col-note").title       = j.data.note_full;
      }
      modal.style.display = "none";
    } else {
      alert(j.message);
    }
  })
  .catch(()=>alert("خطا در ارتباط با سرور"));
};
</script>
